/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.utils;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import com.sina.weibo.sdk.utils.AidTask;
import com.sina.weibo.sdk.utils.MD5;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public class Utility {
    private static final String WEIBO_IDENTITY_ACTION = "com.sina.weibo.action.sdkidentity";
    private static final String DEFAULT_CHARSET = "UTF-8";

    public static Bundle parseUrl(String url) {
        try {
            URL u = new URL(url);
            Bundle b = Utility.decodeUrl(u.getQuery());
            b.putAll(Utility.decodeUrl(u.getRef()));
            return b;
        }
        catch (MalformedURLException e) {
            return new Bundle();
        }
    }

    public static Bundle parseUri(String uri) {
        try {
            URI u = new URI(uri);
            Bundle b = Utility.decodeUrl(u.getQuery());
            return b;
        }
        catch (Exception e) {
            return new Bundle();
        }
    }

    public static Bundle decodeUrl(String s) {
        Bundle params = new Bundle();
        if (s != null) {
            String[] array;
            String[] stringArray = array = s.split("&");
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                String parameter = stringArray[n2];
                String[] v = parameter.split("=");
                try {
                    params.putString(URLDecoder.decode(v[0], DEFAULT_CHARSET), URLDecoder.decode(v[1], DEFAULT_CHARSET));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        return params;
    }

    public static boolean isChineseLocale(Context context) {
        try {
            Locale locale = context.getResources().getConfiguration().locale;
            return Locale.CHINA.equals(locale) || Locale.CHINESE.equals(locale) || Locale.SIMPLIFIED_CHINESE.equals(locale) || Locale.TAIWAN.equals(locale);
        }
        catch (Exception e) {
            return true;
        }
    }

    public static String generateGUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String getSign(Context context, String pkgName) {
        PackageInfo packageInfo;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(pkgName, 64);
        }
        catch (PackageManager.NameNotFoundException localNameNotFoundException) {
            return null;
        }
        int j = 0;
        while (j < packageInfo.signatures.length) {
            byte[] str = packageInfo.signatures[j].toByteArray();
            if (str != null) {
                return MD5.hexdigest(str);
            }
            ++j;
        }
        return null;
    }

    public static String safeString(String orignal) {
        return TextUtils.isEmpty((CharSequence)orignal) ? "" : orignal;
    }

    public static String getAid(Context context, String appKey) {
        AidTask task = AidTask.getInstance(context);
        AidTask.AidInfo aidInfo = task.getAidSync(appKey);
        if (aidInfo != null) {
            return aidInfo.getAid();
        }
        return "";
    }

    public static String generateUA(Context ctx) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(Build.MANUFACTURER).append("-").append(Build.MODEL);
        buffer.append("_");
        buffer.append(Build.VERSION.RELEASE);
        buffer.append("_");
        buffer.append("weibosdk");
        buffer.append("_");
        buffer.append("0031405000");
        buffer.append("_android");
        return buffer.toString();
    }

    public static String generateUAAid(Context ctx) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(Build.MANUFACTURER).append("-").append(Build.MODEL);
        buffer.append("__");
        buffer.append("weibosdk");
        buffer.append("__");
        try {
            String versionCode = "0031405000";
            buffer.append(versionCode.replaceAll("\\s+", "_"));
        }
        catch (Exception localE) {
            buffer.append("unknown");
        }
        buffer.append("__").append("android").append("__android").append(Build.VERSION.RELEASE);
        return buffer.toString();
    }

    public static void openWeiboActivity(Context context, String action, Bundle bundle) {
        try {
            Intent intent = new Intent();
            intent.setAction("android.intent.action.VIEW");
            String appPackage = context.getPackageName();
            intent.putExtra("_weibo_appPackage", appPackage);
            intent.setData(Uri.parse((String)action));
            intent.setFlags(0x10000000);
            intent.putExtras(bundle);
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            // empty catch block
        }
    }

    public static Boolean isWeiBoVersionSupportNewPay(Context context) {
        Intent intent = new Intent(WEIBO_IDENTITY_ACTION);
        intent.addCategory("android.intent.category.DEFAULT");
        List list = context.getPackageManager().queryIntentServices(intent, 0);
        if (list == null || list.isEmpty()) {
            return false;
        }
        int versionCode = 0;
        for (ResolveInfo ri : list) {
            if (ri.serviceInfo == null || ri.serviceInfo.applicationInfo == null || TextUtils.isEmpty((CharSequence)ri.serviceInfo.applicationInfo.packageName)) continue;
            String packageName = ri.serviceInfo.applicationInfo.packageName;
            try {
                versionCode = context.getPackageManager().getPackageInfo((String)packageName, (int)0).versionCode;
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        Boolean isNewVersion = versionCode >= 1920;
        return isNewVersion;
    }
}

