/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.register.mobile;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Message;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import com.sina.weibo.sdk.component.WeiboSdkBrowser;
import com.sina.weibo.sdk.component.view.ResizeableLayout;
import com.sina.weibo.sdk.component.view.TitleBar;
import com.sina.weibo.sdk.exception.WeiboException;
import com.sina.weibo.sdk.net.NetUtils;
import com.sina.weibo.sdk.net.RequestListener;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.register.mobile.SelectCountryActivity;
import com.sina.weibo.sdk.utils.LogUtil;
import com.sina.weibo.sdk.utils.NetworkHelper;
import com.sina.weibo.sdk.utils.ResourceManager;
import com.sina.weibo.sdk.utils.UIUtils;
import java.util.Locale;
import org.json.JSONObject;

public class MobileRegisterActivity
extends Activity
implements View.OnFocusChangeListener,
View.OnClickListener,
ResizeableLayout.SizeChangeListener {
    private static final String TAG = MobileRegisterActivity.class.getName();
    private static final String CANCEL_EN = "Cancel";
    private static final String CANCEL_ZH_CN = "\u53d6\u6d88";
    private static final String CANCEL_ZH_TW = "\u53d6\u6d88";
    private static final String SINA_NOTICE_EN = "By clicking ok, you hereby agree to Weibo Online Service Agreement and Privacy Policy";
    private static final String SINA_NOTICE_ZH_CN = "\u70b9\u51fb\u201c\u786e\u5b9a\u201d\u8868\u793a\u4f60\u540c\u610f\u670d\u52a1\u4f7f\u7528\u534f\u8bae\u548c\u9690\u79c1\u6761\u6b3e\u3002";
    private static final String SINA_NOTICE_ZH_TW = "\u9ede\u64ca\u201c\u78ba\u5b9a\u201d\u6a19\u793a\u4f60\u540c\u610f\u670d\u52d9\u4f7f\u7528\u5354\u8b70\u548c\u96b1\u79c1\u689d\u6b3e\u3002";
    private static final String SINA_SERVICE_EN = "Service By Sina WeiBo";
    private static final String SINA_SERVICE_ZH_CN = "\u6b64\u670d\u52a1\u7531\u5fae\u535a\u63d0\u4f9b";
    private static final String SINA_SERVICE_ZH_TW = "\u6b64\u670d\u52d9\u7531\u5fae\u535a\u63d0\u4f9b";
    private static final String OK_EN = "OK";
    private static final String OK_ZH_CN = "\u786e\u5b9a";
    private static final String OK_ZH_TW = "\u78ba\u5b9a";
    private static final String TITLE_EN = "Login";
    private static final String TITLE_CN = "\u9a8c\u8bc1\u7801\u767b\u5f55";
    private static final String TITLE_TW = "\u9a57\u8b49\u78bc\u767b\u9304";
    private static final String GET_CODE_EN = "Get code";
    private static final String GET_CODE_CN = "\u83b7\u53d6\u9a8c\u8bc1\u7801";
    private static final String GET_CODE_TW = "\u7372\u53d6\u9a57\u8b49\u78bc";
    private static final String APPKEY_NOT_SET_EN = "your appkey not set";
    private static final String APPKEY_NOT_SET_CN = "\u60a8\u7684app_key\u6ca1\u6709\u8bbe\u7f6e";
    private static final String APPKEY_NOT_SET_TW = "\u60a8\u7684app_key\u6c92\u6709\u8a2d\u7f6e";
    private static final String HELP_INFO_EN = "Confirm your country/region and enter your mobile number";
    private static final String HELP_INFO_CN = "\u8bf7\u786e\u8ba4\u56fd\u5bb6\u548c\u5730\u533a\u5e76\u586b\u5199\u624b\u673a\u53f7\u7801";
    private static final String HELP_INFO_TW = "\u8acb\u78ba\u8a8d\u570b\u5bb6\u548c\u5730\u5340\u5e76\u586b\u5beb\u624b\u6a5f\u865f";
    private static final String INPUT_PHONE_NUM_EN = "Your mobile number";
    private static final String INPUT_PHONE_NUM_CN = "\u8bf7\u8f93\u5165\u624b\u673a\u53f7\u7801";
    private static final String INPUT_PHONE_NUM_TW = "\u8acb\u8f38\u5165\u624b\u6a5f\u865f";
    private static final String INPUT_AUTH_CODE_EN = "Verification code";
    private static final String INPUT_AUTH_CODE_CN = "\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801";
    private static final String INPUT_AUTH_CODE_TW = "\u8acb\u8f38\u5165\u9a57\u8b49\u78bc";
    private static final String NETWORK_ERROR_EN = "your network is  disabled  try again later";
    private static final String NETWORK_ERROR_CN = "\u60a8\u7684\u7f51\u7edc\u4e0d\u53ef\u7528\uff0c\u8bf7\u7a0d\u540e";
    private static final String NETWORK_ERROR_TW = "\u60a8\u7684\u7db2\u7d61\u4e0d\u53ef\u7528\uff0c\u8acb\u7a0d\u5f8c";
    private static final String PHONE_ERROR_EN = "Your phone number isn\u2019t 11-digit long";
    private static final String PHONE_ERROR_CN = "\u60a8\u7684\u624b\u673a\u53f7\u4e0d\u662f11\u4f4d\u6570";
    private static final String PHONE_ERROR_TW = "\u60a8\u7684\u624b\u6a5f\u865f\u4e0d\u662f11\u4f4d\u6578";
    private static final String CODE_LENGTH_EN = "Your code isn\u2019t 6-digit long";
    private static final String CODE_LENGTH_CN = "\u4f60\u7684\u9a8c\u8bc1\u7801\u4e0d\u662f6\u4f4d\u6570";
    private static final String CODE_LENGTH_TW = "\u4f60\u7684\u9a57\u8b49\u78bc\u4e0d\u662f6\u4f4d\u6578";
    private static final String WAIT_EN = "please wait .... ";
    private static final String WAIT_CN = "\u6b63\u5728\u5904\u7406\u4e2d.....";
    private static final String WAIT_TW = "\u6b63\u5728\u8655\u7406\u4e2d.....";
    private static final String SERVER_ERROR_EN = "the server is busy, please  wait";
    private static final String SERVER_ERROR_CN = "\u670d\u52a1\u5668\u5fd9,\u8bf7\u7a0d\u540e\u518d\u8bd5";
    private static final String SERVER_ERROR_TW = "\u670d\u52d9\u5668\u5fd9,\u8acb\u7a0d\u5f8c\u518d\u8a66";
    private static final String CHINA_EN = "China";
    private static final String CHINA_CN = "\u4e2d\u56fd";
    private static final String CHINA_TW = "\u4e2d\u570b";
    private static final int EMPTY_VIEW_TEXT_COLOR = -4342339;
    private static final int DEFAULT_BG_COLOR = -855310;
    private static final int MIAN_LINK_TEXT_COLOR = -11502161;
    private static final int LINK_TEXT_COLOR = -8224126;
    private static final int RESIZEABLE_INPUTMETHODHIDE = 0;
    private static final int RESIZEABLE_INPUTMETHODSHOW = 1;
    private static final int DEFAULT_TEXT_PADDING = 12;
    private static final int DEFAULT_TIPS_TEXT_SIZE = 13;
    private static final int DEFAULT_CLEAR_BTN = 22;
    private static final int DEFAULT__RIGHT_TRIANGLE = 13;
    private static final String SEND_MSG = "http://api.weibo.com/oauth2/sms_authorize/send";
    private static final String SEND_SUBMIT = "http://api.weibo.com/oauth2/sms_authorize/submit";
    private static final String SINA_PROTOCOL_URL = "http://weibo.cn/dpool/ttt/h5/regagreement.php?from=h5";
    private static final String SINA_PRIVATE_URL = "http://m.weibo.cn/reg/privacyagreement?from=h5&wm=3349";
    private ProgressDialog mLoadingDlg;
    private TitleBar titleBar;
    private ScrollView mRegistScrollview;
    private LinearLayout mRegiter_llt;
    private TextView mInfoText;
    private RelativeLayout mCountryLayout;
    private TextView mCountryCode;
    private TextView mCountryName;
    private EditText mPhoneNum;
    private ImageView mPhoneNumClearBtn;
    private EditText mCheckCode;
    private Button mGetCodeBtn;
    private TextView mTips;
    private Button mBtnRegist;
    private static final int TITLE_BAR_ID = 1;
    private static final int TRIANGLE_ID = 2;
    private static final int GET_CODE_BTN_ID = 3;
    private static final int PHONE_NUM_CLEAR_BTN_ID = 4;
    public static final String REGISTER_TITLE = "register_title";
    public static final String RESPONSE_OAUTH_TOKEN = "oauth_token";
    public static final String RESPONSE_EXPIRES = "expires";
    private static final int SELECT_COUNTRY_REQUEST_CODE = 0;
    private String mAppkey;
    private String mPackageName;
    private String mKeyHash;
    private String mSpecifyTitle;
    private String mCountryCodeStr;
    private String mCountryNameStr;
    private String cfrom;
    private InputHandler mInputHandler = new InputHandler();
    private int mMaxHeight = 0;
    private CountDownTimer mCountDownTimer;

    protected void onCreate(Bundle bundle) {
        String titleStr;
        super.onCreate(bundle);
        Bundle extras = this.getIntent().getExtras();
        if (extras == null) {
            UIUtils.showToast(this.getApplicationContext(), "Pass wrong params!!", 0);
            this.finish();
        }
        this.mAppkey = extras.getString("appKey");
        this.mPackageName = extras.getString("packagename");
        this.mKeyHash = extras.getString("key_hash");
        if (TextUtils.isEmpty((CharSequence)this.mAppkey)) {
            UIUtils.showToast(this.getApplicationContext(), ResourceManager.getString((Context)this, APPKEY_NOT_SET_EN, APPKEY_NOT_SET_CN, APPKEY_NOT_SET_TW), 0);
            this.finish();
        }
        this.mSpecifyTitle = TextUtils.isEmpty((CharSequence)(titleStr = extras.getString(REGISTER_TITLE))) ? ResourceManager.getString((Context)this, TITLE_EN, TITLE_CN, TITLE_TW) : titleStr;
        this.mCountryCodeStr = "0086";
        this.mCountryNameStr = ResourceManager.getString((Context)this, CHINA_EN, CHINA_CN, CHINA_TW);
        this.initView();
        this.mCountDownTimer = new CountDownTimer(60000L, 1000L){

            public void onTick(long millisUntilFinished) {
                MobileRegisterActivity.this.mGetCodeBtn.setText((CharSequence)(String.valueOf(ResourceManager.getString(MobileRegisterActivity.this.getApplicationContext(), MobileRegisterActivity.GET_CODE_EN, MobileRegisterActivity.GET_CODE_CN, MobileRegisterActivity.GET_CODE_TW)) + "(" + millisUntilFinished / 1000L + "s)"));
            }

            public void onFinish() {
                MobileRegisterActivity.this.mGetCodeBtn.setText((CharSequence)ResourceManager.getString(MobileRegisterActivity.this.getApplicationContext(), MobileRegisterActivity.GET_CODE_EN, MobileRegisterActivity.GET_CODE_CN, MobileRegisterActivity.GET_CODE_TW));
                MobileRegisterActivity.this.enableGetCodeBtn();
            }
        };
    }

    private void initView() {
        ResizeableLayout mobile_regist = new ResizeableLayout((Context)this);
        mobile_regist.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        mobile_regist.setBackgroundColor(-855310);
        this.titleBar = new TitleBar((Context)this);
        this.titleBar.setId(1);
        this.titleBar.setLeftBtnText(ResourceManager.getString((Context)this, CANCEL_EN, "\u53d6\u6d88", "\u53d6\u6d88"));
        this.titleBar.setTitleBarText(this.mSpecifyTitle);
        this.titleBar.setTitleBarClickListener(new TitleBar.ListenerOnTitleBtnClicked(){

            @Override
            public void onLeftBtnClicked() {
                MobileRegisterActivity.this.setResult(0);
                MobileRegisterActivity.this.finish();
            }
        });
        mobile_regist.addView((View)this.titleBar);
        View mDividingLine1 = new View((Context)this);
        RelativeLayout.LayoutParams rllp = new RelativeLayout.LayoutParams(-1, ResourceManager.dp2px((Context)this, 2));
        mDividingLine1.setBackgroundDrawable(ResourceManager.getNinePatchDrawable((Context)this, "weibosdk_common_shadow_top.9.png"));
        rllp.addRule(3, 1);
        mDividingLine1.setLayoutParams((ViewGroup.LayoutParams)rllp);
        mobile_regist.addView(mDividingLine1);
        this.mRegistScrollview = new ScrollView((Context)this);
        RelativeLayout.LayoutParams scly = new RelativeLayout.LayoutParams(-1, -1);
        scly.topMargin = ResourceManager.dp2px((Context)this, 47);
        this.mRegistScrollview.setBackgroundColor(-855310);
        this.mRegistScrollview.setLayoutParams((ViewGroup.LayoutParams)scly);
        this.mRegiter_llt = new LinearLayout((Context)this);
        LinearLayout.LayoutParams mlly = new LinearLayout.LayoutParams(-1, -2);
        this.mRegiter_llt.setOrientation(1);
        this.mRegiter_llt.setLayoutParams((ViewGroup.LayoutParams)mlly);
        this.mInfoText = new TextView((Context)this);
        this.mInfoText.setTextSize(2, 13.0f);
        this.mInfoText.setHeight(ResourceManager.dp2px((Context)this, 44));
        this.mInfoText.setGravity(17);
        this.mInfoText.setTextColor(-8224126);
        this.mInfoText.setText((CharSequence)ResourceManager.getString((Context)this, HELP_INFO_EN, HELP_INFO_CN, HELP_INFO_TW));
        this.mInfoText.setFocusable(true);
        this.mInfoText.setFocusableInTouchMode(true);
        this.mRegiter_llt.addView((View)this.mInfoText);
        this.mCountryLayout = new RelativeLayout((Context)this);
        RelativeLayout.LayoutParams mCountrylp = new RelativeLayout.LayoutParams(-1, ResourceManager.dp2px((Context)this, 48));
        this.mCountryLayout.setBackgroundDrawable((Drawable)ResourceManager.createStateListDrawable((Context)this, "login_country_background.9.png", "login_country_background_highlighted.9.png"));
        this.mCountryLayout.setLayoutParams((ViewGroup.LayoutParams)mCountrylp);
        this.mCountryCode = new TextView((Context)this);
        this.mCountryCode.setTextSize(2, 17.0f);
        this.mCountryCode.setText((CharSequence)"0086");
        this.mCountryCode.setTextColor(-11382190);
        this.mCountryCode.setGravity(3);
        this.mCountryCode.setGravity(16);
        RelativeLayout.LayoutParams mCountryCodelp = new RelativeLayout.LayoutParams(-2, ResourceManager.dp2px((Context)this, 48));
        mCountryCodelp.leftMargin = ResourceManager.dp2px((Context)this, 15);
        mCountryCodelp.addRule(9);
        this.mCountryCode.setLayoutParams((ViewGroup.LayoutParams)mCountryCodelp);
        ImageView mTriangle = new ImageView((Context)this);
        mTriangle.setId(2);
        mTriangle.setImageDrawable(ResourceManager.getDrawable((Context)this, "triangle.png"));
        RelativeLayout.LayoutParams mTriangleImgLp = new RelativeLayout.LayoutParams(ResourceManager.dp2px((Context)this, 13), ResourceManager.dp2px((Context)this, 13));
        mTriangleImgLp.rightMargin = ResourceManager.dp2px((Context)this, 15);
        mTriangleImgLp.addRule(11);
        mTriangleImgLp.addRule(15);
        mTriangle.setLayoutParams((ViewGroup.LayoutParams)mTriangleImgLp);
        this.mCountryName = new TextView((Context)this);
        this.mCountryName.setTextSize(2, 17.0f);
        this.mCountryName.setTextColor(-11382190);
        this.mCountryName.setText((CharSequence)this.mCountryNameStr);
        this.mCountryName.setGravity(16);
        RelativeLayout.LayoutParams mCountryNameLp = new RelativeLayout.LayoutParams(-2, ResourceManager.dp2px((Context)this, 48));
        mCountryNameLp.rightMargin = ResourceManager.dp2px((Context)this, 118);
        mCountryNameLp.addRule(0, 2);
        mCountryNameLp.addRule(15);
        this.mCountryName.setLayoutParams((ViewGroup.LayoutParams)mCountryNameLp);
        this.mCountryLayout.addView((View)this.mCountryCode);
        this.mCountryLayout.addView((View)this.mCountryName);
        this.mCountryLayout.addView((View)mTriangle);
        this.mRegiter_llt.addView((View)this.mCountryLayout);
        LinearLayout mInputLayout = new LinearLayout((Context)this);
        LinearLayout.LayoutParams mInputLayoutlp = new LinearLayout.LayoutParams(-1, -2);
        mInputLayoutlp.topMargin = ResourceManager.dp2px((Context)this, 10);
        mInputLayout.setLayoutParams((ViewGroup.LayoutParams)mInputLayoutlp);
        mInputLayout.setOrientation(1);
        RelativeLayout mPhoneNumLly = new RelativeLayout((Context)this);
        LinearLayout.LayoutParams mPhoneNumLlylp = new LinearLayout.LayoutParams(-1, ResourceManager.dp2px((Context)this, 50));
        mPhoneNumLlylp.gravity = 16;
        mPhoneNumLly.setBackgroundDrawable(ResourceManager.getNinePatchDrawable((Context)this, "login_top_background.9.png"));
        mPhoneNumLly.setLayoutParams((ViewGroup.LayoutParams)mPhoneNumLlylp);
        this.mPhoneNumClearBtn = new ImageView((Context)this);
        this.mPhoneNumClearBtn.setId(4);
        this.mPhoneNumClearBtn.setImageDrawable((Drawable)ResourceManager.createStateListDrawable((Context)this, "search_clear_btn_normal.png", "search_clear_btn_down.png"));
        RelativeLayout.LayoutParams mPhoneNumClearBtnLp = new RelativeLayout.LayoutParams(ResourceManager.dp2px((Context)this, 22), ResourceManager.dp2px((Context)this, 22));
        mPhoneNumClearBtnLp.rightMargin = ResourceManager.dp2px((Context)this, 15);
        mPhoneNumClearBtnLp.addRule(11);
        mPhoneNumClearBtnLp.addRule(15);
        this.mPhoneNumClearBtn.setVisibility(4);
        this.mPhoneNumClearBtn.setLayoutParams((ViewGroup.LayoutParams)mPhoneNumClearBtnLp);
        mPhoneNumLly.addView((View)this.mPhoneNumClearBtn);
        this.mPhoneNum = new EditText((Context)this);
        this.mPhoneNum.setTextSize(2, 16.0f);
        this.mPhoneNum.setTextColor(-16777216);
        this.mPhoneNum.setHint((CharSequence)ResourceManager.getString((Context)this, INPUT_PHONE_NUM_EN, INPUT_PHONE_NUM_CN, INPUT_PHONE_NUM_TW));
        this.mPhoneNum.setHintTextColor(-4342339);
        this.mPhoneNum.setBackgroundDrawable(null);
        this.mPhoneNum.setSelected(false);
        RelativeLayout.LayoutParams mPhoneNumlp = new RelativeLayout.LayoutParams(-1, ResourceManager.dp2px((Context)this, 50));
        mPhoneNumlp.topMargin = ResourceManager.dp2px((Context)this, 0);
        mPhoneNumlp.bottomMargin = ResourceManager.dp2px((Context)this, 0);
        mPhoneNumlp.leftMargin = ResourceManager.dp2px((Context)this, 0);
        mPhoneNumlp.rightMargin = ResourceManager.dp2px((Context)this, 0);
        mPhoneNumlp.addRule(0, 4);
        this.mPhoneNum.setLayoutParams((ViewGroup.LayoutParams)mPhoneNumlp);
        mPhoneNumLly.addView((View)this.mPhoneNum);
        RelativeLayout mCheckCodeLayout = new RelativeLayout((Context)this);
        RelativeLayout.LayoutParams mCheckCodeLayoutlp = new RelativeLayout.LayoutParams(-1, ResourceManager.dp2px((Context)this, 50));
        mCheckCodeLayout.setBackgroundDrawable(ResourceManager.getNinePatchDrawable((Context)this, "login_bottom_background.9.png"));
        mCheckCodeLayout.setLayoutParams((ViewGroup.LayoutParams)mCheckCodeLayoutlp);
        this.mGetCodeBtn = new Button((Context)this);
        this.mGetCodeBtn.setId(3);
        this.mGetCodeBtn.setBackgroundDrawable((Drawable)ResourceManager.createStateListDrawable((Context)this, "get_code_button.9.png", "get_code_button_highlighted.9.png"));
        RelativeLayout.LayoutParams mBtnGetCodeLp = new RelativeLayout.LayoutParams(-2, ResourceManager.dp2px((Context)this, 29));
        mBtnGetCodeLp.rightMargin = ResourceManager.dp2px((Context)this, 12);
        mBtnGetCodeLp.addRule(11);
        mBtnGetCodeLp.addRule(15);
        this.mGetCodeBtn.setPadding(18, 0, 18, 0);
        this.mGetCodeBtn.setLayoutParams((ViewGroup.LayoutParams)mBtnGetCodeLp);
        this.mGetCodeBtn.setText((CharSequence)ResourceManager.getString((Context)this, GET_CODE_EN, GET_CODE_CN, GET_CODE_TW));
        this.mGetCodeBtn.setTextSize(15.0f);
        this.enableGetCodeBtn();
        mCheckCodeLayout.addView((View)this.mGetCodeBtn);
        this.mCheckCode = new EditText((Context)this);
        this.mCheckCode.setTextSize(2, 16.0f);
        this.mCheckCode.setTextColor(-16777216);
        this.mCheckCode.setHintTextColor(-4342339);
        this.mCheckCode.setHint((CharSequence)ResourceManager.getString((Context)this, INPUT_AUTH_CODE_EN, INPUT_AUTH_CODE_CN, INPUT_AUTH_CODE_TW));
        this.mCheckCode.setBackgroundDrawable(null);
        RelativeLayout.LayoutParams mCheckCodelp = new RelativeLayout.LayoutParams(-1, ResourceManager.dp2px((Context)this, 48));
        mCheckCodelp.addRule(0, 3);
        this.mCheckCode.setLayoutParams((ViewGroup.LayoutParams)mCheckCodelp);
        mCheckCodeLayout.addView((View)this.mCheckCode);
        mInputLayout.addView((View)mPhoneNumLly);
        mInputLayout.addView((View)mCheckCodeLayout);
        this.mRegiter_llt.addView((View)mInputLayout);
        this.mGetCodeBtn.setOnClickListener((View.OnClickListener)this);
        this.mTips = new TextView((Context)this);
        this.mTips.setTextSize(2, 13.0f);
        this.mTips.setTextColor(-2014941);
        this.mTips.setText((CharSequence)"");
        this.mTips.setVisibility(4);
        LinearLayout.LayoutParams mTipsLy = new LinearLayout.LayoutParams(-1, ResourceManager.dp2px((Context)this, 36));
        mTipsLy.leftMargin = ResourceManager.dp2px((Context)this, 12);
        this.mTips.setGravity(16);
        this.mTips.setLayoutParams((ViewGroup.LayoutParams)mTipsLy);
        this.mRegiter_llt.addView((View)this.mTips);
        this.mBtnRegist = this.genOKBtn();
        this.disableRegisterBtn();
        this.mRegiter_llt.addView((View)this.mBtnRegist);
        TextView mDeveloperInfo = this.genSinaServiceTv();
        TextView mProtocalInfoTv = this.genProtocalInfoTv();
        this.mRegiter_llt.addView((View)mDeveloperInfo);
        this.mRegiter_llt.addView((View)mProtocalInfoTv);
        this.mRegistScrollview.addView((View)this.mRegiter_llt);
        mobile_regist.addView((View)this.mRegistScrollview);
        this.initLoadingDlg();
        this.mPhoneNum.setInputType(2);
        this.mPhoneNum.addTextChangedListener((TextWatcher)new PhoneNumTextWatcher());
        this.mCheckCode.setInputType(2);
        this.mCheckCode.addTextChangedListener((TextWatcher)new CodeTextWatcher());
        this.mPhoneNumClearBtn.setOnClickListener((View.OnClickListener)this);
        this.mPhoneNum.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        this.mBtnRegist.setOnClickListener((View.OnClickListener)this);
        this.mCountryLayout.setOnClickListener((View.OnClickListener)this);
        mobile_regist.setSizeChangeListener(this);
        this.setContentView((View)mobile_regist);
    }

    private Button genOKBtn() {
        Button btn = new Button((Context)this);
        btn.setBackgroundDrawable((Drawable)ResourceManager.createStateListDrawable((Context)this, "common_button_big_blue.9.png", "common_button_big_blue_highlighted.9.png", "common_button_big_blue_disable.9.png"));
        LinearLayout.LayoutParams mBtnRegistLp = new LinearLayout.LayoutParams(-1, ResourceManager.dp2px((Context)this, 46));
        mBtnRegistLp.leftMargin = mBtnRegistLp.rightMargin = ResourceManager.dp2px((Context)this, 12);
        btn.setText((CharSequence)ResourceManager.getString((Context)this, OK_EN, OK_ZH_CN, OK_ZH_TW));
        btn.setTextSize(17.0f);
        btn.setLayoutParams((ViewGroup.LayoutParams)mBtnRegistLp);
        return btn;
    }

    private TextView genSinaServiceTv() {
        TextView developerInfo = new TextView((Context)this);
        LinearLayout.LayoutParams mDeveloperInfoly = new LinearLayout.LayoutParams(-1, -2);
        mDeveloperInfoly.topMargin = ResourceManager.dp2px((Context)this, 12);
        mDeveloperInfoly.leftMargin = ResourceManager.dp2px((Context)this, 12);
        developerInfo.setLayoutParams((ViewGroup.LayoutParams)mDeveloperInfoly);
        developerInfo.setTextSize(13.0f);
        developerInfo.setGravity(3);
        developerInfo.setTextColor(-8224126);
        developerInfo.setText((CharSequence)ResourceManager.getString((Context)this, SINA_SERVICE_EN, SINA_SERVICE_ZH_CN, SINA_SERVICE_ZH_TW));
        return developerInfo;
    }

    private TextView genProtocalInfoTv() {
        String protocalStr;
        TextView view = new TextView((Context)this);
        view.setTextSize(2, 13.0f);
        LinearLayout.LayoutParams mProtocalInfoly = new LinearLayout.LayoutParams(-1, -2);
        mProtocalInfoly.topMargin = ResourceManager.dp2px((Context)this, 8);
        mProtocalInfoly.leftMargin = ResourceManager.dp2px((Context)this, 12);
        mProtocalInfoly.rightMargin = ResourceManager.dp2px((Context)this, 12);
        view.setLayoutParams((ViewGroup.LayoutParams)mProtocalInfoly);
        view.setTextSize(13.0f);
        view.setGravity(3);
        view.setTextColor(-8224126);
        Locale locale = ResourceManager.getLanguage();
        int protocalStartIndex = -1;
        int protocalEndIndex = -1;
        int privacyStartIndex = -1;
        int privacyEndIndex = -1;
        String notice = SINA_NOTICE_ZH_CN;
        String lang = "zh_CN";
        if (Locale.SIMPLIFIED_CHINESE.equals(locale)) {
            notice = SINA_NOTICE_ZH_CN;
            protocalStr = "\u670d\u52a1\u4f7f\u7528\u534f\u8bae";
            String privacyStr = "\u9690\u79c1\u6761\u6b3e";
            protocalStartIndex = SINA_NOTICE_ZH_CN.indexOf(protocalStr);
            protocalEndIndex = protocalStartIndex + protocalStr.length();
            privacyStartIndex = SINA_NOTICE_ZH_CN.indexOf(privacyStr);
            privacyEndIndex = privacyStartIndex + privacyStr.length();
        } else if (Locale.TRADITIONAL_CHINESE.equals(locale)) {
            notice = SINA_NOTICE_ZH_TW;
            lang = "zh_HK";
            protocalStr = "\u670d\u52d9\u4f7f\u7528\u5354\u8b70";
            String privacyStr = "\u96b1\u79c1\u689d\u6b3e";
            protocalStartIndex = SINA_NOTICE_ZH_TW.indexOf(protocalStr);
            protocalEndIndex = protocalStartIndex + protocalStr.length();
            privacyStartIndex = SINA_NOTICE_ZH_TW.indexOf(privacyStr);
            privacyEndIndex = privacyStartIndex + privacyStr.length();
        } else {
            notice = SINA_NOTICE_EN;
            lang = "en_US";
            protocalStr = "Service Agreement";
            String privacyStr = "Privacy Policy";
            protocalStartIndex = SINA_NOTICE_EN.indexOf(protocalStr);
            protocalEndIndex = protocalStartIndex + protocalStr.length();
            privacyStartIndex = SINA_NOTICE_EN.indexOf(privacyStr);
            privacyEndIndex = privacyStartIndex + privacyStr.length();
        }
        SpannableStringBuilder span = new SpannableStringBuilder((CharSequence)notice);
        if (protocalStartIndex != -1 && protocalEndIndex != -1) {
            span.setSpan((Object)new WBSdkUrlClickSpan((Context)this, "http://weibo.cn/dpool/ttt/h5/regagreement.php?from=h5&lang=" + lang), protocalStartIndex, protocalEndIndex, 33);
        }
        if (privacyStartIndex != -1 && privacyEndIndex != -1) {
            span.setSpan((Object)new WBSdkUrlClickSpan((Context)this, "http://m.weibo.cn/reg/privacyagreement?from=h5&wm=3349&lang=" + lang), privacyStartIndex, privacyEndIndex, 33);
        }
        view.setText((CharSequence)span);
        view.setMovementMethod(LinkMovementMethod.getInstance());
        view.setFocusable(false);
        return view;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 0: {
                if (data == null) break;
                this.mCountryCodeStr = data.getStringExtra("code");
                this.mCountryNameStr = data.getStringExtra("name");
                this.mCountryCode.setText((CharSequence)this.mCountryCodeStr);
                this.mCountryName.setText((CharSequence)this.mCountryNameStr);
            }
        }
    }

    public void onFocusChange(View v, boolean hasFocus) {
        if (v == this.mPhoneNum && !hasFocus) {
            String phoneNumStr = this.mPhoneNum.getText().toString();
            if (this.verifyPhoneNum(phoneNumStr)) {
                this.mTips.setVisibility(4);
            } else {
                this.mTips.setText((CharSequence)ResourceManager.getString((Context)this, PHONE_ERROR_EN, PHONE_ERROR_CN, PHONE_ERROR_TW));
                this.mTips.setVisibility(0);
            }
        }
    }

    private boolean doCheckOnGetMsg(String phoneNum) {
        if (!NetworkHelper.isNetworkAvailable((Context)this)) {
            this.showNetFail();
            return false;
        }
        boolean verified = this.verifyPhoneNum(phoneNum);
        if (!verified) {
            this.mTips.setVisibility(0);
            this.mTips.setText((CharSequence)ResourceManager.getString(this.getApplicationContext(), PHONE_ERROR_EN, PHONE_ERROR_CN, PHONE_ERROR_TW));
            return false;
        }
        this.mTips.setVisibility(4);
        return true;
    }

    private boolean verifyPhoneNum(String phoneNum) {
        if (TextUtils.isEmpty((CharSequence)phoneNum)) {
            return false;
        }
        if ("0086".equals(this.mCountryCodeStr)) {
            return phoneNum.trim().length() == 11;
        }
        return true;
    }

    private boolean doCheckOnSubmit(String checkCodeStr) {
        if (!NetworkHelper.isNetworkAvailable((Context)this)) {
            this.showNetFail();
            return false;
        }
        if (this.verifyCheckCode(checkCodeStr)) {
            this.mTips.setVisibility(4);
            return true;
        }
        this.mTips.setVisibility(0);
        this.mTips.setText((CharSequence)ResourceManager.getString(this.getApplicationContext(), CODE_LENGTH_EN, CODE_LENGTH_CN, CODE_LENGTH_TW));
        UIUtils.showToast(this.getApplicationContext(), ResourceManager.getString(this.getApplicationContext(), CODE_LENGTH_EN, CODE_LENGTH_CN, CODE_LENGTH_TW), 0);
        return false;
    }

    private boolean verifyCheckCode(String checkCodeStr) {
        return !TextUtils.isEmpty((CharSequence)checkCodeStr) && checkCodeStr.length() == 6;
    }

    private void disableGetCodeBtn() {
        this.mGetCodeBtn.setEnabled(false);
        this.mGetCodeBtn.setTextColor(-4342339);
    }

    private void enableGetCodeBtn() {
        this.mGetCodeBtn.setEnabled(true);
        this.mGetCodeBtn.setTextColor(-11502161);
    }

    private void disableRegisterBtn() {
        this.mBtnRegist.setTextColor(0x4DFFFFFF);
        this.mBtnRegist.setEnabled(false);
    }

    private void enableRegisterBtn() {
        this.mBtnRegist.setEnabled(true);
        this.mBtnRegist.setTextColor(-1);
    }

    private void showNetFail() {
        UIUtils.showToast(this.getApplicationContext(), ResourceManager.getString(this.getApplicationContext(), NETWORK_ERROR_EN, NETWORK_ERROR_CN, NETWORK_ERROR_TW), 0);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            this.setResult(0);
            this.finish();
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    public void dismiss() {
        if (this.mLoadingDlg != null && this.mLoadingDlg.isShowing()) {
            this.mLoadingDlg.dismiss();
        }
    }

    private void initLoadingDlg() {
        this.mLoadingDlg = new ProgressDialog((Context)this);
        this.mLoadingDlg.setCanceledOnTouchOutside(false);
        this.mLoadingDlg.requestWindowFeature(1);
        this.mLoadingDlg.setMessage((CharSequence)ResourceManager.getString((Context)this, WAIT_EN, WAIT_CN, WAIT_TW));
    }

    public void getMsg(String phoneNum, String countryCode) {
        WeiboParameters params = new WeiboParameters(this.mAppkey);
        params.put("appkey", this.mAppkey);
        params.put("packagename", this.mPackageName);
        params.put("key_hash", this.mKeyHash);
        params.put("phone", "0086".equals(countryCode) ? phoneNum : String.valueOf(countryCode) + phoneNum);
        params.put("version", "0031405000");
        NetUtils.internalHttpRequest((Context)this, SEND_MSG, params, "GET", new RequestListener(){

            @Override
            public void onWeiboException(WeiboException e) {
                LogUtil.d(TAG, "get onWeiboException " + e.getMessage());
                String error_description = ResourceManager.getString(MobileRegisterActivity.this.getApplicationContext(), MobileRegisterActivity.SERVER_ERROR_EN, MobileRegisterActivity.SERVER_ERROR_CN, MobileRegisterActivity.SERVER_ERROR_TW);
                try {
                    JSONObject res = new JSONObject(e.getMessage());
                    if (!TextUtils.isEmpty((CharSequence)res.optString("error_description"))) {
                        error_description = res.optString("error_description");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                UIUtils.showToast(MobileRegisterActivity.this.getApplicationContext(), error_description, 1);
            }

            @Override
            public void onComplete(String response) {
                LogUtil.d(TAG, "get onComplete : " + response);
                if (response != null) {
                    try {
                        JSONObject res = new JSONObject(response);
                        MobileRegisterActivity.this.cfrom = (String)res.get("cfrom");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void submit(final String phoneNum, String checkCodeStr) {
        WeiboParameters params = new WeiboParameters(this.mAppkey);
        params.put("appkey", this.mAppkey);
        params.put("packagename", this.mPackageName);
        params.put("key_hash", this.mKeyHash);
        params.put("phone", phoneNum);
        params.put("version", "0031405000");
        params.put("code", checkCodeStr);
        params.put("cfrom", this.cfrom);
        this.mLoadingDlg.show();
        NetUtils.internalHttpRequest((Context)this, SEND_SUBMIT, params, "GET", new RequestListener(){

            @Override
            public void onWeiboException(WeiboException e) {
                LogUtil.d(TAG, "get onWeiboException " + e.getMessage());
                String error_description = ResourceManager.getString(MobileRegisterActivity.this.getApplicationContext(), MobileRegisterActivity.SERVER_ERROR_EN, MobileRegisterActivity.SERVER_ERROR_CN, MobileRegisterActivity.SERVER_ERROR_TW);
                try {
                    JSONObject res = new JSONObject(e.getMessage());
                    if (!TextUtils.isEmpty((CharSequence)res.optString("error_description"))) {
                        error_description = res.optString("error_description");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                MobileRegisterActivity.this.mTips.setVisibility(0);
                MobileRegisterActivity.this.mTips.setText((CharSequence)error_description);
                MobileRegisterActivity.this.dismiss();
            }

            @Override
            public void onComplete(String response) {
                MobileRegisterActivity.this.dismiss();
                LogUtil.d(TAG, "get onComplete : " + response);
                if (response != null) {
                    try {
                        JSONObject res = new JSONObject(response);
                        Intent intent = new Intent();
                        Bundle param = new Bundle();
                        param.putString("uid", res.optString("uid"));
                        param.putString("phone_num", phoneNum);
                        param.putString("access_token", res.optString(MobileRegisterActivity.RESPONSE_OAUTH_TOKEN));
                        param.putString("expires_in", res.optString(MobileRegisterActivity.RESPONSE_EXPIRES));
                        intent.putExtras(param);
                        MobileRegisterActivity.this.setResult(-1, intent);
                        MobileRegisterActivity.this.finish();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void onClick(View v) {
        if (v == this.mGetCodeBtn) {
            String phoneNumStr = this.mPhoneNum.getText().toString();
            String countryCode = this.mCountryCode.getText().toString();
            boolean checked = this.doCheckOnGetMsg(phoneNumStr);
            if (checked) {
                this.mCountDownTimer.start();
                this.disableGetCodeBtn();
                this.getMsg(phoneNumStr, countryCode);
            }
        } else if (v == this.mPhoneNumClearBtn) {
            this.mPhoneNum.setText((CharSequence)"");
        } else if (v == this.mBtnRegist) {
            String phoneNumStr = this.mPhoneNum.getText().toString();
            String checkCodeStr = this.mCheckCode.getText().toString();
            if (this.doCheckOnSubmit(checkCodeStr)) {
                this.submit(phoneNumStr, checkCodeStr);
            }
        } else if (v == this.mCountryLayout) {
            this.mTips.setVisibility(4);
            Intent intent = new Intent();
            intent.setClass((Context)this, SelectCountryActivity.class);
            this.startActivityForResult(intent, 0);
        }
    }

    @Override
    public void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        DisplayMetrics dm = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(dm);
        if (dm.widthPixels <= dm.heightPixels) {
            this.mMaxHeight = this.mMaxHeight < height ? height : this.mMaxHeight;
            int change = 0;
            if (height < oldHeight) {
                change = 1;
            } else if (height > oldHeight && height < this.mMaxHeight) {
                change = 1;
            } else if (height == oldHeight && height != this.mMaxHeight) {
                change = 1;
            }
            this.mInputHandler.sendEmptyMessage(change);
        }
    }

    private class CodeTextWatcher
    implements TextWatcher {
        private CodeTextWatcher() {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void afterTextChanged(Editable s) {
            if (TextUtils.isEmpty((CharSequence)MobileRegisterActivity.this.mPhoneNum.getText().toString()) || TextUtils.isEmpty((CharSequence)MobileRegisterActivity.this.mCheckCode.getText().toString())) {
                MobileRegisterActivity.this.disableRegisterBtn();
            } else {
                MobileRegisterActivity.this.enableRegisterBtn();
            }
        }
    }

    private class InputHandler
    extends Handler {
        private InputHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    MobileRegisterActivity.this.mInfoText.setVisibility(0);
                    MobileRegisterActivity.this.mCountryLayout.setVisibility(0);
                    break;
                }
                case 1: {
                    MobileRegisterActivity.this.mInfoText.setVisibility(8);
                    MobileRegisterActivity.this.mCountryLayout.setVisibility(8);
                    break;
                }
            }
        }
    }

    private class PhoneNumTextWatcher
    implements TextWatcher {
        private PhoneNumTextWatcher() {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            if (TextUtils.isEmpty((CharSequence)MobileRegisterActivity.this.mPhoneNum.getText().toString())) {
                MobileRegisterActivity.this.mPhoneNumClearBtn.setVisibility(4);
            } else {
                MobileRegisterActivity.this.mPhoneNumClearBtn.setVisibility(0);
            }
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void afterTextChanged(Editable s) {
            if (TextUtils.isEmpty((CharSequence)MobileRegisterActivity.this.mPhoneNum.getText().toString()) || TextUtils.isEmpty((CharSequence)MobileRegisterActivity.this.mCheckCode.getText().toString())) {
                MobileRegisterActivity.this.disableRegisterBtn();
            } else {
                MobileRegisterActivity.this.enableRegisterBtn();
            }
        }
    }

    private class WBSdkUrlClickSpan
    extends ClickableSpan {
        private Context context;
        private String url;

        public WBSdkUrlClickSpan(Context ctx, String url) {
            this.context = ctx;
            this.url = url;
        }

        public void onClick(View widget) {
            Intent intent = new Intent(this.context, WeiboSdkBrowser.class);
            Bundle data = new Bundle();
            data.putString("key_url", this.url);
            intent.putExtras(data);
            MobileRegisterActivity.this.startActivity(intent);
        }

        public void updateDrawState(TextPaint ds) {
            ds.setColor(-11502161);
            ds.setUnderlineText(false);
        }
    }
}

