/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.component;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import com.sina.weibo.sdk.auth.WeiboAuthListener;
import com.sina.weibo.sdk.component.BrowserLauncher;
import com.sina.weibo.sdk.component.BrowserRequestParamBase;
import com.sina.weibo.sdk.component.WeiboCallbackManager;

public class GameRequestParam
extends BrowserRequestParamBase {
    private WeiboAuthListener mAuthListener;
    private String mAuthListenerKey;
    private String mToken;
    private String mAppKey;

    public GameRequestParam(Context context) {
        super(context);
        this.mLaucher = BrowserLauncher.WIDGET;
    }

    @Override
    protected void onSetupRequestParam(Bundle data) {
        this.mAppKey = data.getString("source");
        this.mToken = data.getString("access_token");
        this.mAuthListenerKey = data.getString("key_listener");
        if (!TextUtils.isEmpty((CharSequence)this.mAuthListenerKey)) {
            this.mAuthListener = WeiboCallbackManager.getInstance(this.mContext).getWeiboAuthListener(this.mAuthListenerKey);
        }
        String baseUrl = this.mUrl;
        this.mUrl = this.buildUrl(baseUrl);
    }

    @Override
    public void onCreateRequestParamBundle(Bundle data) {
        data.putString("access_token", this.mToken);
        data.putString("source", this.mAppKey);
        WeiboCallbackManager manager = WeiboCallbackManager.getInstance(this.mContext);
        if (this.mAuthListener != null) {
            this.mAuthListenerKey = manager.genCallbackKey();
            manager.setWeiboAuthListener(this.mAuthListenerKey, this.mAuthListener);
            data.putString("key_listener", this.mAuthListenerKey);
        }
    }

    private String buildUrl(String baseUrl) {
        Uri uri = Uri.parse((String)baseUrl);
        Uri.Builder builder = uri.buildUpon();
        builder.appendQueryParameter("version", "0031405000");
        if (!TextUtils.isEmpty((CharSequence)this.mAppKey)) {
            builder.appendQueryParameter("source", this.mAppKey);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mToken)) {
            builder.appendQueryParameter("access_token", this.mToken);
        }
        return builder.build().toString();
    }

    public String getToken() {
        return this.mToken;
    }

    public void setToken(String mToken) {
        this.mToken = mToken;
    }

    public String getAppKey() {
        return this.mAppKey;
    }

    public void setAppKey(String mAppKey) {
        this.mAppKey = mAppKey;
    }

    public WeiboAuthListener getAuthListener() {
        return this.mAuthListener;
    }

    public String getAuthListenerKey() {
        return this.mAuthListenerKey;
    }

    public void setAuthListener(WeiboAuthListener mAuthListener) {
        this.mAuthListener = mAuthListener;
    }

    @Override
    public void execRequest(Activity act, int action) {
    }

    public static interface WidgetRequestCallback {
        public void onWebViewResult(String var1);
    }
}

