/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.share.sdk.openapi;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Bundle;
import android.util.Log;
import com.alipay.share.sdk.Constant;
import com.alipay.share.sdk.openapi.BaseReq;
import com.alipay.share.sdk.openapi.IAPAPIEventHandler;
import com.alipay.share.sdk.openapi.IAPApi;
import com.alipay.share.sdk.openapi.SendMessageToZFB;
import com.alipay.share.sdk.openapi.algorithm.MD5;
import com.alipay.share.sdk.openapi.channel.APMessage;
import com.alipay.share.sdk.openapi.channel.APMessageAct;
import com.alipay.share.sdk.plugin.APVersionCheck;

public class APApiImlV1
implements IAPApi {
    private static final String TAG = "Alipay.SDK.ZFBApiImlV1";
    private Context context;
    private String appId;
    private boolean needSignatureCheck;

    public APApiImlV1(Context context, String appId) {
        this(context, appId, false);
    }

    public APApiImlV1(Context context, String appId, boolean needSignatureCheck) {
        this.context = context;
        this.appId = appId;
        this.needSignatureCheck = needSignatureCheck;
    }

    @Override
    public boolean registerApp(String appId) {
        if (!this.checkSumConsistent("com.eg.android.AlipayGphone")) {
            Log.e((String)TAG, (String)"register app failed for alipay app signature check failed");
            return false;
        }
        if (appId != null) {
            this.appId = appId;
        }
        Log.d((String)TAG, (String)("register app " + this.context.getPackageName()));
        APMessage.send(this.context, "com.eg.android.AlipayGphone", Constant.PERMISSION_ACTION_HANDLE_APP_REGISTER, String.valueOf(Constant.ACTION_APP_REGISTER) + appId);
        return true;
    }

    @Override
    public void unregisterApp() {
        if (!this.checkSumConsistent("com.eg.android.AlipayGphone")) {
            Log.e((String)TAG, (String)"unregister app failed for alipay app signature check failed");
        } else if (this.appId != null && this.appId.length() != 0) {
            Log.d((String)TAG, (String)("unregister app " + this.context.getPackageName()));
            APMessage.send(this.context, "com.eg.android.AlipayGphone", Constant.PERMISSION_ACTION_HANDLE_APP_UNREGISTER, String.valueOf(Constant.ACTION_APP_UNREGISTER) + this.appId);
        } else {
            Log.e((String)TAG, (String)"unregisterApp fail, appId is empty");
        }
    }

    @Override
    public boolean isZFBAppInstalled() {
        try {
            PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo("com.eg.android.AlipayGphone", 64);
            return packageInfo != null && this.checkSumConsistent(packageInfo.signatures);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    @Override
    public final boolean handleIntent(Intent intent, IAPAPIEventHandler apiEventHandler) {
        String messageContent = intent.getStringExtra(Constant.EXTRA_MESSAGE_CONTENT);
        int messageSdkVersion = intent.getIntExtra(Constant.EXTRA_MESSAGE_SDK_VERSION, 0);
        String packageName = intent.getStringExtra(Constant.EXTRA_MESSAGE_APP_PACKAGE_NAME);
        if (packageName != null && packageName.length() != 0) {
            byte[] checkSums = intent.getByteArrayExtra(Constant.EXTRA_MESSAGE_CHECK_SUM);
            StringBuffer stringBuffer = new StringBuffer();
            if (messageContent != null) {
                stringBuffer.append(messageContent);
            }
            stringBuffer.append(messageSdkVersion);
            stringBuffer.append(packageName);
            stringBuffer.append("alipay");
            byte[] reCheckSum = MD5.getMessageDigest(stringBuffer.toString().substring(1, 9).getBytes()).getBytes();
            if (!APApiImlV1.checkSumConsistent(checkSums, reCheckSum)) {
                Log.e((String)TAG, (String)"checksum fail");
                return false;
            }
            switch (intent.getIntExtra(Constant.EXTRA_COMMAND_TYPE, 0)) {
                case 1: {
                    SendMessageToZFB.Resp resp = new SendMessageToZFB.Resp(intent.getExtras());
                    apiEventHandler.onResp(resp);
                    return true;
                }
                case 2: {
                    SendMessageToZFB.Resp resp1 = new SendMessageToZFB.Resp(intent.getExtras());
                    apiEventHandler.onResp(resp1);
                    return true;
                }
                case 3: {
                    SendMessageToZFB.Req req = new SendMessageToZFB.Req(intent.getExtras());
                    apiEventHandler.onReq(req);
                    return true;
                }
                case 4: {
                    SendMessageToZFB.Req req1 = new SendMessageToZFB.Req(intent.getExtras());
                    apiEventHandler.onReq(req1);
                    return true;
                }
            }
            return false;
        }
        Log.e((String)TAG, (String)"invalid argument");
        return false;
    }

    @Override
    public boolean isZFBSupportAPI() {
        return this.getZFBSupportAPI() >= 20150630;
    }

    @Override
    public int getZFBSupportAPI() {
        if (!this.isZFBAppInstalled()) {
            Log.e((String)TAG, (String)"open wx app failed, not installed or signature check failed");
            return 0;
        }
        return new APVersionCheck(this.context).getZFBSupportVersion(0);
    }

    @Override
    public boolean openZFBApp() {
        if (!this.isZFBAppInstalled()) {
            Log.e((String)TAG, (String)"open Alipay app failed, not installed or signature check failed");
            return false;
        }
        try {
            this.context.startActivity(this.context.getPackageManager().getLaunchIntentForPackage("com.eg.android.AlipayGphone"));
            return true;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("start Alipay Main Activity fail, exception = " + exception.getMessage()));
            return false;
        }
    }

    @Override
    public boolean sendReq(BaseReq req) {
        if (!this.checkSumConsistent("com.eg.android.AlipayGphone")) {
            Log.e((String)TAG, (String)"sendReq failed for alipay app signature check failed");
            return false;
        }
        if (!req.checkArgs()) {
            Log.e((String)TAG, (String)"sendReq checkArgs fail");
            return false;
        }
        Bundle bundle = new Bundle();
        req.toBundle(bundle);
        return APMessageAct.sendToZFB(this.context, String.valueOf(Constant.SEND_REQUEST_CONTENT_APPID) + this.appId, bundle);
    }

    private boolean checkSumConsistent(String packageName) {
        PackageInfo packageInfo;
        if (!this.needSignatureCheck) {
            Log.d((String)TAG, (String)"ignore alipay app signature validation");
            return true;
        }
        try {
            packageInfo = this.context.getPackageManager().getPackageInfo(packageName, 64);
        }
        catch (PackageManager.NameNotFoundException exception) {
            return false;
        }
        return this.checkSumConsistent(packageInfo.signatures);
    }

    private boolean checkSumConsistent(Signature[] signatures) {
        if (!this.needSignatureCheck) {
            Log.d((String)TAG, (String)"ignore alipay app signature validation");
            return true;
        }
        Signature[] signatureArray = signatures;
        int n = signatures.length;
        int n2 = 0;
        while (n2 < n) {
            Signature signature1 = signatureArray[n2];
            String signature = signature1.toCharsString();
            Log.d((String)TAG, (String)("check signature:" + signature));
            if (signature.equals("30820244308201ad02044b28a3c9300d06092a864886f70d01010405003068310b300906035504061302636e3110300e060355040813076265696a696e673110300e060355040713076265696a696e67310f300d060355040a1306616c69706179310f300d060355040b1306616c69706179311330110603550403130a73686971756e2e7368693020170d3039313231363039303932395a180f32303531303131303039303932395a3068310b300906035504061302636e3110300e060355040813076265696a696e673110300e060355040713076265696a696e67310f300d060355040a1306616c69706179310f300d060355040b1306616c69706179311330110603550403130a73686971756e2e73686930819f300d06092a864886f70d010101050003818d0030818902818100b6cbad6cbd5ed0d209afc69ad3b7a617efaae9b3c47eabe0be42d924936fa78c8001b1fd74b079e5ff9690061dacfa4768e981a526b9ca77156ca36251cf2f906d105481374998a7e6e6e18f75ca98b8ed2eaf86ff402c874cca0a263053f22237858206867d210020daa38c48b20cc9dfd82b44a51aeb5db459b22794e2d6490203010001300d06092a864886f70d010104050003818100b6b5e3854b2d5daaa02d127195d13a1927991176047982feaa3d1625740788296443e9000fe14dfe6701d7e86be06b9282e68d4eff32b19d48555b8a0838a6e146238f048aca986715d7eab0fb445796bbd19360a7721b8d99ba04581af957a290c47302055f813862f3c40b840e95898e72a1de03b6257a1acad4b482cd815c")) {
                Log.d((String)TAG, (String)"checkSumConsistent pass");
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean checkSumConsistent(byte[] bytes, byte[] bytes1) {
        if (bytes != null && bytes.length != 0 && bytes1 != null && bytes1.length != 0) {
            if (bytes.length != bytes1.length) {
                Log.e((String)TAG, (String)"checkSumConsistent fail, length is different");
                return false;
            }
            int var2 = 0;
            while (var2 < bytes.length) {
                if (bytes[var2] != bytes1[var2]) {
                    return false;
                }
                ++var2;
            }
            return true;
        }
        Log.e((String)TAG, (String)"checkSumConsistent fail, invalid arguments");
        return false;
    }
}

