/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.shareboard.wigets;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.umeng.socialize.common.ResContainer;
import com.umeng.socialize.shareboard.wigets.ActionFrameAdapter;
import com.umeng.socialize.utils.Log;

public class UMActionFrame
extends ViewGroup {
    private static final int ABANDON = 3;
    private static final int OCCUPIED = 1;
    private static final int COVER = 2;
    private int mColumn = 4;
    private int mRow = 0;
    private int[][] mOccupied = null;
    private ActionFrameAdapter mAdapter;
    private int mHeight;
    private int mWidth;
    private int mDividerColor = 0;
    private int mCoverColor = -1;
    private int mDividerSize = 2;
    private Context mContext = null;

    public UMActionFrame(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        int colorId = ResContainer.get((Context)context).color("umeng_socialize_grid_divider_line");
        this.mDividerColor = context.getResources().getColor(colorId);
        this.mContext = context;
    }

    public UMActionFrame(Context context, AttributeSet attrs) {
        super(context, attrs);
        int colorId = ResContainer.get((Context)context).color("umeng_socialize_grid_divider_line");
        this.mDividerColor = context.getResources().getColor(colorId);
        this.mContext = context;
    }

    public UMActionFrame(Context context) {
        super(context);
        int colorId = ResContainer.get((Context)context).color("umeng_socialize_grid_divider_line");
        this.mDividerColor = context.getResources().getColor(colorId);
        this.mContext = context;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.mAdapter == null) {
            return;
        }
        Context context = this.getContext();
        int childCount = this.mAdapter.getCount();
        this.calculateOccupied(childCount);
        this.removeAllViews();
        int matrixX = this.mOccupied.length;
        int matrixY = this.mOccupied[0].length;
        int stepX = (this.mWidth - (matrixX - 1) * this.mDividerSize) / matrixX;
        int stepY = (this.mHeight - (matrixY - 1) * this.mDividerSize) / matrixY;
        int dividerLenX = 0;
        int dividerLenY = 0;
        int childPos = 0;
        for (int i = 0; i < matrixY; ++i) {
            boolean bb;
            for (int j = 0; j < matrixX; ++j) {
                View view;
                ViewGroup.LayoutParams params;
                if (this.mOccupied[j][i] != 1) continue;
                if ((params = (view = this.mAdapter.getView(childPos++, this)).getLayoutParams()) == null) {
                    params = new ViewGroup.LayoutParams(stepX, stepY);
                    view.setLayoutParams(params);
                } else {
                    params.height = stepY;
                    params.width = stepX;
                }
                boolean isLastX = j == matrixX - 1;
                int left = j * stepX + dividerLenX;
                int right = left + stepX;
                int top = i * stepY + dividerLenY;
                int bottom = top + stepY;
                this.addView(view);
                this.measureChild(view, stepX, stepY);
                view.layout(left, top, right, bottom);
                if (!isLastX && this.mOccupied[j + 1][i] == 2) {
                    View coverView = new View(context);
                    coverView.setBackgroundColor(this.mCoverColor);
                    this.addView(coverView);
                    coverView.layout(left + stepX, top, r, bottom);
                }
                View dividerView = new View(context);
                if (!isLastX) {
                    dividerView.setBackgroundColor(this.mDividerColor);
                    dividerLenX += this.mDividerSize;
                } else {
                    dividerView.setBackgroundColor(this.mCoverColor);
                    dividerLenX = 0;
                }
                this.addView(dividerView);
                dividerView.layout(left + stepX, top, right + this.mDividerSize, bottom);
            }
            boolean bl = i > 0 ? this.mOccupied[0][i - 1] == 1 : (bb = false);
            if (bb) {
                View dividerView = new View(context);
                dividerView.setBackgroundColor(this.mDividerColor);
                this.addView(dividerView);
                int top = dividerLenY + i * stepY;
                dividerView.layout(l, top - this.mDividerSize, r, top);
            }
            dividerLenX = 0;
            dividerLenY += this.mDividerSize;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.mWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.setMeasuredDimension(this.mWidth, this.mHeight);
    }

    public void calculateOccupied(int cell) {
        int x = this.mOccupied.length;
        int y = this.mOccupied[0].length;
        int mDimen = x * y;
        int available = cell > mDimen ? mDimen : cell;
        int remNum = available % x;
        int cover = remNum > 0 ? x - remNum : 0;
        int abandon = mDimen - available - cover;
        int startCover = abandon + available;
        int pos = 0;
        for (int i = 0; i < y; ++i) {
            for (int j = 0; j < x; ++j) {
                this.mOccupied[j][i] = pos >= abandon && pos < startCover ? 1 : (pos >= startCover ? 2 : 3);
                ++pos;
            }
        }
    }

    public ActionFrameAdapter getAdapter() {
        return this.mAdapter;
    }

    private void initRowAndColumnWithConfig() {
        if (this.mContext == null || this.mAdapter == null) {
            this.mOccupied = new int[4][2];
            return;
        }
        if (this.mContext.getResources().getConfiguration().orientation == 2) {
            this.mColumn = 6;
        }
        int totalPlatforms = this.mAdapter.getCount();
        this.mRow = this.mAdapter.getCount() / this.mColumn;
        if (totalPlatforms % this.mColumn > 0) {
            ++this.mRow;
        }
        Log.d((String)"", (String)("###### row = " + this.mRow + ", column = " + this.mColumn));
        this.mOccupied = new int[this.mColumn][this.mRow];
    }

    public void setAdapter(ActionFrameAdapter mAdapter) {
        this.mAdapter = mAdapter;
        this.initRowAndColumnWithConfig();
        this.requestLayout();
    }

    public void setDividerColor(int dividerColor) {
        this.mDividerColor = dividerColor;
    }

    public void setCoverColor(int coverColor) {
        this.mCoverColor = coverColor;
    }

    public void setDividerSize(int dividerSize) {
        this.mDividerSize = dividerSize;
    }

    public int getAdapterHeight(int width) {
        int side = (width - (this.mColumn - 1) * this.mDividerSize) / this.mColumn;
        int height = side * this.mRow + (this.mRow - 1) * this.mDividerSize;
        return height;
    }
}

