/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.shareboard.Adapter;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.common.ResContainer;
import com.umeng.socialize.shareboard.ShareBoard;
import com.umeng.socialize.shareboard.SnsPlatform;
import com.umeng.socialize.shareboard.wigets.ActionFrameAdapter;
import com.umeng.socialize.utils.DeviceConfig;
import java.util.ArrayList;
import java.util.List;

public class SNSPlatformAdapter
extends ActionFrameAdapter {
    private List<SnsPlatform> platforms = new ArrayList<SnsPlatform>();
    private Context mContext;
    private ShareBoard shareBoard;

    public SNSPlatformAdapter(Context context, List<SnsPlatform> platforms, ShareBoard shareBoard) {
        this.platforms = platforms;
        this.mContext = context;
        this.shareBoard = shareBoard;
    }

    private void initShareBoardItem(View snsItemView, SnsPlatform snsPlatform) {
        ImageView imgeView = (ImageView)snsItemView.findViewById(ResContainer.getResourceId((Context)this.mContext, (String)"id", (String)"umeng_socialize_shareboard_image"));
        imgeView.setImageResource(ResContainer.getResourceId((Context)this.mContext, (String)"drawable", (String)snsPlatform.mIcon));
        TextView platformNameTextView = (TextView)snsItemView.findViewById(ResContainer.getResourceId((Context)this.mContext, (String)"id", (String)"umeng_socialize_shareboard_pltform_name"));
        platformNameTextView.setText((CharSequence)ResContainer.getString((Context)this.mContext, (String)snsPlatform.mShowWord));
    }

    private void shareClick(SnsPlatform snsPlatform, SHARE_MEDIA platform) {
        if (snsPlatform != null && this.shareBoard.getShareBoardlistener() != null) {
            this.shareBoard.getShareBoardlistener().onclick(snsPlatform, platform);
        }
    }

    @Override
    public Object getItem(int position) {
        return this.platforms == null ? null : this.platforms.get(position);
    }

    @Override
    public int getCount() {
        return this.platforms == null ? 0 : this.platforms.size();
    }

    @Override
    public View getView(int position, ViewGroup parent) {
        final SnsPlatform snsPlatform = this.platforms.get(position);
        final View snsItemView = View.inflate((Context)this.mContext, (int)ResContainer.getResourceId((Context)this.mContext, (String)"layout", (String)"umeng_socialize_shareboard_item"), null);
        this.initShareBoardItem(snsItemView, snsPlatform);
        snsItemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SNSPlatformAdapter.this.shareBoard.dismiss();
                SHARE_MEDIA platform = snsPlatform.mPlatform;
                if (!DeviceConfig.isNetworkAvailable((Context)SNSPlatformAdapter.this.mContext) && platform != SHARE_MEDIA.SMS) {
                    Toast.makeText((Context)SNSPlatformAdapter.this.mContext, (CharSequence)"\u60a8\u7684\u7f51\u7edc\u4e0d\u53ef\u7528,\u8bf7\u68c0\u67e5\u7f51\u7edc\u8fde\u63a5...", (int)0).show();
                    return;
                }
                SNSPlatformAdapter.this.shareClick(snsPlatform, platform);
            }
        });
        snsItemView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 0) {
                    snsItemView.setBackgroundColor(-3355444);
                } else if (event.getAction() == 1) {
                    snsItemView.setBackgroundColor(-1);
                }
                return false;
            }
        });
        snsItemView.setFocusable(true);
        return snsItemView;
    }
}

