/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.editorpage;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.RelativeLayout;

public class KeyboardListenRelativeLayout
extends RelativeLayout {
    public static final byte KEYBOARD_STATE_SHOW = -3;
    public static final byte KEYBOARD_STATE_HIDE = -2;
    public static final byte KEYBOARD_STATE_INIT = -1;
    private boolean mHasInit = false;
    private boolean mHasKeyboard = false;
    private int mHeight;
    private IOnKeyboardStateChangedListener mOnKeyboardStateChangedListener;

    public KeyboardListenRelativeLayout(Context context) {
        super(context);
    }

    public KeyboardListenRelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public KeyboardListenRelativeLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setOnKeyboardStateChangedListener(IOnKeyboardStateChangedListener onKeyboardStateChangedListener) {
        this.mOnKeyboardStateChangedListener = onKeyboardStateChangedListener;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (!this.mHasInit) {
            this.mHasInit = true;
            this.mHeight = b;
            if (this.mOnKeyboardStateChangedListener != null) {
                this.mOnKeyboardStateChangedListener.onKeyboardStateChanged(-1);
            }
        } else {
            int n = this.mHeight = this.mHeight < b ? b : this.mHeight;
        }
        if (this.mHasInit && this.mHeight > b) {
            this.mHasKeyboard = true;
            if (this.mOnKeyboardStateChangedListener != null) {
                this.mOnKeyboardStateChangedListener.onKeyboardStateChanged(-3);
            }
        }
        if (this.mHasInit && this.mHasKeyboard && this.mHeight == b) {
            this.mHasKeyboard = false;
            if (this.mOnKeyboardStateChangedListener != null) {
                this.mOnKeyboardStateChangedListener.onKeyboardStateChanged(-2);
            }
        }
    }

    public static interface IOnKeyboardStateChangedListener {
        public void onKeyboardStateChanged(int var1);
    }
}

