/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.view;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.FrameLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.umeng.socialize.Config;
import com.umeng.socialize.SocializeException;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.common.ResContainer;
import com.umeng.socialize.net.utils.AesHelper;
import com.umeng.socialize.utils.DeviceConfig;
import com.umeng.socialize.utils.Log;
import com.umeng.socialize.utils.SocializeUtils;
import com.umeng.socialize.utils.URLBuilder;
import java.lang.reflect.Method;
import java.util.Set;

public class OauthDialog
extends Dialog {
    private static final String TAG = "OauthDialog";
    private final ResContainer R;
    private WebView mWebView;
    private View mContent;
    private View mProgressbar;
    private CheckBox mFollowCheck;
    private int mFlag = 0;
    private Bundle mValues;
    private String mWaitUrl = "error";
    private Context mContext;
    private Activity mActivity;
    private SHARE_MEDIA mPlatform;
    private Set<String> mFollows;
    private AuthListenerWrapper mListener;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (msg.what == 1 && OauthDialog.this.mProgressbar != null) {
                OauthDialog.this.mProgressbar.setVisibility(8);
            }
            if (msg.what == 2) {
                // empty if block
            }
        }
    };

    public OauthDialog(Activity activity, SHARE_MEDIA platform, UMAuthListener listener) {
        super((Context)activity, ResContainer.get((Context)activity).style("umeng_socialize_popup_dialog"));
        boolean validPlatform;
        this.mContext = activity.getApplicationContext();
        this.R = ResContainer.get((Context)this.mContext);
        this.mActivity = activity;
        this.mPlatform = platform;
        this.mListener = new AuthListenerWrapper(listener, platform);
        this.setOwnerActivity(activity);
        LayoutInflater inflater = (LayoutInflater)this.mActivity.getSystemService("layout_inflater");
        int layoutId = this.R.layout("umeng_socialize_oauth_dialog");
        int followId = this.R.id("umeng_socialize_follow");
        int checkId = this.R.id("umeng_socialize_follow_check");
        this.mContent = inflater.inflate(layoutId, null);
        final View cuArea = this.mContent.findViewById(followId);
        this.mFollowCheck = (CheckBox)this.mContent.findViewById(checkId);
        boolean hasFollow = this.mFollows != null && this.mFollows.size() > 0;
        boolean bl = validPlatform = platform == SHARE_MEDIA.SINA || platform == SHARE_MEDIA.TENCENT;
        if (hasFollow && validPlatform) {
            cuArea.setVisibility(0);
        } else {
            cuArea.setVisibility(8);
        }
        int progressbarId = this.R.id("progress_bar_parent");
        int barleftfbtnId = this.R.id("umeng_socialize_title_bar_leftBt");
        int barrightbtnId = this.R.id("umeng_socialize_title_bar_rightBt");
        int barmiddletxtId = this.R.id("umeng_socialize_title_bar_middleTv");
        int barId = this.R.id("umeng_socialize_titlebar");
        this.mProgressbar = this.mContent.findViewById(progressbarId);
        this.mProgressbar.setVisibility(0);
        Button titleLeftBt = (Button)this.mContent.findViewById(barleftfbtnId);
        titleLeftBt.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OauthDialog.this.dismiss();
            }
        });
        this.mContent.findViewById(barrightbtnId).setVisibility(8);
        TextView titleMidTv = (TextView)this.mContent.findViewById(barmiddletxtId);
        String name = null;
        if (platform.toString().equals("SINA")) {
            name = "\u5fae\u535a";
        } else if (platform.toString().equals("RENREN")) {
            name = "\u4eba\u4eba\u7f51";
        } else if (platform.toString().equals("DOUBAN")) {
            name = "\u8c46\u74e3";
        } else if (platform.toString().equals("TENCENT")) {
            name = "\u817e\u8baf\u5fae\u535a";
        }
        titleMidTv.setText((CharSequence)("\u6388\u6743" + name));
        this.setUpWebView();
        final View titleBar = this.mContent.findViewById(barId);
        final int minHeight = SocializeUtils.dip2Px((Context)this.mContext, (float)200.0f);
        FrameLayout checkView = new FrameLayout(this.mContext){

            protected void onSizeChanged(int w, int h, int oldw, int oldh) {
                super.onSizeChanged(w, h, oldw, oldh);
                if (!SocializeUtils.isFloatWindowStyle((Context)OauthDialog.this.mContext)) {
                    this.notifyTitleChanged(cuArea, titleBar, minHeight, h);
                }
            }

            private void notifyTitleChanged(final View cuArea2, final View titleBar2, int minHeight2, int h) {
                if (titleBar2.getVisibility() == 0 && h < minHeight2) {
                    OauthDialog.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            titleBar2.setVisibility(8);
                            if (cuArea2.getVisibility() == 0) {
                                cuArea2.setVisibility(8);
                            }
                            this.requestLayout();
                        }
                    });
                } else if (titleBar2.getVisibility() != 0 && h >= minHeight2) {
                    OauthDialog.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            titleBar2.setVisibility(0);
                            if (cuArea2.getVisibility() != 0 && OauthDialog.this.mFollows != null && OauthDialog.this.mFollows.size() > 0) {
                                cuArea2.setVisibility(0);
                            }
                            this.requestLayout();
                        }
                    });
                }
            }
        };
        checkView.addView(this.mContent, -1, -1);
        this.setContentView((View)checkView);
        WindowManager.LayoutParams lp = this.getWindow().getAttributes();
        int animRes = 0;
        if (SocializeUtils.isFloatWindowStyle((Context)this.mContext)) {
            int[] windowSize = SocializeUtils.getFloatWindowSize((Context)this.mContext);
            lp.width = windowSize[0];
            lp.height = windowSize[1];
            animRes = this.R.style("umeng_socialize_dialog_anim_fade");
        } else {
            lp.height = -1;
            lp.width = -1;
            animRes = this.R.style("umeng_socialize_dialog_animations");
        }
        lp.gravity = 17;
        this.getWindow().getAttributes().windowAnimations = animRes;
    }

    public void setWaitUrl(String url) {
        this.mWaitUrl = url;
    }

    private String getUrl(SHARE_MEDIA media) {
        URLBuilder builder = new URLBuilder(this.mContext);
        builder.setHost("https://log.umsns.com/").setPath("share/auth/").setAppkey(SocializeUtils.getAppkey((Context)this.mContext)).setEntityKey(Config.EntityKey).withMedia(media).withOpId("10").withSessionId(Config.SessionId).withUID(Config.UID);
        return builder.toEncript();
    }

    private boolean setUpWebView() {
        this.mWebView = (WebView)this.mContent.findViewById(this.R.id("webView"));
        this.mWebView.setWebViewClient(this.getAdapterWebViewClient());
        this.mWebView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                super.onProgressChanged(view, newProgress);
                if (newProgress < 90) {
                    OauthDialog.this.mProgressbar.setVisibility(0);
                } else {
                    OauthDialog.this.mHandler.sendEmptyMessage(1);
                }
            }
        });
        this.mWebView.requestFocusFromTouch();
        this.mWebView.setVerticalScrollBarEnabled(false);
        this.mWebView.setHorizontalScrollBarEnabled(false);
        this.mWebView.setScrollBarStyle(0);
        this.mWebView.getSettings().setCacheMode(2);
        WebSettings settings = this.mWebView.getSettings();
        settings.setJavaScriptEnabled(true);
        if (Build.VERSION.SDK_INT >= 8) {
            settings.setPluginState(WebSettings.PluginState.ON);
        }
        settings.setSupportZoom(true);
        settings.setBuiltInZoomControls(true);
        settings.setAllowFileAccess(true);
        settings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        settings.setUseWideViewPort(true);
        if (Build.VERSION.SDK_INT >= 8) {
            settings.setLoadWithOverviewMode(true);
            settings.setDatabaseEnabled(true);
            settings.setDomStorageEnabled(true);
            settings.setGeolocationEnabled(true);
            settings.setAppCacheEnabled(true);
        }
        if (Build.VERSION.SDK_INT >= 11) {
            try {
                Method method = WebSettings.class.getDeclaredMethod("setDisplayZoomControls", Boolean.TYPE);
                method.setAccessible(true);
                method.invoke((Object)settings, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (this.mPlatform == SHARE_MEDIA.RENREN) {
                CookieSyncManager.createInstance((Context)this.mContext);
                CookieManager instance = CookieManager.getInstance();
                instance.removeAllCookie();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return super.onKeyDown(keyCode, event);
    }

    private WebViewClient getAdapterWebViewClient() {
        boolean hasSslMethod = false;
        try {
            Method method = WebViewClient.class.getMethod("onReceivedSslError", WebView.class, SslErrorHandler.class, SslError.class);
            if (method != null) {
                hasSslMethod = true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (hasSslMethod) {
            Log.i((String)TAG, (String)"has method onReceivedSslError : ");
            return new AuthWebViewClient(){

                @Override
                public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
                    handler.cancel();
                }
            };
        }
        Log.i((String)TAG, (String)"has no method onReceivedSslError : ");
        return new AuthWebViewClient();
    }

    private String decrypt(String url) {
        try {
            String[] urlStrings = url.split("ud_get=");
            urlStrings[1] = AesHelper.decryptNoPadding((String)urlStrings[1], (String)"UTF-8").trim();
            url = urlStrings[0] + urlStrings[1];
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"### AuthWebViewClient\u89e3\u5bc6\u5931\u8d25");
            e.printStackTrace();
        }
        return url;
    }

    public void show() {
        super.show();
        this.mValues = null;
        String url = this.getUrl(this.mPlatform);
        this.mWebView.loadUrl(url);
    }

    public void dismiss() {
        if (this.mValues != null) {
            String usid = this.mValues.getString("uid");
            if (TextUtils.isEmpty((CharSequence)usid)) {
                this.mListener.onError((Exception)new SocializeException("unfetch usid..."));
            } else {
                Log.d((String)TAG, (String)"### dismiss ");
                this.mListener.onComplete(this.mValues);
            }
        } else {
            this.mListener.onCancel();
        }
        super.dismiss();
    }

    static class AuthListenerWrapper {
        private UMAuthListener mListener = null;
        private SHARE_MEDIA p;
        private int action;

        public AuthListenerWrapper(UMAuthListener listener, SHARE_MEDIA p) {
            this.mListener = listener;
            this.p = p;
        }

        public void onError(Exception e) {
            if (this.mListener != null) {
                this.mListener.onError(this.p, this.action, e);
            }
        }

        public void onComplete(Bundle bundle) {
            if (this.mListener != null) {
                this.mListener.onComplete(this.p, this.action, SocializeUtils.bundleTomap((Bundle)bundle));
            }
        }

        public void onCancel() {
            if (this.mListener != null) {
                this.mListener.onCancel(this.p, this.action);
            }
        }
    }

    private class AuthWebViewClient
    extends WebViewClient {
        private AuthWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            Log.i((String)OauthDialog.TAG, (String)("shouldOverrideUrlLoading current : " + url));
            if (!DeviceConfig.isNetworkAvailable((Context)OauthDialog.this.mContext)) {
                Toast.makeText((Context)OauthDialog.this.mContext, (CharSequence)"\u62b1\u6b49,\u60a8\u7684\u7f51\u7edc\u4e0d\u53ef\u7528...", (int)0).show();
                return true;
            }
            if (url.contains("?ud_get=")) {
                url = OauthDialog.this.decrypt(url);
            }
            if (url.contains(OauthDialog.this.mWaitUrl)) {
                this.doWaitUrl(url);
            }
            return super.shouldOverrideUrlLoading(view, url);
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            Log.e((String)OauthDialog.TAG, (String)("onReceivedError: " + failingUrl + "\nerrCode: " + errorCode + " description:" + description));
            if (OauthDialog.this.mProgressbar.getVisibility() == 0) {
                OauthDialog.this.mProgressbar.setVisibility(8);
            }
            super.onReceivedError(view, errorCode, description, failingUrl);
            SocializeUtils.safeCloseDialog((Dialog)OauthDialog.this);
        }

        public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
            handler.cancel();
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            if (url.contains("?ud_get=")) {
                url = OauthDialog.this.decrypt(url);
            }
            if (url.contains("access_key") && url.contains("access_secret")) {
                if (url.contains(OauthDialog.this.mWaitUrl)) {
                    this.doWaitUrl(url);
                }
                return;
            }
            super.onPageStarted(view, url, favicon);
        }

        public void onPageFinished(WebView view, String url) {
            OauthDialog.this.mHandler.sendEmptyMessage(1);
            super.onPageFinished(view, url);
            if (OauthDialog.this.mFlag == 0 && url.contains(OauthDialog.this.mWaitUrl)) {
                this.doWaitUrl(url);
            }
        }

        private void doWaitUrl(String url) {
            Log.d((String)OauthDialog.TAG, (String)("OauthDialog " + url));
            OauthDialog.this.mFlag = 1;
            OauthDialog.this.mValues = SocializeUtils.parseUrl((String)url);
            if (OauthDialog.this.isShowing()) {
                SocializeUtils.safeCloseDialog((Dialog)OauthDialog.this);
            }
        }
    }
}

