/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.handler;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.umeng.socialize.Config;
import com.umeng.socialize.PlatformConfig;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.SocializeException;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.common.QueuedWork;
import com.umeng.socialize.editorpage.IEditor;
import com.umeng.socialize.handler.UMSSOHandler;
import com.umeng.socialize.net.RestAPI;
import com.umeng.socialize.net.ShareMultiFollowRequest;
import com.umeng.socialize.net.SharePostRequest;
import com.umeng.socialize.net.base.SocializeReseponse;
import com.umeng.socialize.utils.Dummy;
import com.umeng.socialize.utils.Log;
import java.util.Map;
import java.util.Stack;

public abstract class UMAPIShareHandler
extends UMSSOHandler
implements IEditor {
    private Stack<StatHolder> mStatStack = new Stack();

    @Override
    public void onCreate(Context context, PlatformConfig.Platform p) {
        super.onCreate(context, p);
    }

    public boolean isAuthorized() {
        Log.e((String)"\u8be5\u5e73\u53f0\u4e0d\u652f\u6301\u6388\u6743\u67e5\u8be2");
        return false;
    }

    public abstract String getUID();

    public abstract SHARE_MEDIA getPlatform();

    public abstract void authorizeCallBack(int var1, int var2, Intent var3);

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        StatHolder holder;
        if (requestCode != this.getRequestCode()) {
            return;
        }
        if (resultCode == 1000 && (holder = this.mStatStack.pop()) != null) {
            holder.Listener.onCancel(this.getPlatform());
        }
        if (data != null && data.hasExtra("txt")) {
            if (!this.mStatStack.empty()) {
                Bundle extras;
                holder = this.mStatStack.pop();
                Bundle bundle = extras = data == null ? null : data.getExtras();
                if (resultCode == -1) {
                    QueuedWork.runInBack((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ShareContent content = UMAPIShareHandler.this.getResult(holder.Content, extras);
                            UMAPIShareHandler.this.sendShareRequest(content, holder.Listener);
                            Log.d((String)"act", (String)"sent share request");
                        }
                    });
                } else if (holder.Listener != null) {
                    holder.Listener.onCancel(this.getPlatform());
                }
            }
        } else {
            this.authorizeCallBack(requestCode, resultCode, data);
        }
    }

    protected void saveFollow() {
    }

    @Override
    public boolean share(final ShareContent content, UMShareListener listener) {
        final UMShareListener safelistener = (UMShareListener)Dummy.get(UMShareListener.class, (Object)listener);
        if (this.isAuthorized()) {
            this.doShare(content, safelistener);
        } else {
            this.authorize(new UMAuthListener(){

                @Override
                public void onComplete(SHARE_MEDIA platform, int action, Map<String, String> data) {
                    QueuedWork.runInBack((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            UMAPIShareHandler.this.doShare(content, safelistener);
                        }
                    });
                }

                @Override
                public void onError(SHARE_MEDIA platform, int action, Throwable t) {
                    safelistener.onError(platform, t);
                }

                @Override
                public void onCancel(SHARE_MEDIA platform, int action) {
                    safelistener.onCancel(platform);
                }
            });
        }
        return false;
    }

    private void doShare(ShareContent shareContent, UMShareListener listener) {
        if (Config.OpenEditor) {
            StatHolder holder = new StatHolder();
            holder.Content = shareContent;
            holder.Listener = listener;
            this.mStatStack.push(holder);
            if (this.mWeakAct.get() != null && !((Activity)this.mWeakAct.get()).isFinishing()) {
                try {
                    Class<?> object = Class.forName("com.umeng.socialize.editorpage.ShareActivity");
                    Intent in = new Intent((Context)this.mWeakAct.get(), object);
                    in.putExtras(this.getEditable(shareContent));
                    ((Activity)this.mWeakAct.get()).startActivityForResult(in, this.getRequestCode());
                }
                catch (ClassNotFoundException e) {
                    this.sendShareRequest(shareContent, listener);
                    Log.e((String)"\u6ca1\u6709\u52a0\u5165\u754c\u9762jar");
                    e.printStackTrace();
                }
            }
        } else {
            this.sendShareRequest(shareContent, listener);
        }
    }

    private void sendShareRequest(ShareContent shareContent, final UMShareListener listener) {
        SocializeReseponse resp;
        final SHARE_MEDIA media = this.getPlatform();
        String platform = media.toString().toLowerCase();
        String usid = this.getUID();
        SharePostRequest request = new SharePostRequest(this.getContext(), platform, usid, shareContent);
        request.setReqType(0);
        final SocializeReseponse finalResp = resp = RestAPI.doShare((SharePostRequest)request);
        if (resp == null) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    listener.onError(media, (Throwable)new SocializeException("response is null"));
                }
            });
        } else if (!resp.isOk()) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    listener.onError(media, (Throwable)new SocializeException(finalResp.mStCode, finalResp.mMsg));
                }
            });
        } else {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    listener.onResult(media);
                }
            });
        }
        if (shareContent.mFollow == null) {
            return;
        }
        ShareMultiFollowRequest smfr = new ShareMultiFollowRequest(this.getContext(), platform, usid, shareContent.mFollow);
        resp = RestAPI.doFollow((ShareMultiFollowRequest)smfr);
        if (resp == null) {
            Log.e((String)"follow", (String)"resp = null");
        } else if (!resp.isOk()) {
            Log.e((String)"follow", (String)("follow fail e =" + resp.mMsg));
        } else {
            this.saveFollow();
        }
    }

    static class StatHolder {
        public ShareContent Content;
        public UMShareListener Listener;

        StatHolder() {
        }
    }
}

