/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.media;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.umeng.socialize.utils.Log;
import java.util.HashMap;
import java.util.Map;

public class TencentWBSharepreference {
    private static final String KEY_ACCESS_KEY = "access_key";
    private static final String KEY_ACCESS_SECRET = "access_secret";
    private static final String KEY_UID = "uid";
    private static final String KEY_TTL = "expires_in";
    private String mAccessKey = null;
    private String mAccessSecret = null;
    private String mUID = null;
    private long mTTL = 0L;
    private SharedPreferences sharedPreferences = null;

    public TencentWBSharepreference(Context context, String platform) {
        this.sharedPreferences = context.getSharedPreferences(platform, 0);
        this.mAccessKey = this.sharedPreferences.getString(KEY_ACCESS_KEY, null);
        this.mAccessSecret = this.sharedPreferences.getString(KEY_ACCESS_SECRET, null);
        this.mUID = this.sharedPreferences.getString(KEY_UID, null);
        this.mTTL = this.sharedPreferences.getLong(KEY_TTL, 0L);
    }

    public TencentWBSharepreference setAuthData(Map<String, String> data) {
        this.mAccessKey = data.get(KEY_ACCESS_KEY);
        this.mAccessSecret = data.get(KEY_ACCESS_SECRET);
        this.mUID = data.get(KEY_UID);
        if (!TextUtils.isEmpty((CharSequence)data.get(KEY_TTL))) {
            this.mTTL = Long.valueOf(data.get(KEY_TTL)) * 1000L + System.currentTimeMillis();
        }
        return this;
    }

    public Map<String, String> getAuthData() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(KEY_ACCESS_KEY, this.mAccessKey);
        map.put(KEY_ACCESS_SECRET, this.mAccessSecret);
        map.put(KEY_UID, this.mUID);
        map.put(KEY_TTL, String.valueOf(this.mTTL));
        return map;
    }

    public String getUID() {
        return this.mUID;
    }

    public boolean isAuthorized() {
        return !TextUtils.isEmpty((CharSequence)this.mUID);
    }

    public boolean isAuthValid() {
        boolean isAuthorized = this.isAuthorized();
        boolean isExpired = this.mTTL - System.currentTimeMillis() <= 0L;
        return isAuthorized && !isExpired;
    }

    public void commit() {
        this.sharedPreferences.edit().putString(KEY_ACCESS_KEY, this.mAccessKey).putString(KEY_ACCESS_SECRET, this.mAccessSecret).putString(KEY_UID, this.mUID).putLong(KEY_TTL, this.mTTL).commit();
        Log.i((String)"save auth succeed");
    }

    public void delete() {
        this.sharedPreferences.edit().clear().commit();
    }
}

