/*
 * Decompiled with CFR 0.152.
 */
package com.beatop.btoplogin.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.beatop.btopbase.BTBaseActivity;
import com.beatop.btopbase.BTCountryListActivity;
import com.beatop.btopbase.module.CaptchaResultEntity;
import com.beatop.btopbase.utils.Router;
import com.beatop.btopbase.utils.StringHelper;
import com.beatop.btoplogin.R;
import com.beatop.btoplogin.ui.BTLoginActivity;
import com.beatop.btoplogin.ui.BTSetPwdActivity;
import java.io.Serializable;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class BTSignupActivity
extends BTBaseActivity {
    private ImageView back;
    private TextView title;
    private TextView nextStepTv;
    private TextView phoneTypeTv;
    private View phoneTypeView;
    private TextView emailTypeTv;
    private View emailTypeView;
    private TextView areaCodeTv;
    private EditText phoneNumberEt;
    private RelativeLayout phoneTypeRl;
    private EditText emailEt;
    private CheckBox privacyCb;
    private TextView privacyTv;
    private LinearLayout privacyLl;
    private TextView loginTv;
    private static final int PHONE_TYPE = 1;
    private static final int EMAIL_TYPE = 2;
    private int selectedType = 1;
    private String phoneErrorNote;
    private String phoneNotRegisteredNote;
    private String emailNoteRegisteredNote;
    private String emailErrorNote;
    private String privacyErrorNote;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.btlogin_activity_signup);
        this.initView();
    }

    public void onBackPressed() {
        Intent it = new Intent((Context)this, BTLoginActivity.class);
        this.startActivity(it);
        this.finish();
    }

    private void initView() {
        String value = this.getIntent().getStringExtra("value");
        int type = this.getIntent().getIntExtra("type", -1);
        int areaCode = this.getIntent().getIntExtra("area_code", -1);
        this.back = (ImageView)this.findViewById(R.id.back);
        this.back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTSignupActivity.this.onBackPressed();
            }
        });
        this.title = (TextView)this.findViewById(R.id.title);
        this.nextStepTv = (TextView)this.findViewById(R.id.tv_next_button);
        this.nextStepTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!BTSignupActivity.this.privacyCb.isChecked()) {
                    BTSignupActivity.this.showMsg(BTSignupActivity.this.privacyErrorNote);
                    return;
                }
                final Intent it = new Intent((Context)BTSignupActivity.this, BTSetPwdActivity.class);
                it.putExtra("type", BTSignupActivity.this.selectedType);
                if (BTSignupActivity.this.selectedType == 1) {
                    if (!StringHelper.checkMobile((String)BTSignupActivity.this.areaCodeTv.getText().toString().substring(1), (String)BTSignupActivity.this.phoneNumberEt.getText().toString())) {
                        BTSignupActivity.this.showMsg(BTSignupActivity.this.phoneErrorNote);
                        return;
                    }
                    netWorkServer.getCaptcha(BTSignupActivity.this.areaCodeTv.getText().toString().substring(1), BTSignupActivity.this.phoneNumberEt.getText().toString(), "signup").enqueue((Callback)new Callback<CaptchaResultEntity>(){

                        public void onResponse(Call<CaptchaResultEntity> call, Response<CaptchaResultEntity> response) {
                            if (((CaptchaResultEntity)response.body()).getError() != null) {
                                BTSignupActivity.this.showMsg(((CaptchaResultEntity)response.body()).getError().getMessage());
                            } else {
                                Log.d((String)BTSignupActivity.this.TAG, (String)("onResponse: " + ((CaptchaResultEntity)response.body()).getCaptcha()));
                                it.putExtra("value", BTSignupActivity.this.phoneNumberEt.getText().toString());
                                it.putExtra("area_code", (Serializable)Integer.valueOf(BTSignupActivity.this.areaCodeTv.getText().toString().substring(1)));
                                BTSignupActivity.this.startActivity(it);
                                BTSignupActivity.this.finish();
                            }
                        }

                        public void onFailure(Call<CaptchaResultEntity> call, Throwable t) {
                            BTSignupActivity.this.showMsg(BTSignupActivity.this.netErrorNote);
                        }
                    });
                } else if (BTSignupActivity.this.selectedType == 2) {
                    if (TextUtils.isEmpty((CharSequence)BTSignupActivity.this.emailEt.getText().toString()) || !StringHelper.checkEmail((String)BTSignupActivity.this.emailEt.getText().toString())) {
                        BTSignupActivity.this.showMsg(BTSignupActivity.this.emailErrorNote);
                        return;
                    }
                    netWorkServer.getCaptcha("", BTSignupActivity.this.emailEt.getText().toString(), "signup").enqueue((Callback)new Callback<CaptchaResultEntity>(){

                        public void onResponse(Call<CaptchaResultEntity> call, Response<CaptchaResultEntity> response) {
                            if (((CaptchaResultEntity)response.body()).getError() != null) {
                                BTSignupActivity.this.showMsg(((CaptchaResultEntity)response.body()).getError().getMessage());
                            } else {
                                Log.d((String)BTSignupActivity.this.TAG, (String)("onResponse: " + ((CaptchaResultEntity)response.body()).getCaptcha()));
                                it.putExtra("value", BTSignupActivity.this.emailEt.getText().toString());
                                BTSignupActivity.this.startActivity(it);
                                BTSignupActivity.this.finish();
                            }
                        }

                        public void onFailure(Call<CaptchaResultEntity> call, Throwable t) {
                            BTSignupActivity.this.showMsg(BTSignupActivity.this.netErrorNote);
                        }
                    });
                }
            }
        });
        this.phoneTypeTv = (TextView)this.findViewById(R.id.tv_phone_login);
        this.phoneTypeTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTSignupActivity.this.setSelected(1);
            }
        });
        this.phoneTypeView = this.findViewById(R.id.iv_phone_login);
        this.emailTypeTv = (TextView)this.findViewById(R.id.tv_email_login);
        this.emailTypeTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTSignupActivity.this.setSelected(2);
            }
        });
        this.emailTypeView = this.findViewById(R.id.iv_email_login);
        this.areaCodeTv = (TextView)this.findViewById(R.id.tv_area_code);
        this.areaCodeTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent it = new Intent((Context)BTSignupActivity.this, BTCountryListActivity.class);
                BTSignupActivity.this.startActivityForResult(it, 1);
            }
        });
        this.phoneNumberEt = (EditText)this.findViewById(R.id.et_edit_phone);
        this.phoneTypeRl = (RelativeLayout)this.findViewById(R.id.account_phone);
        this.emailEt = (EditText)this.findViewById(R.id.et_edit_email);
        this.privacyCb = (CheckBox)this.findViewById(R.id.cb_privacy);
        this.privacyLl = (LinearLayout)this.findViewById(R.id.ll_privacy);
        this.privacyLl.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Bundle it = new Bundle();
                if (BTSignupActivity.this.isZh) {
                    it.putString("url", "http://www.ibeatop.com/index/terms_app?_lang=zh&type=private");
                } else {
                    it.putString("url", "http://www.ibeatop.com/index/terms_app?_lang=en&type=private");
                }
                Router.sharedRouter().open("btop://web/btTitleWebActivity", it);
            }
        });
        this.privacyTv = (TextView)this.findViewById(R.id.tv_privacy);
        this.loginTv = (TextView)this.findViewById(R.id.tv_login);
        this.loginTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTSignupActivity.this.onBackPressed();
            }
        });
        this.setText();
        if (type != -1) {
            this.setSelected(type);
            if (type == 1) {
                this.areaCodeTv.setText((CharSequence)("+" + areaCode));
                this.phoneNumberEt.setText((CharSequence)value);
            } else {
                this.emailEt.setText((CharSequence)value);
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1 && resultCode == -1) {
            this.areaCodeTv.setText((CharSequence)data.getStringExtra("area_code"));
        }
    }

    private void setText() {
        if (this.isZh) {
            this.title.setText((CharSequence)this.resources.getString(R.string.btlogin_sign_title_zh));
            this.phoneTypeTv.setText((CharSequence)this.resources.getString(R.string.btlogin_type_phone_zh));
            this.emailTypeTv.setText((CharSequence)this.resources.getString(R.string.btlogin_type_email_zh));
            this.phoneNumberEt.setHint(R.string.btlogin_account_phone_zh);
            this.emailEt.setHint(R.string.btlogin_type_email_zh);
            this.phoneErrorNote = this.resources.getString(R.string.btlogin_phone_error_zh);
            this.phoneNotRegisteredNote = this.resources.getString(R.string.btlogin_no_phone_error_zh);
            this.emailNoteRegisteredNote = this.resources.getString(R.string.btlogin_no_email_error_zh);
            this.emailErrorNote = this.resources.getString(R.string.btlogin_email_error_zh);
            this.nextStepTv.setText((CharSequence)this.resources.getString(R.string.btlogin_next_step_zh));
            this.privacyCb.setHint(R.string.btlogin_sign_agree_zh);
            this.privacyTv.setText((CharSequence)this.resources.getString(R.string.btlogin_privacy_zh));
            this.loginTv.setText((CharSequence)this.resources.getString(R.string.btlogin_sign_login_zh));
            this.privacyErrorNote = this.resources.getString(R.string.btlogin_privacy_error_zh);
        } else {
            this.title.setText((CharSequence)this.resources.getString(R.string.btlogin_sign_title_en));
            this.phoneTypeTv.setText((CharSequence)this.resources.getString(R.string.btlogin_type_phone_en));
            this.emailTypeTv.setText((CharSequence)this.resources.getString(R.string.btlogin_type_email_en));
            this.phoneNumberEt.setHint(R.string.btlogin_account_phone_en);
            this.emailEt.setHint(R.string.btlogin_type_email_en);
            this.phoneErrorNote = this.resources.getString(R.string.btlogin_phone_error_en);
            this.phoneNotRegisteredNote = this.resources.getString(R.string.btlogin_no_phone_error_en);
            this.emailNoteRegisteredNote = this.resources.getString(R.string.btlogin_no_email_error_en);
            this.emailErrorNote = this.resources.getString(R.string.btlogin_email_error_en);
            this.nextStepTv.setText((CharSequence)this.resources.getString(R.string.btlogin_next_step_en));
            this.privacyCb.setHint(R.string.btlogin_sign_agree_en);
            this.privacyTv.setText((CharSequence)this.resources.getString(R.string.btlogin_privacy_en));
            this.loginTv.setText((CharSequence)this.resources.getString(R.string.btlogin_sign_login_en));
            this.privacyErrorNote = this.resources.getString(R.string.btlogin_privacy_error_en);
        }
    }

    private void setSelected(int selected) {
        this.selectedType = selected;
        if (this.selectedType == 1) {
            this.phoneTypeView.setVisibility(0);
            this.emailTypeView.setVisibility(8);
            this.phoneTypeRl.setVisibility(0);
            this.emailEt.setVisibility(8);
            this.phoneNumberEt.requestFocus();
        } else if (this.selectedType == 2) {
            this.phoneTypeView.setVisibility(8);
            this.emailTypeView.setVisibility(0);
            this.phoneTypeRl.setVisibility(8);
            this.emailEt.setVisibility(0);
            this.emailEt.requestFocus();
        }
    }

    protected void onLanguageChanged() {
        this.setText();
    }
}

