/*
 * Decompiled with CFR 0.152.
 */
package com.beatop.btoplogin.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Typeface;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.beatop.btopbase.BTBaseActivity;
import com.beatop.btopbase.BTCountryListActivity;
import com.beatop.btopbase.module.UserInfoEntity;
import com.beatop.btopbase.utils.SPHelper;
import com.beatop.btopbase.utils.StringHelper;
import com.beatop.btoplogin.R;
import com.beatop.btoplogin.ui.BTForgetPwdActivity;
import com.beatop.btoplogin.ui.BTSignupActivity;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.UMShareAPI;
import com.umeng.socialize.bean.SHARE_MEDIA;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class BTLoginActivity
extends BTBaseActivity {
    private TextView signUpTv;
    private TextView forgetPwdTv;
    private TextView phoneTypeTv;
    private View phoneTypeView;
    private TextView emailTypeTv;
    private View emailTypeView;
    private TextView areaCodeTv;
    private EditText phoneNumberEt;
    private RelativeLayout phoneTypeRl;
    private EditText emailEt;
    private EditText pwdEt;
    private TextView loginTv;
    private TextView otherWayTv;
    private static final int PHONE_TYPE = 1;
    private static final int EMAIL_TYPE = 2;
    private int selectedType = 1;
    private ImageView wxIv;
    private ImageView wbIv;
    private ImageView fbIv;
    private String phoneErrorNote;
    private String phoneNotRegisteredNote;
    private String pwdLengthErrorNote;
    private String pwdErrorNote;
    private String emailNoteRegisteredNote;
    private String emailErrorNote;
    private String authSuccessNote;
    private String authCancelNote;
    private String authFailNote;
    private UMShareAPI mShareAPI = null;
    private UMAuthListener umAuthListener = new UMAuthListener(){

        public void onComplete(SHARE_MEDIA platform, int action, Map<String, String> data) {
            for (String key : data.keySet()) {
                Log.e((String)BTLoginActivity.this.TAG, (String)("xxxxxx key = " + key + "    value= " + data.get(key)));
            }
            String tp = null;
            String openid = "";
            if (platform.equals((Object)SHARE_MEDIA.WEIXIN)) {
                tp = "weixinm";
                openid = data.get("openid");
            } else {
                tp = platform.equals((Object)SHARE_MEDIA.SINA) ? "weibo" : "facebook";
            }
            netWorkServer.socialLogin(tp, data.get("access_token"), openid).enqueue((Callback)new Callback<UserInfoEntity>(){

                public void onResponse(Call<UserInfoEntity> call, Response<UserInfoEntity> response) {
                    if (response.isSuccessful() && ((UserInfoEntity)response.body()).getError() != null) {
                        BTLoginActivity.this.showMsg(((UserInfoEntity)response.body()).getError().getMessage());
                    } else if (response.isSuccessful()) {
                        BTLoginActivity.this.showMsg(BTLoginActivity.this.authSuccessNote);
                        userInfo = (UserInfoEntity)response.body();
                        SPHelper.saveLoginStatus((boolean)true);
                        SPHelper.saveUserInfo((UserInfoEntity)userInfo);
                        BTLoginActivity.this.setResult(-1);
                        BTLoginActivity.this.finish();
                    } else {
                        BTLoginActivity.this.showMsg(BTLoginActivity.this.netErrorNote);
                    }
                }

                public void onFailure(Call<UserInfoEntity> call, Throwable t) {
                    BTLoginActivity.this.showMsg(BTLoginActivity.this.netErrorNote);
                    Log.e((String)BTLoginActivity.this.TAG, (String)("onFailure: " + t.toString()));
                }
            });
        }

        public void onError(SHARE_MEDIA platform, int action, Throwable t) {
            BTLoginActivity.this.showMsg(BTLoginActivity.this.authFailNote);
        }

        public void onCancel(SHARE_MEDIA platform, int action) {
            BTLoginActivity.this.showMsg(BTLoginActivity.this.authCancelNote);
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.btlogin_activity_login);
        this.mShareAPI = UMShareAPI.get((Context)this);
        this.initView();
    }

    private void initView() {
        this.signUpTv = (TextView)this.findViewById(R.id.tv_signup);
        this.signUpTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent it = new Intent((Context)BTLoginActivity.this, BTSignupActivity.class);
                BTLoginActivity.this.startActivity(it);
                BTLoginActivity.this.finish();
            }
        });
        this.forgetPwdTv = (TextView)this.findViewById(R.id.tv_forget_pwd);
        this.forgetPwdTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent it = new Intent((Context)BTLoginActivity.this, BTForgetPwdActivity.class);
                BTLoginActivity.this.startActivity(it);
                BTLoginActivity.this.finish();
            }
        });
        this.phoneTypeTv = (TextView)this.findViewById(R.id.tv_phone_login);
        this.phoneTypeTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTLoginActivity.this.selectedType = 1;
                BTLoginActivity.this.phoneTypeView.setVisibility(0);
                BTLoginActivity.this.emailTypeView.setVisibility(8);
                BTLoginActivity.this.phoneTypeRl.setVisibility(0);
                BTLoginActivity.this.emailEt.setVisibility(8);
                BTLoginActivity.this.pwdEt.setText((CharSequence)"");
                BTLoginActivity.this.phoneNumberEt.requestFocus();
            }
        });
        this.phoneTypeView = this.findViewById(R.id.iv_phone_login);
        this.emailTypeTv = (TextView)this.findViewById(R.id.tv_email_login);
        this.emailTypeTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTLoginActivity.this.selectedType = 2;
                BTLoginActivity.this.phoneTypeView.setVisibility(8);
                BTLoginActivity.this.emailTypeView.setVisibility(0);
                BTLoginActivity.this.phoneTypeRl.setVisibility(8);
                BTLoginActivity.this.emailEt.setVisibility(0);
                BTLoginActivity.this.pwdEt.setText((CharSequence)"");
                BTLoginActivity.this.emailEt.requestFocus();
            }
        });
        this.emailTypeView = this.findViewById(R.id.iv_email_login);
        this.areaCodeTv = (TextView)this.findViewById(R.id.tv_area_code);
        this.areaCodeTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent it = new Intent((Context)BTLoginActivity.this, BTCountryListActivity.class);
                BTLoginActivity.this.startActivityForResult(it, 1);
            }
        });
        this.phoneNumberEt = (EditText)this.findViewById(R.id.et_edit_phone);
        this.phoneTypeRl = (RelativeLayout)this.findViewById(R.id.account_phone);
        this.emailEt = (EditText)this.findViewById(R.id.et_edit_email);
        this.pwdEt = (EditText)this.findViewById(R.id.et_edit_pwd);
        this.pwdEt.setTypeface(Typeface.SANS_SERIF);
        this.loginTv = (TextView)this.findViewById(R.id.tv_login_button);
        this.loginTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTLoginActivity.this.login();
            }
        });
        this.otherWayTv = (TextView)this.findViewById(R.id.tv_other_type);
        this.wxIv = (ImageView)this.findViewById(R.id.iv_wx_login);
        this.wxIv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTLoginActivity.this.mShareAPI.doOauthVerify((Activity)BTLoginActivity.this, SHARE_MEDIA.WEIXIN, BTLoginActivity.this.umAuthListener);
            }
        });
        this.wbIv = (ImageView)this.findViewById(R.id.iv_wb_login);
        this.wbIv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTLoginActivity.this.mShareAPI.doOauthVerify((Activity)BTLoginActivity.this, SHARE_MEDIA.SINA, BTLoginActivity.this.umAuthListener);
            }
        });
        this.fbIv = (ImageView)this.findViewById(R.id.iv_fb_login);
        this.fbIv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTLoginActivity.this.mShareAPI.doOauthVerify((Activity)BTLoginActivity.this, SHARE_MEDIA.FACEBOOK, BTLoginActivity.this.umAuthListener);
            }
        });
        Intent it = this.getIntent();
        int type = it.getIntExtra("type", -1);
        String value = it.getStringExtra("value");
        int areaCode = it.getIntExtra("area_code", 86);
        String pwd = it.getStringExtra("pwd");
        if (type == 1) {
            this.selectedType = 1;
            this.phoneTypeView.setVisibility(0);
            this.emailTypeView.setVisibility(8);
            this.phoneTypeRl.setVisibility(0);
            this.emailEt.setVisibility(8);
            this.areaCodeTv.setText((CharSequence)("+" + areaCode));
            this.pwdEt.setText((CharSequence)pwd);
            this.phoneNumberEt.setText((CharSequence)value);
        } else if (type == 2) {
            this.selectedType = 2;
            this.phoneTypeView.setVisibility(8);
            this.emailTypeView.setVisibility(0);
            this.phoneTypeRl.setVisibility(8);
            this.emailEt.setVisibility(0);
            this.pwdEt.setText((CharSequence)pwd);
            this.emailEt.setText((CharSequence)value);
        }
        this.setText();
    }

    private void setText() {
        if (this.isZh) {
            this.phoneTypeTv.setText((CharSequence)this.resources.getString(R.string.btlogin_type_phone_zh));
            this.emailTypeTv.setText((CharSequence)this.resources.getString(R.string.btlogin_type_email_zh));
            this.phoneNumberEt.setHint(R.string.btlogin_account_phone_zh);
            this.emailEt.setHint(R.string.btlogin_type_email_zh);
            this.pwdEt.setHint(R.string.btlogin_login_password_zh);
            this.loginTv.setText((CharSequence)this.resources.getString(R.string.btlogin_login_submit_zh));
            this.forgetPwdTv.setText((CharSequence)this.resources.getString(R.string.btlogin_login_forget_pwd_zh));
            this.signUpTv.setText((CharSequence)this.resources.getString(R.string.btlogin_login_signup_zh));
            this.otherWayTv.setText((CharSequence)this.resources.getString(R.string.btlogin_login_other_type_zh));
            this.phoneErrorNote = this.resources.getString(R.string.btlogin_phone_error_zh);
            this.phoneNotRegisteredNote = this.resources.getString(R.string.btlogin_no_phone_error_zh);
            this.emailNoteRegisteredNote = this.resources.getString(R.string.btlogin_no_email_error_zh);
            this.pwdErrorNote = this.resources.getString(R.string.btlogin_pwd_error_zh);
            this.pwdLengthErrorNote = this.resources.getString(R.string.btlogin_pwd_type_error_zh);
            this.emailErrorNote = this.resources.getString(R.string.btlogin_email_error_zh);
            this.authCancelNote = this.resources.getString(R.string.btlogin_login_auth_cancel_note_zh);
            this.authSuccessNote = this.resources.getString(R.string.btlogin_login_auth_success_note_zh);
            this.authFailNote = this.resources.getString(R.string.btlogin_login_auth_fail_note_zh);
        } else {
            this.phoneTypeTv.setText((CharSequence)this.resources.getString(R.string.btlogin_type_phone_en));
            this.emailTypeTv.setText((CharSequence)this.resources.getString(R.string.btlogin_type_email_en));
            this.phoneNumberEt.setHint(R.string.btlogin_account_phone_en);
            this.emailEt.setHint(R.string.btlogin_type_email_en);
            this.pwdEt.setHint(R.string.btlogin_login_password_en);
            this.loginTv.setText((CharSequence)this.resources.getString(R.string.btlogin_login_submit_en));
            this.forgetPwdTv.setText((CharSequence)this.resources.getString(R.string.btlogin_login_forget_pwd_en));
            this.signUpTv.setText((CharSequence)this.resources.getString(R.string.btlogin_login_signup_en));
            this.otherWayTv.setText((CharSequence)this.resources.getString(R.string.btlogin_login_other_type_en));
            this.phoneErrorNote = this.resources.getString(R.string.btlogin_phone_error_en);
            this.phoneNotRegisteredNote = this.resources.getString(R.string.btlogin_no_phone_error_en);
            this.emailNoteRegisteredNote = this.resources.getString(R.string.btlogin_no_email_error_en);
            this.pwdErrorNote = this.resources.getString(R.string.btlogin_pwd_error_en);
            this.pwdLengthErrorNote = this.resources.getString(R.string.btlogin_pwd_type_error_en);
            this.emailErrorNote = this.resources.getString(R.string.btlogin_email_error_en);
            this.authCancelNote = this.resources.getString(R.string.btlogin_login_auth_cancel_note_en);
            this.authSuccessNote = this.resources.getString(R.string.btlogin_login_auth_success_note_en);
            this.authFailNote = this.resources.getString(R.string.btlogin_login_auth_fail_note_en);
        }
    }

    private void login() {
        if (this.selectedType == 1) {
            if (!StringHelper.checkMobile((String)this.areaCodeTv.getText().toString(), (String)this.phoneNumberEt.getText().toString())) {
                this.showMsg(this.phoneErrorNote);
                return;
            }
            this.doLoginNetWork();
        } else if (!StringHelper.checkEmail((String)this.emailEt.getText().toString())) {
            this.showMsg(this.emailErrorNote);
        } else {
            this.doLoginNetWork();
        }
    }

    private void doLoginNetWork() {
        String account;
        String areaCode = "";
        String password = this.pwdEt.getText().toString();
        if (this.selectedType == 1) {
            account = this.phoneNumberEt.getText().toString();
            areaCode = this.areaCodeTv.getText().toString();
        } else {
            account = this.emailEt.getText().toString();
        }
        netWorkServer.login(account, password, "booking", "", "android", "", areaCode).enqueue((Callback)new Callback<UserInfoEntity>(){

            public void onResponse(Call<UserInfoEntity> call, Response<UserInfoEntity> response) {
                Log.d((String)BTLoginActivity.this.TAG, (String)("onResponse: login " + ((UserInfoEntity)response.body()).get_Akey()));
                if (((UserInfoEntity)response.body()).get_Akey() != null) {
                    userInfo = (UserInfoEntity)response.body();
                    SPHelper.saveLoginStatus((boolean)true);
                    SPHelper.saveUserInfo((UserInfoEntity)((UserInfoEntity)response.body()));
                    BTLoginActivity.this.setResult(-1, new Intent().putExtra("_Akey", userInfo.get_Akey()));
                    BTLoginActivity.this.finish();
                }
                if (((UserInfoEntity)response.body()).getError() != null) {
                    Log.d((String)BTLoginActivity.this.TAG, (String)("onResponse: login " + ((UserInfoEntity)response.body()).getError().getMessage()));
                    BTLoginActivity.this.showMsg(((UserInfoEntity)response.body()).getError().getMessage());
                    BTLoginActivity.this.setResult(0);
                }
            }

            public void onFailure(Call<UserInfoEntity> call, Throwable t) {
                BTLoginActivity.this.setResult(0);
                BTLoginActivity.this.showMsg(BTLoginActivity.this.netErrorNote);
            }
        });
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.setResult(0);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.mShareAPI.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1 && resultCode == -1) {
            this.areaCodeTv.setText((CharSequence)data.getStringExtra("area_code"));
        }
    }

    protected void onLanguageChanged() {
        this.setText();
    }
}

