/*
 * Decompiled with CFR 0.152.
 */
package com.beatop.btoplogin.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.beatop.btopbase.BTBaseActivity;
import com.beatop.btopbase.BTCountryListActivity;
import com.beatop.btopbase.module.CaptchaResultEntity;
import com.beatop.btopbase.utils.StringHelper;
import com.beatop.btoplogin.R;
import com.beatop.btoplogin.ui.BTLoginActivity;
import com.beatop.btoplogin.ui.BTResetPwdActivity;
import java.io.Serializable;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class BTForgetPwdActivity
extends BTBaseActivity {
    private TextView nextStepTv;
    private TextView title;
    private ImageView back;
    private TextView phoneTypeTv;
    private View phoneTypeView;
    private TextView emailTypeTv;
    private View emailTypeView;
    private TextView areaCodeTv;
    private EditText phoneNumberEt;
    private RelativeLayout phoneTypeRl;
    private EditText emailEt;
    private TextView gotoLoginTv;
    private static final int PHONE_TYPE = 1;
    private static final int EMAIL_TYPE = 2;
    private int selectedType = 1;
    private String phoneErrorNote;
    private String phoneNotRegisteredNote;
    private String emailNoteRegisteredNote;
    private String emailErrorNote;

    protected void onLanguageChanged() {
        this.setText();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.btlogin_activity_forgetpwd);
        this.initView();
    }

    private void initView() {
        String value = this.getIntent().getStringExtra("value");
        int type = this.getIntent().getIntExtra("type", -1);
        int areaCode = this.getIntent().getIntExtra("area_code", -1);
        this.title = (TextView)this.findViewById(R.id.title);
        this.back = (ImageView)this.findViewById(R.id.back);
        this.back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTForgetPwdActivity.this.onBackPressed();
            }
        });
        this.nextStepTv = (TextView)this.findViewById(R.id.tv_next_button);
        this.nextStepTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                final Intent it = new Intent((Context)BTForgetPwdActivity.this, BTResetPwdActivity.class);
                it.putExtra("type", BTForgetPwdActivity.this.selectedType);
                if (BTForgetPwdActivity.this.selectedType == 1) {
                    if (!StringHelper.checkMobile((String)BTForgetPwdActivity.this.areaCodeTv.getText().toString().substring(1), (String)BTForgetPwdActivity.this.phoneNumberEt.getText().toString())) {
                        BTForgetPwdActivity.this.showMsg(BTForgetPwdActivity.this.phoneErrorNote);
                        return;
                    }
                    netWorkServer.getCaptcha(BTForgetPwdActivity.this.areaCodeTv.getText().toString().substring(1), BTForgetPwdActivity.this.phoneNumberEt.getText().toString(), "forget").enqueue((Callback)new Callback<CaptchaResultEntity>(){

                        public void onResponse(Call<CaptchaResultEntity> call, Response<CaptchaResultEntity> response) {
                            if (((CaptchaResultEntity)response.body()).getError() != null) {
                                BTForgetPwdActivity.this.showMsg(((CaptchaResultEntity)response.body()).getError().getMessage());
                            } else {
                                Log.d((String)BTForgetPwdActivity.this.TAG, (String)("onResponse: " + ((CaptchaResultEntity)response.body()).getCaptcha()));
                                it.putExtra("value", BTForgetPwdActivity.this.phoneNumberEt.getText().toString());
                                it.putExtra("area_code", (Serializable)Integer.valueOf(BTForgetPwdActivity.this.areaCodeTv.getText().toString().substring(1)));
                                BTForgetPwdActivity.this.startActivity(it);
                                BTForgetPwdActivity.this.finish();
                            }
                        }

                        public void onFailure(Call<CaptchaResultEntity> call, Throwable t) {
                            BTForgetPwdActivity.this.showMsg(BTForgetPwdActivity.this.netErrorNote);
                        }
                    });
                } else {
                    if (!StringHelper.checkEmail((String)BTForgetPwdActivity.this.emailEt.getText().toString())) {
                        BTForgetPwdActivity.this.showMsg(BTForgetPwdActivity.this.emailErrorNote);
                        return;
                    }
                    netWorkServer.getCaptcha("", BTForgetPwdActivity.this.emailEt.getText().toString(), "forget").enqueue((Callback)new Callback<CaptchaResultEntity>(){

                        public void onResponse(Call<CaptchaResultEntity> call, Response<CaptchaResultEntity> response) {
                            if (((CaptchaResultEntity)response.body()).getError() != null) {
                                BTForgetPwdActivity.this.showMsg(((CaptchaResultEntity)response.body()).getError().getMessage());
                            } else {
                                Log.d((String)BTForgetPwdActivity.this.TAG, (String)("onResponse: " + ((CaptchaResultEntity)response.body()).getCaptcha()));
                                it.putExtra("value", BTForgetPwdActivity.this.emailEt.getText().toString());
                                BTForgetPwdActivity.this.startActivity(it);
                                BTForgetPwdActivity.this.finish();
                            }
                        }

                        public void onFailure(Call<CaptchaResultEntity> call, Throwable t) {
                            BTForgetPwdActivity.this.showMsg(BTForgetPwdActivity.this.netErrorNote);
                        }
                    });
                }
            }
        });
        this.phoneTypeTv = (TextView)this.findViewById(R.id.tv_phone_login);
        this.phoneTypeTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTForgetPwdActivity.this.setSelected(1);
            }
        });
        this.phoneTypeView = this.findViewById(R.id.iv_phone_login);
        this.emailTypeTv = (TextView)this.findViewById(R.id.tv_email_login);
        this.emailTypeTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTForgetPwdActivity.this.setSelected(2);
            }
        });
        this.emailTypeView = this.findViewById(R.id.iv_email_login);
        this.areaCodeTv = (TextView)this.findViewById(R.id.tv_area_code);
        this.areaCodeTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent it = new Intent((Context)BTForgetPwdActivity.this, BTCountryListActivity.class);
                BTForgetPwdActivity.this.startActivityForResult(it, 1);
            }
        });
        this.phoneNumberEt = (EditText)this.findViewById(R.id.et_edit_phone);
        this.phoneTypeRl = (RelativeLayout)this.findViewById(R.id.account_phone);
        this.emailEt = (EditText)this.findViewById(R.id.et_edit_email);
        this.gotoLoginTv = (TextView)this.findViewById(R.id.tv_login);
        this.gotoLoginTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTForgetPwdActivity.this.onBackPressed();
            }
        });
        this.setText();
        if (type != -1) {
            this.setSelected(type);
            if (type == 1) {
                this.areaCodeTv.setText((CharSequence)("+" + areaCode));
                this.phoneNumberEt.setText((CharSequence)value);
            } else {
                this.emailEt.setText((CharSequence)value);
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1 && requestCode == 1) {
            this.areaCodeTv.setText((CharSequence)data.getStringExtra("area_code"));
        }
    }

    private void setText() {
        if (this.isZh) {
            this.title.setText((CharSequence)this.resources.getString(R.string.btlogin_forget_title_zh));
            this.gotoLoginTv.setText((CharSequence)this.resources.getString(R.string.btlogin_forget_goto_login_zh));
            this.phoneTypeTv.setText((CharSequence)this.resources.getString(R.string.btlogin_type_phone_zh));
            this.emailTypeTv.setText((CharSequence)this.resources.getString(R.string.btlogin_type_email_zh));
            this.phoneNumberEt.setHint(R.string.btlogin_account_phone_zh);
            this.emailEt.setHint(R.string.btlogin_type_email_zh);
            this.phoneErrorNote = this.resources.getString(R.string.btlogin_phone_error_zh);
            this.phoneNotRegisteredNote = this.resources.getString(R.string.btlogin_no_phone_error_zh);
            this.emailNoteRegisteredNote = this.resources.getString(R.string.btlogin_no_email_error_zh);
            this.emailErrorNote = this.resources.getString(R.string.btlogin_email_error_zh);
            this.nextStepTv.setText((CharSequence)this.resources.getString(R.string.btlogin_next_step_zh));
        } else {
            this.title.setText((CharSequence)this.resources.getString(R.string.btlogin_forget_title_en));
            this.phoneTypeTv.setText((CharSequence)this.resources.getString(R.string.btlogin_type_phone_en));
            this.emailTypeTv.setText((CharSequence)this.resources.getString(R.string.btlogin_type_email_en));
            this.phoneNumberEt.setHint(R.string.btlogin_account_phone_en);
            this.emailEt.setHint(R.string.btlogin_type_email_en);
            this.phoneErrorNote = this.resources.getString(R.string.btlogin_phone_error_en);
            this.phoneNotRegisteredNote = this.resources.getString(R.string.btlogin_no_phone_error_en);
            this.emailNoteRegisteredNote = this.resources.getString(R.string.btlogin_no_email_error_en);
            this.emailErrorNote = this.resources.getString(R.string.btlogin_email_error_en);
            this.gotoLoginTv.setText((CharSequence)this.resources.getString(R.string.btlogin_forget_goto_login_en));
            this.nextStepTv.setText((CharSequence)this.resources.getString(R.string.btlogin_next_step_en));
        }
    }

    private void setSelected(int selected) {
        this.selectedType = selected;
        if (this.selectedType == 1) {
            this.phoneTypeView.setVisibility(0);
            this.emailTypeView.setVisibility(8);
            this.phoneTypeRl.setVisibility(0);
            this.emailEt.setVisibility(8);
            this.phoneNumberEt.requestFocus();
        } else if (this.selectedType == 2) {
            this.phoneTypeView.setVisibility(8);
            this.emailTypeView.setVisibility(0);
            this.phoneTypeRl.setVisibility(8);
            this.emailEt.setVisibility(0);
            this.emailEt.requestFocus();
        }
    }

    public void onBackPressed() {
        Intent it = new Intent((Context)this, BTLoginActivity.class);
        this.startActivity(it);
        this.finish();
    }
}

