/*
 * Decompiled with CFR 0.152.
 */
package com.beatop.btoplogin.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import com.beatop.btopbase.BTBaseActivity;
import com.beatop.btopbase.module.CaptchaResultEntity;
import com.beatop.btopbase.module.UserInfoEntity;
import com.beatop.btoplogin.R;
import com.beatop.btoplogin.ui.BTSignupActivity;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class BTSetPwdActivity
extends BTBaseActivity {
    private TextView title;
    private ImageView back;
    private TextView phoneTv;
    private EditText verificationEt;
    private TextView getVerificationTv;
    private EditText pwdEt;
    private EditText confirmPwdEt;
    private TextView submitTv;
    private static final int PHONE_TYPE = 1;
    private static final int EMAIL_TYPE = 2;
    private int selectedType;
    private String value;
    private int areaCode;
    private String waitVerification;
    private String getVerification;
    private CountDownTimer timer;
    private String verifyErrorNote;
    private String pwdLengthErrorNote;
    private String pwdErrorNote;
    private String successNote;

    protected void onLanguageChanged() {
        this.setText();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.btlogin_activity_resetpwd);
        Intent it = this.getIntent();
        this.selectedType = it.getIntExtra("type", -1);
        this.value = it.getStringExtra("value");
        this.areaCode = it.getIntExtra("area_code", -1);
        this.initView();
        this.initTimer();
        this.timer.start();
    }

    private void initView() {
        this.title = (TextView)this.findViewById(R.id.title);
        this.back = (ImageView)this.findViewById(R.id.back);
        this.back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTSetPwdActivity.this.onBackPressed();
            }
        });
        this.phoneTv = (TextView)this.findViewById(R.id.tv_phone);
        this.verificationEt = (EditText)this.findViewById(R.id.et_edit_verification);
        this.getVerificationTv = (TextView)this.findViewById(R.id.tv_get_verification);
        this.getVerificationTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTSetPwdActivity.this.sendVerification();
            }
        });
        this.getVerificationTv.setBackgroundResource(R.drawable.btlogin_redio_rect_disable);
        this.getVerificationTv.setTextColor(this.resources.getColor(R.color.btbase_color_text_gray));
        this.getVerificationTv.setClickable(false);
        this.pwdEt = (EditText)this.findViewById(R.id.et_new_pwd);
        this.confirmPwdEt = (EditText)this.findViewById(R.id.et_confirm_pwd);
        this.submitTv = (TextView)this.findViewById(R.id.tv_reset_button);
        this.submitTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BTSetPwdActivity.this.signUp();
            }
        });
        this.setText();
    }

    private void signUp() {
        if (this.pwdEt.getText().toString().length() < 6) {
            this.showMsg(this.pwdLengthErrorNote);
            return;
        }
        if (!this.pwdEt.getText().toString().equals(this.confirmPwdEt.getText().toString())) {
            this.showMsg(this.pwdErrorNote);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.verificationEt.getText().toString())) {
            this.showMsg(this.verifyErrorNote);
            return;
        }
        if (this.selectedType == 1) {
            netWorkServer.signup("" + this.areaCode, this.value, "", this.pwdEt.getText().toString(), this.verificationEt.getText().toString(), "", "").enqueue((Callback)new Callback<UserInfoEntity>(){

                public void onResponse(Call<UserInfoEntity> call, Response<UserInfoEntity> response) {
                    if (((UserInfoEntity)response.body()).getError() != null) {
                        BTSetPwdActivity.this.showMsg(((UserInfoEntity)response.body()).getError().getMessage());
                    } else {
                        BTSetPwdActivity.this.showMsg(BTSetPwdActivity.this.successNote);
                        BTSetPwdActivity.this.finish();
                    }
                }

                public void onFailure(Call<UserInfoEntity> call, Throwable t) {
                    BTSetPwdActivity.this.showMsg(BTSetPwdActivity.this.netErrorNote);
                }
            });
        } else {
            netWorkServer.signup("", "", this.value, this.pwdEt.getText().toString(), this.verificationEt.getText().toString(), "", "").enqueue((Callback)new Callback<UserInfoEntity>(){

                public void onResponse(Call<UserInfoEntity> call, Response<UserInfoEntity> response) {
                    if (((UserInfoEntity)response.body()).getError() != null) {
                        BTSetPwdActivity.this.showMsg(((UserInfoEntity)response.body()).getError().getMessage());
                    } else {
                        BTSetPwdActivity.this.showMsg(BTSetPwdActivity.this.successNote);
                        BTSetPwdActivity.this.finish();
                    }
                }

                public void onFailure(Call<UserInfoEntity> call, Throwable t) {
                    BTSetPwdActivity.this.showMsg(BTSetPwdActivity.this.netErrorNote);
                }
            });
        }
    }

    private void setText() {
        if (this.isZh) {
            this.title.setText((CharSequence)this.resources.getString(R.string.btlogin_setpwd_title_zh));
            if (this.selectedType == 1) {
                this.phoneTv.setText((CharSequence)String.format(this.resources.getString(R.string.btlogin_reset_phone_zh), this.areaCode, this.value));
            } else if (this.selectedType == 2) {
                this.phoneTv.setText((CharSequence)String.format(this.resources.getString(R.string.btlogin_reset_email_zh), this.value));
            }
            this.verificationEt.setHint(R.string.btlogin_reset_verification_zh);
            this.waitVerification = this.resources.getString(R.string.btlogin_reset_wait_zh);
            this.getVerification = this.resources.getString(R.string.btlogin_reset_get_zh);
            this.pwdEt.setHint(R.string.btloing_reset_pwd_hint_zh);
            this.confirmPwdEt.setHint(R.string.btlogin_reset_confirm_hint_zh);
            this.submitTv.setText((CharSequence)this.resources.getString(R.string.btlogin_setpwd_submit_zh));
            this.verifyErrorNote = this.resources.getString(R.string.btlogin_reset_verify_error_zh);
            this.successNote = this.resources.getString(R.string.btlogin_setpwd_success_zh);
            this.pwdLengthErrorNote = this.resources.getString(R.string.btlogin_pwd_type_error_zh);
            this.pwdErrorNote = this.resources.getString(R.string.btlogin_reset_pwd_differ_error_zh);
        } else {
            this.title.setText((CharSequence)this.resources.getString(R.string.btlogin_setpwd_title_en));
            if (this.selectedType == 1) {
                this.phoneTv.setText((CharSequence)String.format(this.resources.getString(R.string.btlogin_reset_phone_en), this.areaCode, this.value));
            } else if (this.selectedType == 2) {
                this.phoneTv.setText((CharSequence)String.format(this.resources.getString(R.string.btlogin_reset_email_en), this.value));
            }
            this.verificationEt.setHint(R.string.btlogin_reset_verification_en);
            this.waitVerification = this.resources.getString(R.string.btlogin_reset_wait_en);
            this.getVerification = this.resources.getString(R.string.btlogin_reset_get_en);
            this.pwdEt.setHint(R.string.btloing_reset_pwd_hint_en);
            this.confirmPwdEt.setHint(R.string.btlogin_reset_confirm_hint_en);
            this.submitTv.setText((CharSequence)this.resources.getString(R.string.btlogin_setpwd_submit_en));
            this.verifyErrorNote = this.resources.getString(R.string.btlogin_reset_verify_error_en);
            this.successNote = this.resources.getString(R.string.btlogin_setpwd_success_en);
            this.pwdLengthErrorNote = this.resources.getString(R.string.btlogin_pwd_type_error_en);
            this.pwdErrorNote = this.resources.getString(R.string.btlogin_reset_pwd_differ_error_en);
        }
        this.getVerificationTv.setText((CharSequence)this.getVerification);
    }

    private void initTimer() {
        this.timer = new CountDownTimer(60000L, 1000L){

            public void onTick(long millisUntilFinished) {
                int time = (int)millisUntilFinished / 1000;
                BTSetPwdActivity.this.getVerificationTv.setText((CharSequence)String.format(BTSetPwdActivity.this.waitVerification, time));
            }

            public void onFinish() {
                BTSetPwdActivity.this.getVerificationTv.setText((CharSequence)BTSetPwdActivity.this.getVerification);
                BTSetPwdActivity.this.getVerificationTv.setTextColor(BTSetPwdActivity.this.resources.getColor(R.color.btbase_color_main));
                BTSetPwdActivity.this.getVerificationTv.setBackgroundResource(R.drawable.btlogin_redio_rect);
                BTSetPwdActivity.this.getVerificationTv.setClickable(true);
            }
        };
    }

    private void sendVerification() {
        this.getVerificationTv.setClickable(false);
        netWorkServer.getCaptcha("" + this.areaCode, this.value, "signup").enqueue((Callback)new Callback<CaptchaResultEntity>(){

            public void onResponse(Call<CaptchaResultEntity> call, Response<CaptchaResultEntity> response) {
                if (((CaptchaResultEntity)response.body()).getError() != null) {
                    BTSetPwdActivity.this.showMsg(((CaptchaResultEntity)response.body()).getError().getMessage());
                    BTSetPwdActivity.this.getVerificationTv.setClickable(true);
                } else if (((CaptchaResultEntity)response.body()).getCode() == 1) {
                    Log.d((String)BTSetPwdActivity.this.TAG, (String)("onResponse: " + ((CaptchaResultEntity)response.body()).getCaptcha()));
                    BTSetPwdActivity.this.getVerificationTv.setBackgroundResource(R.drawable.btlogin_redio_rect_disable);
                    BTSetPwdActivity.this.getVerificationTv.setTextColor(BTSetPwdActivity.this.resources.getColor(R.color.btbase_color_text_gray));
                    BTSetPwdActivity.this.timer.start();
                } else {
                    BTSetPwdActivity.this.showMsg(((CaptchaResultEntity)response.body()).getMessage());
                    BTSetPwdActivity.this.getVerificationTv.setClickable(true);
                }
            }

            public void onFailure(Call<CaptchaResultEntity> call, Throwable t) {
                BTSetPwdActivity.this.showMsg(BTSetPwdActivity.this.netErrorNote);
            }
        });
    }

    public void onBackPressed() {
        Intent it = new Intent((Context)this, BTSignupActivity.class);
        it.putExtra("type", this.selectedType);
        it.putExtra("value", this.value);
        it.putExtra("area_code", this.areaCode);
        this.startActivity(it);
        this.finish();
    }
}

