/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.handler;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.sina.weibo.sdk.api.share.BaseRequest;
import com.sina.weibo.sdk.api.share.BaseResponse;
import com.sina.weibo.sdk.api.share.IWeiboShareAPI;
import com.sina.weibo.sdk.api.share.SendMultiMessageToWeiboRequest;
import com.sina.weibo.sdk.api.share.WeiboShareSDK;
import com.sina.weibo.sdk.auth.AuthInfo;
import com.sina.weibo.sdk.auth.WeiboAuthListener;
import com.sina.weibo.sdk.auth.sso.SsoHandler;
import com.sina.weibo.sdk.exception.WeiboException;
import com.sina.weibo.sdk.net.AsyncWeiboRunner;
import com.sina.weibo.sdk.net.RequestListener;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.utils.LogUtil;
import com.umeng.socialize.Config;
import com.umeng.socialize.PlatformConfig;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.SocializeException;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.common.QueuedWork;
import com.umeng.socialize.handler.SinaPreferences;
import com.umeng.socialize.handler.UMSSOHandler;
import com.umeng.socialize.media.SinaShareContent;
import com.umeng.socialize.net.PlatformTokenUploadReq;
import com.umeng.socialize.net.PlatformTokenUploadResponse;
import com.umeng.socialize.net.RestAPI;
import com.umeng.socialize.utils.Log;
import com.umeng.socialize.utils.SocializeUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SinaSsoHandler
extends UMSSOHandler {
    private static final String TAG = "SinaSsoHandler";
    private static final int REQUEST_CODE = 5659;
    private PlatformConfig.SinaWeibo config = null;
    private SinaPreferences sinaPreferences;
    private UMShareListener shareListener;
    private AuthListener mAuthListener;
    private Context mContext;
    private SsoHandler mSsoHandler;
    private AuthInfo mAuthInfo;
    public static final String SCOPE = "email,direct_messages_read,direct_messages_write,friendships_groups_read,friendships_groups_write,statuses_to_me_read,follow_app_official_microblog,invitation_write";
    private IWeiboShareAPI mWeiboShareAPI;

    public void onCreate(Context context, PlatformConfig.Platform p) {
        super.onCreate(context, p);
        this.mContext = context.getApplicationContext();
        this.config = (PlatformConfig.SinaWeibo)p;
        this.sinaPreferences = new SinaPreferences(this.mContext, "sina");
        this.mAuthInfo = new AuthInfo(context, ((PlatformConfig.SinaWeibo)p).appKey, Config.REDIRECT_URL, SCOPE);
        if (!(context instanceof Activity)) {
            return;
        }
        this.mSsoHandler = new SsoHandler((Activity)context, this.mAuthInfo);
        this.mWeiboShareAPI = WeiboShareSDK.createWeiboAPI((Context)context, (String)this.config.appKey);
        this.mWeiboShareAPI.registerApp();
        Log.e((String)TAG, (String)("handleid=" + (Object)((Object)this)));
    }

    public IWeiboShareAPI getmWeiboShareAPI() {
        return this.mWeiboShareAPI;
    }

    public boolean isInstall() {
        return this.isClientInstalled();
    }

    public boolean isAuthorize() {
        return this.sinaPreferences.isAuthorized();
    }

    public boolean isClientInstalled() {
        return this.mWeiboShareAPI.isWeiboAppInstalled();
    }

    public boolean isSupport() {
        return this.mWeiboShareAPI.isWeiboAppSupportAPI();
    }

    public String getSDKVersion() {
        return "3.1.4";
    }

    public void authorize(UMAuthListener listener) {
        this.mAuthListener = new AuthListener(listener);
        this.mSsoHandler.authorize((WeiboAuthListener)this.mAuthListener);
    }

    protected void requestAsync(String url, WeiboParameters params, String httpMethod, RequestListener listener, String mAccessToken) {
        if (null == mAccessToken || TextUtils.isEmpty((CharSequence)url) || null == params || TextUtils.isEmpty((CharSequence)httpMethod) || null == listener) {
            LogUtil.e((String)TAG, (String)"Argument error!");
            return;
        }
        params.put("access_token", mAccessToken);
        new AsyncWeiboRunner(this.mContext).requestAsync(url, params, httpMethod, listener);
    }

    public void getPlatformInfo(final UMAuthListener listener) {
        if (this.sinaPreferences.getUID() != null) {
            WeiboParameters params = new WeiboParameters(this.config.appKey);
            params.put("uid", this.sinaPreferences.getUID());
            this.requestAsync("https://api.weibo.com/2/users/show.json", params, "GET", new RequestListener(){

                public void onComplete(String s) {
                    Map<String, String> map = new HashMap();
                    map = SocializeUtils.jsonToMap((String)s);
                    if (SinaSsoHandler.this.sinaPreferences != null) {
                        map.put("uid", SinaSsoHandler.this.sinaPreferences.getUID());
                        map.put("access_token", SinaSsoHandler.this.sinaPreferences.getmAccessToken());
                        map.put("refresh_token", SinaSsoHandler.this.sinaPreferences.getmRefreshToken());
                        map.put("expires_in", String.valueOf(SinaSsoHandler.this.sinaPreferences.getmTTL()));
                    }
                    listener.onComplete(SHARE_MEDIA.SINA, 2, map);
                }

                public void onWeiboException(WeiboException e) {
                    listener.onError(SHARE_MEDIA.SINA, 2, new Throwable((Throwable)e));
                }
            }, this.sinaPreferences.getmAccessToken());
        } else {
            this.authorize(new UMAuthListener(){

                public void onComplete(SHARE_MEDIA platform, int action, Map<String, String> data) {
                    QueuedWork.runInBack((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            SinaSsoHandler.this.getPlatformInfo(listener);
                        }
                    });
                }

                public void onError(SHARE_MEDIA platform, int action, Throwable t) {
                }

                public void onCancel(SHARE_MEDIA platform, int action) {
                }
            });
        }
    }

    public void deleteAuth(UMAuthListener listener) {
        this.sinaPreferences.delete();
        listener.onComplete(SHARE_MEDIA.SINA, 1, null);
    }

    public boolean share(ShareContent content, final UMShareListener listener) {
        SinaShareContent mSharecontent = new SinaShareContent(content);
        SendMultiMessageToWeiboRequest request = new SendMultiMessageToWeiboRequest();
        request.transaction = String.valueOf(System.currentTimeMillis());
        request.multiMessage = mSharecontent.getMessage();
        AuthInfo authInfo = new AuthInfo(this.getContext(), this.config.appKey, Config.REDIRECT_URL, SCOPE);
        String token = "";
        if (this.sinaPreferences != null) {
            token = this.sinaPreferences.getmAccessToken();
        }
        this.shareListener = listener;
        if (this.mWeakAct.get() != null && !((Activity)this.mWeakAct.get()).isFinishing()) {
            this.mWeiboShareAPI.sendRequest((Activity)this.mWeakAct.get(), (BaseRequest)request, authInfo, token, new WeiboAuthListener(){

                public void onWeiboException(WeiboException arg0) {
                    Log.d((String)"sina_share", (String)"weibo share exception");
                    if (listener != null) {
                        listener.onError(SHARE_MEDIA.SINA, new Throwable((Throwable)arg0));
                    }
                }

                public void onComplete(Bundle bundle) {
                    SinaSsoHandler.this.uploadAuthData(bundle);
                    if (listener != null) {
                        listener.onResult(SHARE_MEDIA.SINA);
                    }
                    if (bundle != null) {
                        Log.e((String)"sinashare", (String)("msg = " + bundle.getString("msg")));
                    }
                    SinaSsoHandler.this.sinaPreferences.setAuthData(bundle).commit();
                }

                public void onCancel() {
                    Log.d((String)"sina_share", (String)"weibo share cancel");
                    if (listener != null) {
                        listener.onCancel(SHARE_MEDIA.SINA);
                    }
                }
            });
        }
        return true;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.mSsoHandler != null) {
            this.mSsoHandler.authorizeCallBack(requestCode, resultCode, data);
        }
        this.mSsoHandler = null;
    }

    public boolean isSupportAuth() {
        return true;
    }

    public int getRequestCode() {
        return 5659;
    }

    public void setScope(String[] permissions) {
    }

    public void onResponse(BaseResponse baseResponse) {
        switch (baseResponse.errCode) {
            case 0: {
                Log.d((String)"sina_share", (String)"weibo share error ok");
                if (!this.isClientInstalled()) break;
                this.shareListener.onResult(SHARE_MEDIA.SINA);
                break;
            }
            case 1: {
                Log.d((String)"sina_share", (String)"weibo share cancel");
                this.shareListener.onCancel(SHARE_MEDIA.SINA);
                break;
            }
            case 2: {
                Log.d((String)"sina_share", (String)"weibo share fail");
                this.shareListener.onError(SHARE_MEDIA.SINA, new Throwable(baseResponse.errMsg));
            }
        }
    }

    private Map<String, String> bundleTomap(Bundle bundle) {
        if (bundle == null || bundle.isEmpty()) {
            return null;
        }
        Set keys = bundle.keySet();
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : keys) {
            Log.e((String)("authxx key=" + key + "   value=" + bundle.getString(key)));
            map.put(key, bundle.getString(key));
        }
        return map;
    }

    private void uploadAuthData(final Bundle bundle) throws SocializeException {
        new Thread(new Runnable(){

            @Override
            public void run() {
                PlatformTokenUploadReq req = new PlatformTokenUploadReq(SinaSsoHandler.this.getContext());
                req.addStringParams("to", "sina");
                req.addStringParams("usid", bundle.getString("uid"));
                req.addStringParams("access_token", bundle.getString("access_token"));
                req.addStringParams("refresh_token", bundle.getString("refresh_token"));
                req.addStringParams("expires_in", bundle.getString("expires_in"));
                PlatformTokenUploadResponse resp = RestAPI.uploadPlatformToken((PlatformTokenUploadReq)req);
            }
        }).start();
    }

    class AuthListener
    implements WeiboAuthListener {
        private UMAuthListener mListener = null;

        AuthListener(UMAuthListener listener) {
            this.mListener = listener;
        }

        public void onComplete(Bundle values) {
            SinaSsoHandler.this.sinaPreferences.setAuthData(values).commit();
            SinaSsoHandler.this.uploadAuthData(values);
            if (this.mListener != null) {
                this.mListener.onComplete(SHARE_MEDIA.SINA, 0, SocializeUtils.bundleTomap((Bundle)values));
            }
        }

        public void onCancel() {
            if (this.mListener != null) {
                this.mListener.onCancel(SHARE_MEDIA.SINA, 0);
            }
        }

        public void onWeiboException(WeiboException e) {
            if (this.mListener != null) {
                this.mListener.onError(SHARE_MEDIA.SINA, 0, new Throwable((Throwable)e));
            }
        }
    }
}

