/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.handler;

import android.app.Activity;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.widget.Toast;
import com.tencent.mm.sdk.modelbase.BaseReq;
import com.tencent.mm.sdk.modelbase.BaseResp;
import com.tencent.mm.sdk.modelmsg.SendAuth;
import com.tencent.mm.sdk.modelmsg.SendMessageToWX;
import com.tencent.mm.sdk.openapi.IWXAPI;
import com.tencent.mm.sdk.openapi.IWXAPIEventHandler;
import com.tencent.mm.sdk.openapi.WXAPIFactory;
import com.umeng.socialize.Config;
import com.umeng.socialize.PlatformConfig;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.SocializeException;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.common.QueuedWork;
import com.umeng.socialize.handler.UMSSOHandler;
import com.umeng.socialize.handler.WeixinPreferences;
import com.umeng.socialize.media.WeiXinShareContent;
import com.umeng.socialize.net.PlatformTokenUploadReq;
import com.umeng.socialize.net.PlatformTokenUploadResponse;
import com.umeng.socialize.net.RestAPI;
import com.umeng.socialize.utils.Dummy;
import com.umeng.socialize.utils.Log;
import com.umeng.socialize.utils.SocializeUtils;
import com.umeng.socialize.weixin.net.WXAuthUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UMWXHandler
extends UMSSOHandler {
    private static final String TAG = "UMWXHandler";
    private static final int REQUEST_CODE = 10086;
    private static final int REFRESH_TOKEN_EXPIRES = 604800;
    private static final int RESP_TYPE_AUTH = 1;
    private static final int RESP_TYPE_SHARE = 2;
    private static String sScope = "snsapi_userinfo,snsapi_friend,snsapi_message";
    private WeiXinShareContent mShareContent;
    private PlatformConfig.Weixin config;
    private WeixinPreferences weixinPreferences;
    private UMAuthListener mAuthListener;
    private UMAuthListener mAuthListenerBackup;
    private UMShareListener umShareListener;
    private SHARE_MEDIA mTarget = SHARE_MEDIA.WEIXIN;
    private boolean isToCircle = false;
    private IWXAPI mWXApi;
    private IWXAPIEventHandler mEventHandler = new IWXAPIEventHandler(){

        public void onResp(BaseResp resp) {
            int type = resp.getType();
            switch (type) {
                case 1: {
                    UMWXHandler.this.onAuthCallback((SendAuth.Resp)resp);
                    break;
                }
                case 2: {
                    UMWXHandler.this.onShareCallback((SendMessageToWX.Resp)resp);
                    break;
                }
            }
        }

        public void onReq(BaseReq req) {
        }
    };

    public void onCreate(Context context, PlatformConfig.Platform p) {
        super.onCreate(context, p);
        this.weixinPreferences = new WeixinPreferences(context.getApplicationContext(), "weixin");
        this.config = (PlatformConfig.Weixin)p;
        this.mWXApi = WXAPIFactory.createWXAPI((Context)context.getApplicationContext(), (String)this.config.appId);
        this.mWXApi.registerApp(this.config.appId);
        if (!this.isInstall()) {
            StringBuilder msb = new StringBuilder();
            msb.append("\u8bf7\u5b89\u88c5");
            msb.append(this.mTarget);
            msb.append("\u5ba2\u6237\u7aef");
            if (Config.IsToastTip) {
                Toast.makeText((Context)context.getApplicationContext(), (CharSequence)msb.toString(), (int)0).show();
            }
        }
        Log.e((String)TAG, (String)("handleid=" + (Object)((Object)this)));
    }

    public void setAuthListener(UMAuthListener listener) {
        this.mAuthListenerBackup = listener;
    }

    public void authorize(UMAuthListener listener) {
        this.mAuthListener = listener;
        this.mTarget = this.config.getName();
        if (this.weixinPreferences.isAuthValid()) {
            String refreshToken;
            if (this.weixinPreferences.isAccessTokenAvailable()) {
                refreshToken = this.weixinPreferences.getRefreshToken();
                String url = "https://api.weixin.qq.com/sns/oauth2/refresh_token?appid=" + this.config.appId + "&grant_type=refresh_token&refresh_token=" + refreshToken;
                this.loadOauthData(url);
            }
            refreshToken = this.weixinPreferences.getRefreshToken();
            Map<String, String> map = this.getAuthWithRefreshToken(refreshToken);
            this.mAuthListener.onComplete(SHARE_MEDIA.WEIXIN, 0, map);
        } else {
            SendAuth.Req req = new SendAuth.Req();
            req.scope = sScope;
            req.state = "none";
            this.mWXApi.sendReq((BaseReq)req);
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (Config.dialogSwitch) {
                        Dialog dialog = UMWXHandler.this.createWaitDialog();
                        SocializeUtils.safeShowDialog((Dialog)dialog);
                    }
                }
            });
        }
    }

    private Dialog createWaitDialog() {
        if (Config.wxdialog != null && Config.wxdialog.getOwnerActivity() != this.mWeakAct.get()) {
            Config.wxdialog = null;
        }
        if (Config.wxdialog == null && this.mWeakAct.get() != null) {
            Config.wxdialog = new ProgressDialog((Context)this.mWeakAct.get());
            Config.wxdialog.setOwnerActivity((Activity)this.mWeakAct.get());
            Config.wxdialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

                public boolean onKey(DialogInterface dialogInterface, int i, KeyEvent keyEvent) {
                    if (i == 4 && keyEvent.getRepeatCount() == 0) {
                        SocializeUtils.safeCloseDialog((Dialog)Config.wxdialog);
                    }
                    return false;
                }
            });
        }
        return Config.wxdialog;
    }

    public boolean isAuthorize() {
        return this.weixinPreferences.isAuth();
    }

    private void loadOauthData(String url) {
        String response = WXAuthUtils.request(url);
        Bundle bundle = this.parseAuthData(response);
        this.weixinPreferences.setBundle(bundle);
    }

    private Bundle parseAuthData(String response) {
        Bundle bundle = new Bundle();
        if (TextUtils.isEmpty((CharSequence)response)) {
            return bundle;
        }
        try {
            JSONObject jsonObject = new JSONObject(response);
            Iterator iterator = jsonObject.keys();
            String key = "";
            while (iterator.hasNext()) {
                key = (String)iterator.next();
                bundle.putString(key, jsonObject.optString(key));
            }
            bundle.putString("uid", bundle.getString("openid"));
            bundle.putLong("refresh_token_expires", 604800L);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return bundle;
    }

    private Map<String, String> getAuthWithRefreshToken(String refresh_token) {
        StringBuilder authURL = new StringBuilder();
        authURL.append("https://api.weixin.qq.com/sns/oauth2/refresh_token?");
        authURL.append("appid=").append(this.config.appId);
        authURL.append("&grant_type=refresh_token");
        authURL.append("&refresh_token=").append(refresh_token);
        String response = WXAuthUtils.request(authURL.toString());
        Map map = null;
        try {
            map = SocializeUtils.jsonToMap((String)response);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    private void getAuthWithCode(String code, final UMAuthListener listener) {
        final StringBuilder authURL = new StringBuilder();
        authURL.append("https://api.weixin.qq.com/sns/oauth2/access_token?");
        authURL.append("appid=").append(this.config.appId);
        authURL.append("&secret=").append(this.config.appSecret);
        authURL.append("&code=").append(code);
        authURL.append("&grant_type=authorization_code");
        new Thread(new Runnable(){

            @Override
            public void run() {
                String response = WXAuthUtils.request(authURL.toString());
                Map<String, String> map = null;
                try {
                    map = SocializeUtils.jsonToMap((String)response);
                    if (map == null || map.size() == 0) {
                        map = UMWXHandler.this.weixinPreferences.getmap();
                    }
                    Bundle bundle = UMWXHandler.this.parseAuthData(response);
                    UMWXHandler.this.weixinPreferences.setBundle(bundle);
                    final Map<String, String> finalMap = map;
                    QueuedWork.runInMain((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            UMWXHandler.this.uploadAuthData(finalMap);
                            listener.onComplete(SHARE_MEDIA.WEIXIN, 0, finalMap);
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
    }

    public boolean isInstall() {
        return this.mWXApi.isWXAppInstalled();
    }

    protected void onAuthCallback(SendAuth.Resp resp) {
        if (Config.dialogSwitch) {
            SocializeUtils.safeCloseDialog((Dialog)Config.wxdialog);
        }
        if (this.mAuthListener == null) {
            this.mAuthListener = this.mAuthListenerBackup;
            Log.e((String)("UMWXHandlermAuthListener =" + this.mAuthListener));
        }
        UMAuthListener authListener = (UMAuthListener)Dummy.get(UMAuthListener.class, (Object)this.mAuthListener);
        if (resp.errCode == 0) {
            this.getAuthWithCode(resp.code, authListener);
        } else if (resp.errCode == -2) {
            if (authListener != null) {
                authListener.onCancel(SHARE_MEDIA.WEIXIN, 0);
            } else {
                Log.e((String)"UMWXHandlerauthListener == null");
            }
        } else {
            CharSequence err = TextUtils.concat((CharSequence[])new CharSequence[]{"weixin auth error (", String.valueOf(resp.errCode), "):", resp.errStr});
            SocializeException ex = new SocializeException(err.toString());
            if (authListener != null) {
                authListener.onError(SHARE_MEDIA.WEIXIN, 0, (Throwable)ex);
            }
        }
    }

    public String getSDKVersion() {
        return "3.1.1";
    }

    public void deleteAuth(UMAuthListener listener) {
        if (!this.isInstall()) {
            return;
        }
        this.weixinPreferences.delete();
        listener.onComplete(SHARE_MEDIA.WEIXIN, 1, null);
    }

    public boolean isSupportAuth() {
        return true;
    }

    public int getRequestCode() {
        if (this.isToCircle) {
            return 10085;
        }
        return 10086;
    }

    private void refreshAccessToken() {
        if (this.weixinPreferences != null) {
            if (this.weixinPreferences.isAuthValid()) {
                Log.d((String)"refresh", (String)"requesting access token with refresh");
                String refreshToken = this.weixinPreferences.getRefreshToken();
                String url = "https://api.weixin.qq.com/sns/oauth2/refresh_token?appid=" + this.config.appId + "&grant_type=refresh_token&refresh_token=" + refreshToken;
                String response = WXAuthUtils.request(url);
                Bundle bundle = this.parseAuthData(response);
                this.weixinPreferences.setBundle(bundle);
            } else {
                Log.e((String)"refresh", (String)"weixin refresh token is expired");
            }
        }
    }

    public void getPlatformInfo(final UMAuthListener listener) {
        String uid = this.weixinPreferences.getUID();
        String accessToken = this.weixinPreferences.getAccessToken();
        if (this.weixinPreferences != null) {
            this.weixinPreferences.delete();
        }
        if (TextUtils.isEmpty((CharSequence)uid) || TextUtils.isEmpty((CharSequence)accessToken) || !this.weixinPreferences.isAccessTokenAvailable() || this.weixinPreferences.isAuthValid()) {
            Log.e((String)TAG, (String)"please check had authed...");
            this.authorize(new UMAuthListener(){

                public void onComplete(SHARE_MEDIA platform, int action, Map<String, String> data) {
                    QueuedWork.runInBack((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            UMWXHandler.this.getPlatformInfo(listener);
                        }
                    });
                }

                public void onError(SHARE_MEDIA platform, int action, Throwable t) {
                    listener.onError(platform, action, t);
                }

                public void onCancel(SHARE_MEDIA platform, int action) {
                    listener.onCancel(platform, action);
                }
            });
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("https://api.weixin.qq.com/sns/userinfo?access_token=");
        builder.append(accessToken).append("&openid=").append(uid);
        builder.append("&lang=zh_CN");
        final String jsonStr = WXAuthUtils.request(builder.toString());
        final Map<String, String> map = this.parseUserInfo(jsonStr);
        if (map == null) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    listener.onError(SHARE_MEDIA.WEIXIN, 2, new Throwable(jsonStr));
                }
            });
        } else {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    listener.onComplete(SHARE_MEDIA.WEIXIN, 2, map);
                }
            });
        }
    }

    private void uploadAuthData(final Map<String, String> bundle) throws SocializeException {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (UMWXHandler.this.getContext() != null) {
                    PlatformTokenUploadReq req = new PlatformTokenUploadReq(UMWXHandler.this.getContext());
                    req.addStringParams("to", "wxsession");
                    req.addStringParams("usid", (String)bundle.get("uid"));
                    req.addStringParams("access_token", (String)bundle.get("access_token"));
                    req.addStringParams("refresh_token", (String)bundle.get("refresh_token"));
                    req.addStringParams("expires_in", (String)bundle.get("expires_in"));
                    PlatformTokenUploadResponse resp = RestAPI.uploadPlatformToken((PlatformTokenUploadReq)req);
                    Log.e((String)("upload token resp = " + resp));
                }
            }
        }).start();
    }

    private Map<String, String> parseUserInfo(String result) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            JSONObject jsonObject = new JSONObject(result);
            boolean error = jsonObject.has("errcode");
            if (error) {
                Log.e((String)TAG, (String)(result + ""));
                map.put("errcode", jsonObject.getString("errcode"));
                return map;
            }
            Log.e((String)("xxxxxx json=" + result));
            map.put("openid", jsonObject.opt("openid").toString());
            map.put("screen_name", jsonObject.opt("nickname").toString());
            map.put("language", jsonObject.opt("language").toString());
            map.put("city", jsonObject.opt("city").toString());
            map.put("province", jsonObject.opt("province").toString());
            map.put("country", jsonObject.opt("country").toString());
            map.put("profile_image_url", jsonObject.opt("headimgurl").toString());
            map.put("unionid", jsonObject.opt("unionid").toString());
            map.put("gender", jsonObject.opt("sex").toString());
            JSONArray jsonArray = jsonObject.getJSONArray("privilege");
            int len = jsonArray.length();
            if (len > 0) {
                String[] privileges = new String[len];
                for (int i = 0; i < len; ++i) {
                    privileges[i] = jsonArray.get(i).toString();
                }
                map.put("privilege", privileges.toString());
            }
            if (this.weixinPreferences != null) {
                map.put("openid", this.weixinPreferences.getUID());
                map.put("unionid", this.weixinPreferences.getmUnionid());
                map.put("access_token", this.weixinPreferences.getAccessToken());
                map.put("refresh_token", this.weixinPreferences.getRefreshToken());
                map.put("expires_in", String.valueOf(this.weixinPreferences.getmAccessTokenTTL()));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            return Collections.emptyMap();
        }
        return map;
    }

    public boolean share(ShareContent content, UMShareListener listener) {
        this.mTarget = this.config.getName();
        if (!this.isInstall()) {
            if (Config.IsToastTip) {
                Log.e((String)"\u4f60\u8fd8\u6ca1\u6709\u5b89\u88c5\u5fae\u4fe1");
            }
            return false;
        }
        this.mShareContent = new WeiXinShareContent(content);
        if (this.mShareContent != null) {
            this.mShareContent.parseMediaType();
            if (this.mShareContent.mShareType == "emoji" && this.isToCircle) {
                Toast.makeText((Context)this.getContext(), (CharSequence)"\u5fae\u4fe1\u670b\u53cb\u5708\u4e0d\u652f\u6301\u8868\u60c5\u5206\u4eab...", (int)0).show();
                return false;
            }
        }
        this.umShareListener = listener;
        return this.shareTo(new WeiXinShareContent(content));
    }

    public boolean isSupport() {
        return this.mWXApi.isWXAppSupportAPI();
    }

    public boolean shareTo(WeiXinShareContent shareContent) {
        SendMessageToWX.Req req = new SendMessageToWX.Req();
        req.transaction = this.buildTransaction(this.mShareContent.mShareType);
        req.message = shareContent.getWxMediaMessage();
        switch (this.mTarget) {
            case WEIXIN: {
                req.scene = 0;
                break;
            }
            case WEIXIN_CIRCLE: {
                req.scene = 1;
                break;
            }
            case WEIXIN_FAVORITE: {
                req.scene = 2;
                break;
            }
            default: {
                req.scene = 2;
            }
        }
        if (req.message == null) {
            Log.e((String)"wx,message = null");
            return false;
        }
        if (req.message.mediaObject == null) {
            Log.e((String)"wx,mediaobject = null");
            return false;
        }
        boolean sendReq = this.mWXApi.sendReq((BaseReq)req);
        if (!sendReq) {
            this.umShareListener.onError(this.mTarget, new Throwable("sendReq = false,\u8bf7\u68c0\u67e5\u5206\u4eab\u7c7b\u578b"));
        }
        return sendReq;
    }

    protected void onShareCallback(SendMessageToWX.Resp resp) {
        switch (resp.errCode) {
            case 0: {
                if (this.umShareListener == null) break;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("uid", resp.openId);
                this.uploadAuthData(map);
                this.umShareListener.onResult(this.mTarget);
                break;
            }
            case -2: {
                if (this.umShareListener == null) break;
                this.umShareListener.onCancel(this.mTarget);
                break;
            }
            case -3: 
            case -1: {
                if (this.umShareListener == null) break;
                this.umShareListener.onError(this.mTarget, (Throwable)new SocializeException(resp.errCode, resp.errStr));
                break;
            }
            default: {
                Log.d((String)TAG, (String)"\u5fae\u4fe1\u53d1\u9001 -- \u672a\u77e5\u9519\u8bef.");
            }
        }
    }

    public IWXAPIEventHandler getWXEventHandler() {
        return this.mEventHandler;
    }

    public IWXAPI getWXApi() {
        return this.mWXApi;
    }

    private String buildTransaction(String type) {
        return type == null ? String.valueOf(System.currentTimeMillis()) : type + System.currentTimeMillis();
    }
}

