/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.shareboard;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.RelativeLayout;
import com.umeng.socialize.Config;
import com.umeng.socialize.shareboard.wigets.ActionFrameAdapter;
import com.umeng.socialize.shareboard.wigets.UMActionFrame;
import com.umeng.socialize.utils.Log;

public class UMActionBoard
extends RelativeLayout {
    private static final int ANIM_IN_TIME = 150;
    private Context mContext;
    private UMActionFrame mActionFrame;
    private Animation mFrameAnim;
    private View mTouchDisView;

    public UMActionBoard(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public UMActionBoard(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public UMActionBoard(Context context) {
        super(context);
        this.mContext = context;
        this.init();
    }

    private void init() {
        this.mActionFrame = new UMActionFrame(this.mContext);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        layoutParams.addRule(Config.showShareBoardOnTop ? 10 : 12);
        this.mActionFrame.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mFrameAnim = new TranslateAnimation(0.0f, 0.0f, 80.0f, 0.0f);
        this.mFrameAnim.setDuration(150L);
        this.mTouchDisView = new View(this.mContext);
        RelativeLayout.LayoutParams tParams = new RelativeLayout.LayoutParams(-1, -1);
        tParams.addRule(Config.showShareBoardOnTop ? 12 : 10);
        this.mTouchDisView.setLayoutParams((ViewGroup.LayoutParams)tParams);
        this.mTouchDisView.setBackgroundColor(Color.argb((int)50, (int)0, (int)0, (int)0));
        AlphaAnimation alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
        alphaAnimation.setDuration(1500L);
        this.mTouchDisView.setAnimation((Animation)alphaAnimation);
        this.addView(this.mTouchDisView);
        this.addView((View)this.mActionFrame);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        Log.d((String)"onMeasure", (String)("ActionBoard, width = " + width + ", height = " + height));
        ViewGroup.LayoutParams layoutParams = this.mActionFrame.getLayoutParams();
        layoutParams.height = this.mActionFrame.getAdapterHeight(width);
        layoutParams.width = width;
        ViewGroup.LayoutParams tParams = this.mTouchDisView.getLayoutParams();
        tParams.height = height - layoutParams.height;
        tParams.width = width;
    }

    public void activateFrame(ActionFrameAdapter adapter) {
        this.mActionFrame.setAdapter(adapter);
        this.mActionFrame.setBackgroundColor(-16777216);
    }

    public void setFrameOutsideListener(View.OnClickListener listener) {
        this.mTouchDisView.setOnClickListener(listener);
    }

    public void animation() {
        this.mActionFrame.startAnimation(this.mFrameAnim);
    }
}

