/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.editorpage;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.common.ResContainer;
import com.umeng.socialize.common.SocializeConstants;
import com.umeng.socialize.editorpage.KeyboardListenRelativeLayout;
import com.umeng.socialize.utils.Log;
import com.umeng.socialize.utils.SocializeUtils;
import java.io.File;

public class ShareActivity
extends Activity
implements View.OnClickListener {
    private static final String TAG = "ShareActivity";
    private static int MAX_WORD_NUM = 140;
    private String mTitle;
    private String mText;
    private String mImage;
    private ResContainer R;
    private Button mCloseBtn;
    private Button mSendBtn;
    private EditText mEditText;
    private View mPreviewRemBt;
    private TextView mWordNumTv;
    protected ImageView mPreviewImageView;
    private KeyboardListenRelativeLayout mRoot;
    private Context mContext;
    private boolean mWordsOverflow;
    private SHARE_MEDIA mPlatform;
    private int mKeyboardState;
    private boolean isPad = false;
    private Dialog mAtDialog;
    TextWatcher watcher = new TextWatcher(){

        public void afterTextChanged(Editable s) {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            ShareActivity.this.mWordsOverflow = ShareActivity.this.checkWordsOverflow();
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        this.R = ResContainer.get((Context)this);
        this.isPad = SocializeUtils.isFloatWindowStyle((Context)this);
        if (!this.isPad) {
            this.setTheme(this.R.style("Theme.UMDefault"));
        }
        super.onCreate(savedInstanceState);
        this.mContext = this;
        this.setContentView(this.R.layout("umeng_socialize_post_share"));
        WindowManager.LayoutParams lp = this.getWindow().getAttributes();
        lp.softInputMode = 16;
        if (this.isPad) {
            int[] windowSize = SocializeUtils.getFloatWindowSize((Context)this.mContext);
            lp.width = windowSize[0];
            lp.height = windowSize[1];
        }
        this.getWindow().setAttributes(lp);
        this.mRoot = (KeyboardListenRelativeLayout)this.findViewById(this.R.id("umeng_socialize_share_root"));
        this.mRoot.setOnKeyboardStateChangedListener(new KeyboardListenRelativeLayout.IOnKeyboardStateChangedListener(){

            @Override
            public void onKeyboardStateChanged(int state) {
                ShareActivity.this.mKeyboardState = state;
                Log.d((String)ShareActivity.TAG, (String)("onKeyboardStateChanged  now state is " + state));
            }
        });
        Bundle bundle = this.getIntent().getExtras();
        this.mPlatform = this.StringtoMedia(bundle.getString("media"));
        MAX_WORD_NUM = this.mPlatform == SHARE_MEDIA.RENREN ? 120 : 140;
        this.mTitle = bundle.getString("title");
        this.mText = bundle.getString("txt");
        this.mImage = bundle.getString("pic");
        this.initView();
    }

    private SHARE_MEDIA StringtoMedia(String media) {
        if (media.equals("TENCENT")) {
            return SHARE_MEDIA.TENCENT;
        }
        if (media.equals("RENREN")) {
            return SHARE_MEDIA.RENREN;
        }
        if (media.equals("DOUBAN")) {
            return SHARE_MEDIA.DOUBAN;
        }
        return SHARE_MEDIA.SINA;
    }

    protected void onResume() {
        this.mEditText.requestFocus();
        super.onResume();
    }

    private void initView() {
        TextView titleView = (TextView)this.findViewById(this.R.id("umeng_socialize_title_bar_middleTv"));
        titleView.setText((CharSequence)this.mTitle);
        this.mCloseBtn = (Button)this.findViewById(this.R.id("umeng_socialize_title_bar_leftBt"));
        this.mSendBtn = (Button)this.findViewById(this.R.id("umeng_socialize_title_bar_rightBt"));
        this.mCloseBtn.setOnClickListener((View.OnClickListener)this);
        this.mSendBtn.setOnClickListener((View.OnClickListener)this);
        this.mEditText = (EditText)this.findViewById(this.R.id("umeng_socialize_share_edittext"));
        if (!TextUtils.isEmpty((CharSequence)this.mText)) {
            this.mEditText.setText((CharSequence)this.mText);
            this.mEditText.setSelection(this.mText.length());
        }
        this.mEditText.addTextChangedListener(this.watcher);
        this.mWordNumTv = (TextView)this.findViewById(this.R.id("umeng_socialize_share_word_num"));
        this.mWordsOverflow = this.checkWordsOverflow();
        if (this.mImage != null) {
            this.findViewById(this.R.id("umeng_socialize_share_image")).setVisibility(0);
            this.mPreviewImageView = (ImageView)this.findViewById(this.R.id("umeng_socialize_share_previewImg"));
            this.mPreviewRemBt = this.findViewById(this.R.id("umeng_socialize_share_previewImg_remove"));
            this.mPreviewRemBt.setOnClickListener((View.OnClickListener)this);
            this.mPreviewImageView.setVisibility(0);
            if (this.mImage.equals("video")) {
                this.mPreviewImageView.setImageResource(ResContainer.getResourceId((Context)this.mContext, (String)"drawable", (String)"umeng_socialize_share_video"));
            } else if (this.mImage.equals("music")) {
                this.mPreviewImageView.setImageResource(ResContainer.getResourceId((Context)this.mContext, (String)"drawable", (String)"umeng_socialize_share_music"));
            } else {
                this.mPreviewImageView.setImageURI(Uri.fromFile((File)new File(this.mImage)));
            }
        }
    }

    private void onSend(View view) {
        String content = this.mEditText.getText().toString();
        if (TextUtils.isEmpty((CharSequence)content.trim())) {
            Toast.makeText((Context)this, (CharSequence)"\u8f93\u5165\u5185\u5bb9\u4e3a\u7a7a...", (int)0).show();
            return;
        }
        if (SocializeUtils.countContentLength((String)content) > MAX_WORD_NUM) {
            Toast.makeText((Context)this, (CharSequence)"\u8f93\u5165\u5185\u5bb9\u8d85\u8fc7140\u4e2a\u5b57.", (int)0).show();
            return;
        }
        if (this.mWordsOverflow) {
            Toast.makeText((Context)this.mContext, (CharSequence)"\u8d85\u51fa\u6700\u5927\u5b57\u6570\u9650\u5236....", (int)0).show();
            return;
        }
        Intent in = new Intent();
        Bundle bundle = new Bundle();
        bundle.putString("txt", content);
        bundle.putString("pic", this.mImage);
        in.putExtras(bundle);
        this.setResult(-1, in);
        this.safeClose();
    }

    public void onCancel(View view) {
        this.setResult(1000);
        this.safeClose();
    }

    private void onRemoveImage(View view) {
        this.mImage = null;
        this.findViewById(this.R.id("umeng_socialize_share_image")).setVisibility(8);
    }

    public void onClick(View view) {
        int id = view.getId();
        if (id == this.R.id("umeng_socialize_share_previewImg_remove")) {
            this.onRemoveImage(view);
        } else if (id == this.R.id("umeng_socialize_title_bar_rightBt")) {
            this.onSend(view);
        } else if (id == this.R.id("umeng_socialize_title_bar_leftBt")) {
            this.onCancel(view);
        }
    }

    private void setPreview(int resId, Bitmap bitmap) {
        try {
            this.mPreviewImageView.setImageBitmap(bitmap);
        }
        catch (Exception e) {
            this.mPreviewImageView.setImageResource(resId);
        }
        this.mPreviewImageView.setVisibility(0);
        this.mPreviewRemBt.setVisibility(0);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && event.getRepeatCount() == 0) {
            this.setResult(1000);
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void safeClose() {
        if (this.mKeyboardState == -3) {
            InputMethodManager imm = (InputMethodManager)this.getSystemService("input_method");
            imm.hideSoftInputFromWindow(this.getWindow().peekDecorView().getWindowToken(), 0);
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    ShareActivity.this.finish();
                }
            }, 500L);
        } else {
            this.finish();
        }
    }

    private boolean checkWordsOverflow() {
        int tmp = MAX_WORD_NUM - SocializeUtils.countContentLength((String)this.mEditText.getText().toString());
        Log.d((String)TAG, (String)("onTextChanged " + tmp + "   " + SocializeUtils.countContentLength((String)this.mEditText.getText().toString())));
        this.mWordNumTv.setText((CharSequence)("" + tmp));
        return tmp < 0;
    }

    protected void onStop() {
        super.onStop();
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (SocializeConstants.BACKKEY_COMPLETE_CLOSE && event.getKeyCode() == 4) {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    ShareActivity.this.finish();
                }
            }, 400L);
            return true;
        }
        return super.dispatchKeyEvent(event);
    }
}

