/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.handler;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.umeng.socialize.PlatformConfig;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.common.QueuedWork;
import com.umeng.socialize.handler.UMAPIShareHandler;
import com.umeng.socialize.media.TencentWBSharepreference;
import com.umeng.socialize.media.UMImage;
import com.umeng.socialize.media.UMVideo;
import com.umeng.socialize.media.UMusic;
import com.umeng.socialize.utils.Dummy;
import com.umeng.socialize.view.OauthDialog;
import java.io.File;
import java.util.Map;

public class TencentWBSsoHandler
extends UMAPIShareHandler {
    private static final String waiturl = "tenc2/main?uid";
    private PlatformConfig.TencentWeibo config;
    private Context context;
    private TencentWBSharepreference tencentWBSharepreference;

    public void onCreate(Context context, PlatformConfig.Platform p) {
        super.onCreate(context, p);
        this.context = context.getApplicationContext();
        this.tencentWBSharepreference = new TencentWBSharepreference(context, SHARE_MEDIA.TENCENT.toString());
    }

    public boolean isAuthorized() {
        return this.tencentWBSharepreference.isAuthorized();
    }

    public boolean isAuthorize() {
        return this.isAuthorized();
    }

    public String getUID() {
        return this.tencentWBSharepreference.getUID();
    }

    public SHARE_MEDIA getPlatform() {
        return SHARE_MEDIA.TENCENT;
    }

    public void authorizeCallBack(int requestCode, int resultCode, Intent data) {
    }

    public void authorize(UMAuthListener listener) {
        final UMAuthListener safelistener = (UMAuthListener)Dummy.get(UMAuthListener.class, (Object)listener);
        if (this.isAuthorize()) {
            int action = 0;
            Map<String, String> data = this.tencentWBSharepreference.getAuthData();
            safelistener.onComplete(SHARE_MEDIA.TENCENT, action, data);
        } else {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (TencentWBSsoHandler.this.mWeakAct.get() != null && !((Activity)TencentWBSsoHandler.this.mWeakAct.get()).isFinishing()) {
                        OauthDialog dialog = new OauthDialog((Activity)TencentWBSsoHandler.this.mWeakAct.get(), SHARE_MEDIA.TENCENT, (UMAuthListener)new AuthListenerWrapper(safelistener));
                        dialog.setWaitUrl(TencentWBSsoHandler.waiturl);
                        dialog.show();
                    }
                }
            });
        }
    }

    public int getRequestCode() {
        return 5662;
    }

    public void deleteAuth(UMAuthListener listener) {
        this.tencentWBSharepreference.delete();
        if (listener != null) {
            listener.onComplete(this.getConfig().getName(), 1, null);
        }
    }

    public boolean isSupportAuth() {
        return true;
    }

    public Bundle getEditable(ShareContent shareContent) {
        Bundle bundle = new Bundle();
        bundle.putString("media", SHARE_MEDIA.TENCENT.toString());
        bundle.putString("title", "\u5206\u4eab\u5230\u817e\u8baf\u5fae\u535a");
        if (TextUtils.isEmpty((CharSequence)shareContent.mTargetUrl)) {
            bundle.putString("txt", shareContent.mText);
        } else {
            bundle.putString("txt", shareContent.mText + shareContent.mTargetUrl);
        }
        if (shareContent.mMedia != null && shareContent.mMedia instanceof UMImage) {
            File file = ((UMImage)shareContent.mMedia).asFileImage();
            if (file != null) {
                bundle.putString("pic", file.getAbsolutePath());
            }
        } else if (shareContent.mMedia != null && shareContent.mMedia instanceof UMusic) {
            bundle.putString("pic", "music");
        } else if (shareContent.mMedia != null && shareContent.mMedia instanceof UMVideo) {
            bundle.putString("pic", "video");
        }
        bundle.putBoolean("at", true);
        bundle.putBoolean("location", true);
        return bundle;
    }

    public ShareContent getResult(ShareContent shareContent, Bundle bundle) {
        shareContent.mText = bundle.getString("txt");
        if (bundle.getString("pic") == null) {
            shareContent.mMedia = null;
        }
        return shareContent;
    }

    class AuthListenerWrapper
    implements UMAuthListener {
        private UMAuthListener mListener = null;

        AuthListenerWrapper(UMAuthListener listener) {
            this.mListener = listener;
        }

        public void onComplete(SHARE_MEDIA platform, int action, Map<String, String> data) {
            TencentWBSsoHandler.this.tencentWBSharepreference.setAuthData(data).commit();
            if (this.mListener != null) {
                this.mListener.onComplete(platform, action, data);
            }
        }

        public void onError(SHARE_MEDIA platform, int action, Throwable t) {
            if (this.mListener != null) {
                this.mListener.onError(platform, action, t);
            }
        }

        public void onCancel(SHARE_MEDIA platform, int action) {
            if (this.mListener != null) {
                this.mListener.onCancel(platform, action);
            }
        }
    }
}

