/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.share.sdk.openapi;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.util.Log;
import com.alipay.share.sdk.Constant;
import com.alipay.share.sdk.openapi.APMediaMessage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;

public class APImageObject
implements APMediaMessage.IMediaObject {
    private static final String TAG = "Alipay.SDK.ZFBImageObject";
    public byte[] imageData;
    public String imagePath;
    public String imageUrl;

    public APImageObject() {
    }

    public APImageObject(byte[] imageData) {
        this.imageData = imageData;
    }

    public APImageObject(Bitmap bitmap) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)byteArrayOutputStream);
            this.imageData = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    @Override
    public void serialize(Bundle bundle) {
        bundle.putByteArray(Constant.EXTRA_IMAGE_OBJECT_IMAGE_DATA, this.imageData);
        bundle.putString(Constant.EXTRA_IMAGE_OBJECT_IMAGE_PATH, this.imagePath);
        bundle.putString(Constant.EXTRA_IMAGE_OBJECT_IMAGE_URL, this.imageUrl);
    }

    @Override
    public void unserialize(Bundle bundle) {
        this.imageData = bundle.getByteArray(Constant.EXTRA_IMAGE_OBJECT_IMAGE_DATA);
        this.imagePath = bundle.getString(Constant.EXTRA_IMAGE_OBJECT_IMAGE_PATH);
        this.imageUrl = bundle.getString(Constant.EXTRA_IMAGE_OBJECT_IMAGE_URL);
    }

    @Override
    public int type() {
        return 14;
    }

    @Override
    public boolean checkArgs() {
        if (!(this.imageData != null && this.imageData.length != 0 || this.imagePath != null && this.imagePath.length() != 0 || this.imageUrl != null && this.imageUrl.length() != 0)) {
            Log.e((String)TAG, (String)"checkArgs fail, all arguments are null");
            return false;
        }
        if (this.imageData != null && this.imageData.length > 0xA00000) {
            Log.e((String)TAG, (String)"checkArgs fail, content is too large");
            return false;
        }
        if (this.imagePath != null && this.imagePath.length() > 10240) {
            Log.e((String)TAG, (String)"checkArgs fail, path is invalid");
            return false;
        }
        if (this.imagePath != null) {
            File imageFile;
            String path = this.imagePath;
            if ((this.imagePath != null && path.length() != 0 ? (!(imageFile = new File(path)).exists() ? 0 : (int)imageFile.length()) : 0) > 0xA00000) {
                Log.e((String)TAG, (String)"checkArgs fail, image content is too large");
                return false;
            }
        }
        if (this.imageUrl != null && this.imageUrl.length() > 10240) {
            Log.e((String)TAG, (String)"checkArgs fail, url is invalid");
            return false;
        }
        return true;
    }
}

