/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.statistic;

import android.app.ActivityManager;
import android.content.Context;
import com.sina.weibo.sdk.statistic.EventLog;
import com.sina.weibo.sdk.statistic.LogBuilder;
import com.sina.weibo.sdk.statistic.LogFileUtil;
import com.sina.weibo.sdk.statistic.LogReport;
import com.sina.weibo.sdk.statistic.LogType;
import com.sina.weibo.sdk.statistic.PageLog;
import com.sina.weibo.sdk.statistic.StatisticConfig;
import com.sina.weibo.sdk.statistic.WBAgentExecutor;
import com.sina.weibo.sdk.utils.LogUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

class WBAgentHandler {
    private static WBAgentHandler mInstance;
    private static List<PageLog> mActivePages;
    private static Map<String, PageLog> mPages;
    private static Timer mTimer;
    private static int MAX_CACHE_SIZE;

    static {
        MAX_CACHE_SIZE = 5;
    }

    public static synchronized WBAgentHandler getInstance() {
        if (mInstance == null) {
            mInstance = new WBAgentHandler();
        }
        return mInstance;
    }

    private WBAgentHandler() {
        mActivePages = new ArrayList<PageLog>();
        mPages = new HashMap<String, PageLog>();
        LogUtil.i("WBAgent", "init handler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPageStart(String pageName) {
        if (!StatisticConfig.ACTIVITY_DURATION_OPEN) {
            PageLog pageLog = new PageLog(pageName);
            pageLog.setType(LogType.FRAGMENT);
            Map<String, PageLog> map = mPages;
            synchronized (map) {
                mPages.put(pageName, pageLog);
            }
            LogUtil.d("WBAgent", String.valueOf(pageName) + ", " + pageLog.getStartTime() / 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPageEnd(String pageName) {
        if (!StatisticConfig.ACTIVITY_DURATION_OPEN) {
            if (mPages.containsKey(pageName)) {
                PageLog pageLog = mPages.get(pageName);
                pageLog.setDuration(System.currentTimeMillis() - pageLog.getStartTime());
                Object object = mActivePages;
                synchronized (object) {
                    mActivePages.add(pageLog);
                }
                object = mPages;
                synchronized (object) {
                    mPages.remove(pageName);
                }
                LogUtil.d("WBAgent", String.valueOf(pageName) + ", " + pageLog.getStartTime() / 1000L + ", " + pageLog.getDuration() / 1000L);
            } else {
                LogUtil.e("WBAgent", "please call onPageStart before onPageEnd");
            }
            if (mActivePages.size() >= MAX_CACHE_SIZE) {
                this.saveActivePages(mActivePages);
                mActivePages.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResume(Context context) {
        if (LogReport.getPackageName() == null) {
            LogReport.setPackageName(context.getPackageName());
        }
        if (mTimer == null) {
            mTimer = this.timerTask(context, 500L, StatisticConfig.getUploadInterval());
        }
        long curTime = System.currentTimeMillis();
        String pageName = context.getClass().getName();
        this.checkNewSession(context, curTime);
        if (StatisticConfig.ACTIVITY_DURATION_OPEN) {
            PageLog pageLog = new PageLog(pageName, curTime);
            pageLog.setType(LogType.ACTIVITY);
            Map<String, PageLog> map = mPages;
            synchronized (map) {
                mPages.put(pageName, pageLog);
            }
        }
        LogUtil.d("WBAgent", String.valueOf(pageName) + ", " + curTime / 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPause(Context context) {
        long curTime = System.currentTimeMillis();
        String pageName = context.getClass().getName();
        LogUtil.i("WBAgent", "update last page endtime:" + curTime / 1000L);
        PageLog.updateSession(context, null, 0L, curTime);
        if (StatisticConfig.ACTIVITY_DURATION_OPEN) {
            if (mPages.containsKey(pageName)) {
                PageLog pageLog = mPages.get(pageName);
                pageLog.setDuration(curTime - pageLog.getStartTime());
                Object object = mActivePages;
                synchronized (object) {
                    mActivePages.add(pageLog);
                }
                object = mPages;
                synchronized (object) {
                    mPages.remove(pageName);
                }
                LogUtil.d("WBAgent", String.valueOf(pageName) + ", " + pageLog.getStartTime() / 1000L + ", " + pageLog.getDuration() / 1000L);
            } else {
                LogUtil.e("WBAgent", "please call onResume before onPause");
            }
            if (mActivePages.size() >= MAX_CACHE_SIZE) {
                this.saveActivePages(mActivePages);
                mActivePages.clear();
            }
        }
        this.checkAppStatus(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(String pageName, String eventId, Map<String, String> extend) {
        EventLog eventLog = new EventLog(pageName, eventId, extend);
        eventLog.setType(LogType.EVENT);
        List<PageLog> list = mActivePages;
        synchronized (list) {
            mActivePages.add(eventLog);
        }
        if (extend == null) {
            LogUtil.d("WBAgent", "event--- page:" + pageName + " ,event name:" + eventId);
        } else {
            LogUtil.d("WBAgent", "event--- page:" + pageName + " ,event name:" + eventId + " ,extend:" + extend.toString());
        }
        if (mActivePages.size() >= MAX_CACHE_SIZE) {
            this.saveActivePages(mActivePages);
            mActivePages.clear();
        }
    }

    public void uploadAppLogs(final Context context) {
        long duration = System.currentTimeMillis() - LogReport.getTime(context);
        if (LogReport.getTime(context) > 0L && duration < 30000L) {
            this.timerTask(context, 30000L - duration, 0L);
        } else {
            WBAgentExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    LogReport.uploadAppLogs(context, WBAgentHandler.this.getLogsInMemory());
                }
            });
        }
    }

    public void onStop(Context context) {
        this.checkAppStatus(context);
    }

    private void checkAppStatus(Context context) {
        if (this.isBackground(context)) {
            this.saveActivePages(mActivePages);
            mActivePages.clear();
        }
    }

    private boolean isBackground(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List appProcesses = activityManager.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (!appProcess.processName.equals(context.getPackageName())) continue;
            if (appProcess.importance == 400) {
                LogUtil.i("WBAgent", "\u540e\u53f0:" + appProcess.processName);
                return true;
            }
            LogUtil.i("WBAgent", "\u524d\u53f0:" + appProcess.processName);
            return false;
        }
        return false;
    }

    public void onKillProcess() {
        LogUtil.i("WBAgent", "save applogs and close timer and shutdown thread executor");
        this.saveActivePages(mActivePages);
        mInstance = null;
        this.closeTimer();
        WBAgentExecutor.shutDownExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNewSession(Context context, long curTime) {
        if (PageLog.isNewSession(context, curTime)) {
            PageLog old_session = new PageLog(context);
            old_session.setType(LogType.SESSION_END);
            PageLog new_session = new PageLog(context, curTime);
            new_session.setType(LogType.SESSION_START);
            List<PageLog> list = mActivePages;
            synchronized (list) {
                if (old_session.getEndTime() > 0L) {
                    mActivePages.add(old_session);
                } else {
                    LogUtil.d("WBAgent", "is a new install");
                }
                mActivePages.add(new_session);
            }
            LogUtil.d("WBAgent", "last session--- starttime:" + old_session.getStartTime() + " ,endtime:" + old_session.getEndTime());
            LogUtil.d("WBAgent", "is a new session--- starttime:" + new_session.getStartTime());
        } else {
            LogUtil.i("WBAgent", "is not a new session");
        }
    }

    private synchronized void saveActivePages(List<PageLog> pages) {
        final String content = LogBuilder.getPageLogs(pages);
        WBAgentExecutor.execute(new Runnable(){

            @Override
            public void run() {
                LogFileUtil.writeToFile(LogFileUtil.getAppLogPath("app_logs"), content, true);
            }
        });
    }

    private synchronized String getLogsInMemory() {
        String memorylogs = "";
        if (mActivePages.size() > 0) {
            memorylogs = LogBuilder.getPageLogs(mActivePages);
            mActivePages.clear();
        }
        return memorylogs;
    }

    private Timer timerTask(final Context context, long delay, long peirod) {
        Timer timer = new Timer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                LogReport.uploadAppLogs(context, WBAgentHandler.this.getLogsInMemory());
            }
        };
        if (peirod == 0L) {
            timer.schedule(task, delay);
        } else {
            timer.schedule(task, delay, peirod);
        }
        return timer;
    }

    private void closeTimer() {
        if (mTimer != null) {
            mTimer.cancel();
        }
    }
}

