/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.component;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.sina.weibo.sdk.auth.WeiboAuthListener;
import com.sina.weibo.sdk.component.BrowserLauncher;
import com.sina.weibo.sdk.component.GameRequestParam;
import com.sina.weibo.sdk.component.WeiboSdkBrowser;
import com.sina.weibo.sdk.exception.WeiboException;
import com.sina.weibo.sdk.exception.WeiboHttpException;
import com.sina.weibo.sdk.net.HttpManager;
import com.sina.weibo.sdk.net.NetStateManager;
import com.sina.weibo.sdk.net.WeiboParameters;
import com.sina.weibo.sdk.utils.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;

public class GameManager {
    private static final String TAG = "GameManager";
    private static StringBuffer URL = new StringBuffer("https://api.weibo.com/2/proxy/darwin/graph/game/");
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final String HTTP_METHOD_POST = "POST";
    private static final String HTTP_METHOD_GET = "GET";
    private static final String BOUNDARY = HttpManager.getBoundry();
    private static final String MULTIPART_FORM_DATA = "multipart/form-data";
    private static String URL_ACHIEVEMENT_ADD_UPDATE = URL + "achievement/add.json";
    private static String URL_ACHIEVEMENT_RELATION_ADD_UPDATE = URL + "achievement/gain/add.json";
    private static String URL_ACHIEVEMENT_SCORE_ADD_UPDATE = URL + "score/add.json";
    private static String URL_ACHIEVEMENT_READ_PLAYER_SCORE = URL + "score/read_player.json";
    private static String URL_ACHIEVEMENT_READ_PLAYER_FRIENDS = URL + "score/read_player_friends.json";
    private static String URL_ACHIEVEMENT_USER_GAIN = URL + "achievement/user_gain.json";
    private static String INVITATION_URL = "http://widget.weibo.com/invitation/app.php?";
    private static String INVITATION_ONE_FRINED_URL = "http://widget.weibo.com/invitation/appinfo.php?";

    public static String AddOrUpdateGameAchievement(Context context, WeiboParameters params) {
        SimpleDateFormat myFmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        params.put("updated_time", myFmt.format(date));
        String time = (String)params.get("create_time");
        if (TextUtils.isEmpty((CharSequence)time)) {
            params.put("create_time", myFmt.format(date));
        }
        HttpResponse response = GameManager.requestHttpExecute(context, URL_ACHIEVEMENT_ADD_UPDATE, HTTP_METHOD_POST, params);
        String ans = HttpManager.readRsponse(response);
        LogUtil.d(TAG, "Response : " + ans);
        return ans;
    }

    public static String addOrUpdateGameAchievementRelation(Context context, WeiboParameters params) {
        SimpleDateFormat myFmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        params.put("updated_time", myFmt.format(date));
        String create_time = (String)params.get("create_time");
        if (TextUtils.isEmpty((CharSequence)create_time)) {
            params.put("create_time", myFmt.format(date));
        }
        HttpResponse response = GameManager.requestHttpExecute(context, URL_ACHIEVEMENT_RELATION_ADD_UPDATE, HTTP_METHOD_POST, params);
        String ans = HttpManager.readRsponse(response);
        LogUtil.d(TAG, "Response : " + ans);
        return ans;
    }

    public static String addOrUpdateAchievementScore(Context context, String access_token, String appKey, String game_id, String user_id, String score) {
        WeiboParameters params = new WeiboParameters("");
        if (!TextUtils.isEmpty((CharSequence)access_token)) {
            params.put("access_token", access_token);
        }
        if (!TextUtils.isEmpty((CharSequence)appKey)) {
            params.put("source", appKey);
        }
        if (!TextUtils.isEmpty((CharSequence)game_id)) {
            params.put("game_id", game_id);
        }
        if (!TextUtils.isEmpty((CharSequence)user_id)) {
            params.put("uid", user_id);
        }
        if (!TextUtils.isEmpty((CharSequence)score)) {
            params.put("score", score);
        }
        SimpleDateFormat myFmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        params.put("updated_time", myFmt.format(date));
        String create_time = (String)params.get("create_time");
        if (TextUtils.isEmpty((CharSequence)create_time)) {
            params.put("create_time", myFmt.format(date));
        }
        HttpResponse response = GameManager.requestHttpExecute(context, URL_ACHIEVEMENT_SCORE_ADD_UPDATE, HTTP_METHOD_POST, params);
        String ans = HttpManager.readRsponse(response);
        LogUtil.d(TAG, "Response : " + ans);
        return ans;
    }

    public static String readPlayerScoreInfo(Context context, String access_token, String appKey, String game_id, String user_id) {
        WeiboParameters params = new WeiboParameters("");
        if (!TextUtils.isEmpty((CharSequence)access_token)) {
            params.put("access_token", access_token);
        }
        if (!TextUtils.isEmpty((CharSequence)appKey)) {
            params.put("source", appKey);
        }
        if (!TextUtils.isEmpty((CharSequence)game_id)) {
            params.put("game_id", game_id);
        }
        if (!TextUtils.isEmpty((CharSequence)user_id)) {
            params.put("uid", user_id);
        }
        HttpResponse response = GameManager.requestHttpExecute(context, URL_ACHIEVEMENT_READ_PLAYER_SCORE, HTTP_METHOD_GET, params);
        String ans = HttpManager.readRsponse(response);
        LogUtil.d(TAG, "Response : " + ans);
        return ans;
    }

    public static String readPlayerFriendsScoreInfo(Context context, String access_token, String appKey, String game_id, String user_id) {
        WeiboParameters params = new WeiboParameters("");
        if (!TextUtils.isEmpty((CharSequence)access_token)) {
            params.put("access_token", access_token);
        }
        if (!TextUtils.isEmpty((CharSequence)appKey)) {
            params.put("source", appKey);
        }
        if (!TextUtils.isEmpty((CharSequence)game_id)) {
            params.put("game_id", game_id);
        }
        if (!TextUtils.isEmpty((CharSequence)user_id)) {
            params.put("uid", user_id);
        }
        Date date = new Date();
        Timestamp nousedate = new Timestamp(date.getTime());
        params.put("create_time", nousedate);
        HttpResponse response = GameManager.requestHttpExecute(context, URL_ACHIEVEMENT_READ_PLAYER_FRIENDS, HTTP_METHOD_GET, params);
        String ans = HttpManager.readRsponse(response);
        LogUtil.d(TAG, "Response : " + ans);
        return ans;
    }

    public static String readPlayerAchievementGain(Context context, String access_token, String appKey, String game_id, String user_id) {
        WeiboParameters params = new WeiboParameters("");
        if (!TextUtils.isEmpty((CharSequence)access_token)) {
            params.put("access_token", access_token);
        }
        if (!TextUtils.isEmpty((CharSequence)appKey)) {
            params.put("source", appKey);
        }
        if (!TextUtils.isEmpty((CharSequence)game_id)) {
            params.put("game_id", game_id);
        }
        if (!TextUtils.isEmpty((CharSequence)user_id)) {
            params.put("uid", user_id);
        }
        Date date = new Date();
        Timestamp nousedate = new Timestamp(date.getTime());
        params.put("create_time", nousedate);
        HttpResponse response = GameManager.requestHttpExecute(context, URL_ACHIEVEMENT_USER_GAIN, HTTP_METHOD_GET, params);
        String ans = HttpManager.readRsponse(response);
        LogUtil.d(TAG, "Response : " + ans);
        return ans;
    }

    public void invatationWeiboFriendsByList(Context context, String access_token, String appKey, String title, WeiboAuthListener listener) {
        WeiboParameters requestParams = new WeiboParameters(appKey);
        requestParams.put("access_token", access_token);
        requestParams.put("source", appKey);
        String UrlStr = String.valueOf(INVITATION_URL.toString()) + requestParams.encodeUrl();
        GameRequestParam reqParam = new GameRequestParam(context);
        reqParam.setAppKey(appKey);
        reqParam.setToken(access_token);
        reqParam.setLauncher(BrowserLauncher.GAME);
        reqParam.setUrl(UrlStr);
        reqParam.setAuthListener(listener);
        Intent intent = new Intent(context, WeiboSdkBrowser.class);
        Bundle data = reqParam.createRequestParamBundle();
        data.putString("key_specify_title", title);
        intent.putExtras(data);
        context.startActivity(intent);
    }

    public void invatationWeiboFriendsInOnePage(Context context, String access_token, String appKey, String title, WeiboAuthListener listener, ArrayList<String> userIdList) {
        StringBuffer userIds = new StringBuffer();
        if (userIdList != null) {
            int i = 0;
            while (i < userIdList.size()) {
                String user = userIdList.get(i);
                if (i == 0) {
                    userIds.append(user);
                } else {
                    userIds.append("," + user);
                }
                ++i;
            }
        }
        WeiboParameters requestParams = new WeiboParameters(appKey);
        requestParams.put("access_token", access_token);
        requestParams.put("source", appKey);
        String UrlStr = String.valueOf(INVITATION_ONE_FRINED_URL.toString()) + requestParams.encodeUrl() + "&uids=" + userIds.toString();
        GameRequestParam reqParam = new GameRequestParam(context);
        reqParam.setAppKey(appKey);
        reqParam.setToken(access_token);
        reqParam.setLauncher(BrowserLauncher.GAME);
        reqParam.setUrl(UrlStr);
        reqParam.setAuthListener(listener);
        Intent intent = new Intent(context, WeiboSdkBrowser.class);
        Bundle data = reqParam.createRequestParamBundle();
        data.putString("key_specify_title", title);
        intent.putExtras(data);
        context.startActivity(intent);
    }

    private static HttpResponse requestHttpExecute(Context context, String url, String method, WeiboParameters params) {
        HttpClient client = null;
        ByteArrayOutputStream baos = null;
        HttpResponse response = null;
        try {
            try {
                client = HttpManager.getNewHttpClient();
                client.getParams().setParameter("http.route.default-proxy", (Object)NetStateManager.getAPN());
                HttpDelete request = null;
                if (method.equals(HTTP_METHOD_GET)) {
                    url = String.valueOf(url) + "?" + params.encodeUrl();
                    request = new HttpGet(url);
                    LogUtil.d(TAG, "requestHttpExecute GET Url : " + url);
                } else if (method.equals(HTTP_METHOD_POST)) {
                    LogUtil.d(TAG, "requestHttpExecute POST Url : " + url);
                    HttpPost post = new HttpPost(url);
                    request = post;
                    baos = new ByteArrayOutputStream();
                    if (params.hasBinaryData()) {
                        post.setHeader("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
                        HttpManager.buildParams(baos, params);
                    } else {
                        Object value = params.get("content-type");
                        if (value != null && value instanceof String) {
                            params.remove("content-type");
                            post.setHeader("Content-Type", (String)value);
                        } else {
                            post.setHeader("Content-Type", "application/x-www-form-urlencoded");
                        }
                        String postParam = params.encodeUrl();
                        LogUtil.d(TAG, "requestHttpExecute POST postParam : " + postParam);
                        baos.write(postParam.getBytes(DEFAULT_CHARSET));
                    }
                    post.setEntity((HttpEntity)new ByteArrayEntity(baos.toByteArray()));
                } else if (method.equals("DELETE")) {
                    request = new HttpDelete(url);
                }
                response = client.execute(request);
                StatusLine status = response.getStatusLine();
                int statusCode = status.getStatusCode();
                if (statusCode != 200) {
                    String result = HttpManager.readRsponse(response);
                    throw new WeiboHttpException(result, statusCode);
                }
            }
            catch (IOException e) {
                throw new WeiboException(e);
            }
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
            HttpManager.shutdownHttpClient(client);
        }
        return response;
    }
}

