/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.api.share;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import com.sina.weibo.sdk.api.share.IWeiboDownloadListener;
import com.sina.weibo.sdk.utils.Utility;

public class WeiboDownloader {
    private static final String TITLE_CHINESS = "\u63d0\u793a";
    private static final String PROMPT_CHINESS = "\u672a\u5b89\u88c5\u5fae\u535a\u5ba2\u6237\u7aef\uff0c\u662f\u5426\u73b0\u5728\u53bb\u4e0b\u8f7d\uff1f";
    private static final String OK_CHINESS = "\u73b0\u5728\u4e0b\u8f7d";
    private static final String CANCEL_CHINESS = "\u4ee5\u540e\u518d\u8bf4";
    private static final String TITLE_ENGLISH = "Notice";
    private static final String PROMPT_ENGLISH = "Sina Weibo client is not installed, download now?";
    private static final String OK_ENGLISH = "Download Now";
    private static final String CANCEL_ENGLISH = "Download Later";

    public static Dialog createDownloadConfirmDialog(final Context context, final IWeiboDownloadListener listener) {
        String title = TITLE_CHINESS;
        String prompt = PROMPT_CHINESS;
        String ok = OK_CHINESS;
        String cancel = CANCEL_CHINESS;
        if (!Utility.isChineseLocale(context.getApplicationContext())) {
            title = TITLE_ENGLISH;
            prompt = PROMPT_ENGLISH;
            ok = OK_ENGLISH;
            cancel = CANCEL_ENGLISH;
        }
        AlertDialog dialog = new AlertDialog.Builder(context).setMessage((CharSequence)prompt).setTitle((CharSequence)title).setPositiveButton((CharSequence)ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                WeiboDownloader.downloadWeibo(context);
            }
        }).setNegativeButton((CharSequence)cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (listener != null) {
                    listener.onCancel();
                }
            }
        }).create();
        return dialog;
    }

    private static void downloadWeibo(Context context) {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.setFlags(0x10000000);
        Uri url = Uri.parse((String)"http://app.sina.cn/appdetail.php?appID=84560");
        intent.setData(url);
        try {
            context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

