/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.handler;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Parcelable;
import android.text.TextUtils;
import android.widget.Toast;
import com.facebook.AccessToken;
import com.facebook.CallbackManager;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.Profile;
import com.facebook.login.DefaultAudience;
import com.facebook.login.LoginBehavior;
import com.facebook.login.LoginManager;
import com.facebook.login.LoginResult;
import com.facebook.media.FacebookShareContent;
import com.facebook.share.Sharer;
import com.facebook.share.model.ShareLinkContent;
import com.facebook.share.model.SharePhoto;
import com.facebook.share.model.SharePhotoContent;
import com.facebook.share.model.ShareVideo;
import com.facebook.share.model.ShareVideoContent;
import com.facebook.share.widget.ShareDialog;
import com.umeng.socialize.Config;
import com.umeng.socialize.PlatformConfig;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.SocializeException;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.common.ResContainer;
import com.umeng.socialize.handler.UMSSOHandler;
import com.umeng.socialize.media.UMImage;
import com.umeng.socialize.net.PlatformTokenUploadReq;
import com.umeng.socialize.net.PlatformTokenUploadResponse;
import com.umeng.socialize.net.RestAPI;
import com.umeng.socialize.utils.DeviceConfig;
import com.umeng.socialize.utils.Dummy;
import com.umeng.socialize.utils.Log;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UMFacebookHandler
extends UMSSOHandler {
    private LoginManager loginManager;
    private DefaultAudience defaultAudience = DefaultAudience.FRIENDS;
    private LoginBehavior loginBehavior = LoginBehavior.SSO_WITH_FALLBACK;
    private List<String> permissions = Collections.emptyList();
    private PlatformConfig.Platform config;
    private CallbackManager mCallbackManager;
    private String PackageName = "com.facebook.katana";
    private String shareTarget = "com.facebook.composer.shareintent.ImplicitShareIntentHandlerDefaultAlias";
    private ShareDialog shareDialog;
    private FacebookShareContent shareContent;

    public void onCreate(Context context, PlatformConfig.Platform config) {
        super.onCreate(context, config);
        this.config = config;
        FacebookSdk.sdkInitialize(this.getContext());
        this.mCallbackManager = CallbackManager.Factory.create();
    }

    public boolean isAuthorize() {
        Log.e((String)"facebook can`t support isAuthorize");
        return false;
    }

    public void authorize(UMAuthListener listener) {
        final UMAuthListener safelistener = (UMAuthListener)Dummy.get(UMAuthListener.class, (Object)listener);
        LoginManager loginManager = this.getLoginManager();
        loginManager.registerCallback(this.mCallbackManager, new FacebookCallback<LoginResult>(){

            @Override
            public void onSuccess(LoginResult result) {
                Map value = UMFacebookHandler.this.parseAuthData(result);
                Log.d((String)"", (String)"\u6388\u6743FB\u6210\u529f : ");
                UMFacebookHandler.this.uploadAuthData(value);
                Profile.fetchProfileForCurrentAccessToken();
                safelistener.onComplete(SHARE_MEDIA.FACEBOOK, 0, value);
            }

            @Override
            public void onError(FacebookException error) {
                Log.d((String)"", (String)("\u6388\u6743FB\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f : " + error.getMessage()));
                safelistener.onError(SHARE_MEDIA.FACEBOOK, 0, (Throwable)error);
            }

            @Override
            public void onCancel() {
                Log.d((String)"", (String)"### \u53d6\u6d88FB\u6388\u6743");
                safelistener.onCancel(SHARE_MEDIA.FACEBOOK, 0);
            }
        });
        if (AccessToken.getCurrentAccessToken() != null) {
            loginManager.logOut();
        }
        if (this.mWeakAct.get() != null && !((Activity)this.mWeakAct.get()).isFinishing()) {
            loginManager.logInWithReadPermissions((Activity)this.mWeakAct.get(), Arrays.asList("public_profile", "user_friends"));
        }
    }

    private void parseUserInfoAndCallback(Profile profile, UMAuthListener listener) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("id", profile.getId());
        values.put("first_name", profile.getFirstName());
        values.put("last_name", profile.getLastName());
        values.put("linkUri", profile.getLinkUri().toString());
        values.put("profilePictureUri", profile.getProfilePictureUri(200, 200).toString());
        values.put("middle_name", profile.getMiddleName());
        values.put("name", profile.getName());
        listener.onComplete(SHARE_MEDIA.FACEBOOK, 2, values);
    }

    private void uploadAuthData(final Map<String, String> bundle) throws SocializeException {
        new Thread(new Runnable(){

            @Override
            public void run() {
                PlatformTokenUploadReq req = new PlatformTokenUploadReq(UMFacebookHandler.this.getContext());
                req.addStringParams("to", "facebook");
                req.addStringParams("usid", (String)bundle.get("uid"));
                req.addStringParams("access_token", (String)bundle.get("access_token"));
                req.addStringParams("refresh_token", (String)bundle.get("refresh_token"));
                req.addStringParams("expires_in", (String)bundle.get("expires_in"));
                PlatformTokenUploadResponse resp = RestAPI.uploadPlatformToken((PlatformTokenUploadReq)req);
                Log.e((String)("upload token resp = " + resp));
            }
        }).start();
    }

    public void getPlatformInfo(final UMAuthListener listener) {
        Profile profile = Profile.getCurrentProfile();
        if (profile != null) {
            this.parseUserInfoAndCallback(profile, listener);
            return;
        }
        UMAuthListener authListener = new UMAuthListener(){

            public void onComplete(SHARE_MEDIA platform, int action, Map<String, String> data) {
                String uid = data.get("uid");
                if (TextUtils.isEmpty((CharSequence)uid) || Profile.getCurrentProfile() == null) {
                    Log.d((String)"", (String)"###oauth failed...");
                } else {
                    UMFacebookHandler.this.parseUserInfoAndCallback(Profile.getCurrentProfile(), listener);
                }
            }

            public void onError(SHARE_MEDIA platform, int action, Throwable t) {
                Log.d((String)"", (String)("###oauth failed , message :" + t.getMessage()));
            }

            public void onCancel(SHARE_MEDIA platform, int action) {
            }
        };
        this.authorize(authListener);
    }

    public int getRequestCode() {
        return 64206;
    }

    public void deleteAuth(UMAuthListener listener) {
        this.loginManager = this.getLoginManager();
        this.loginManager.logOut();
        listener.onComplete(SHARE_MEDIA.FACEBOOK, 1, null);
    }

    private void doLogin() {
    }

    public boolean isSupportAuth() {
        return true;
    }

    public boolean isInstall() {
        return DeviceConfig.isAppInstalled((String)this.PackageName, (Context)this.getContext());
    }

    private boolean isInstall(PlatformConfig.Platform p) {
        if (!DeviceConfig.isAppInstalled((String)this.PackageName, (Context)this.getContext())) {
            StringBuilder msb = new StringBuilder();
            msb.append("\u8bf7\u5b89\u88c5");
            msb.append(ResContainer.getString((Context)this.getContext(), (String)p.getName().toSnsPlatform().mShowWord));
            msb.append("\u5ba2\u6237\u7aef");
            Log.v((String)msb.toString());
            if (Config.IsToastTip) {
                Toast.makeText((Context)this.getContext(), (CharSequence)msb, (int)1).show();
            }
            return false;
        }
        return true;
    }

    public boolean share(ShareContent content, UMShareListener listener) {
        UMShareListener safelistener = (UMShareListener)Dummy.get(UMShareListener.class, (Object)listener);
        if (!this.isInstall(this.getConfig())) {
            safelistener.onError(this.getConfig().getName(), new Throwable("no client"));
            return false;
        }
        this.shareContent = new FacebookShareContent(content);
        return this.shareTo(new FacebookShareContent(content), safelistener);
    }

    public boolean shareTo(FacebookShareContent shareContent, final UMShareListener listener) {
        block16: {
            block15: {
                if (Config.isIntentShareFB) break block15;
                switch (shareContent.getShare_Type()) {
                    case 3: {
                        Log.d((String)"share link", (String)"share link");
                        if (this.shareDialog == null && this.mWeakAct.get() != null && !((Activity)this.mWeakAct.get()).isFinishing()) {
                            this.shareDialog = new ShareDialog((Activity)this.mWeakAct.get());
                        }
                        ShareLinkContent shareLinkContent = shareContent.getImage() != null && shareContent.getImage().isUrlMedia() ? ((ShareLinkContent.Builder)new ShareLinkContent.Builder().setContentUrl(Uri.parse((String)shareContent.getTargeturl()))).setContentTitle(shareContent.getTitle()).setContentDescription(shareContent.getText()).setImageUrl(Uri.parse((String)shareContent.getImage().asUrlImage())).build() : ((ShareLinkContent.Builder)new ShareLinkContent.Builder().setContentUrl(Uri.parse((String)shareContent.getTargeturl()))).setContentTitle(shareContent.getTitle()).setContentDescription(shareContent.getText()).build();
                        this.shareDialog.registerCallback(this.mCallbackManager, new FacebookCallback<Sharer.Result>(){

                            @Override
                            public void onSuccess(Sharer.Result result) {
                                Log.d((String)"xxxxxx", (String)"share success");
                                listener.onResult(SHARE_MEDIA.FACEBOOK);
                            }

                            @Override
                            public void onCancel() {
                                Log.d((String)"xxxxxx", (String)"share cancel");
                                listener.onCancel(SHARE_MEDIA.FACEBOOK);
                            }

                            @Override
                            public void onError(FacebookException error) {
                                Log.d((String)"xxxxxx", (String)("share error=" + error.getMessage()));
                                listener.onError(SHARE_MEDIA.FACEBOOK, (Throwable)error);
                            }
                        });
                        this.shareDialog.show(shareLinkContent);
                        break;
                    }
                    case 1: {
                        Log.d((String)"fb", (String)"facebook share picture");
                        if (this.mWeakAct.get() != null && !((Activity)this.mWeakAct.get()).isFinishing()) {
                            ShareDialog shareDialog1 = new ShareDialog((Activity)this.mWeakAct.get());
                            SharePhoto sharePhoto = new SharePhoto.Builder().setBitmap(shareContent.getImage().asBitmap()).setCaption(shareContent.getText()).build();
                            SharePhotoContent sharePhotoContent = new SharePhotoContent.Builder().addPhoto(sharePhoto).build();
                            shareDialog1.registerCallback(this.mCallbackManager, new FacebookCallback<Sharer.Result>(){

                                @Override
                                public void onSuccess(Sharer.Result result) {
                                    Log.d((String)"xxxxxx", (String)("share success=" + result.getPostId()));
                                    listener.onResult(SHARE_MEDIA.FACEBOOK);
                                }

                                @Override
                                public void onCancel() {
                                    Log.d((String)"xxxxxx", (String)"share cancel");
                                    listener.onCancel(SHARE_MEDIA.FACEBOOK);
                                }

                                @Override
                                public void onError(FacebookException error) {
                                    Log.d((String)"xxxxxx", (String)("share error=" + error.getMessage()));
                                    listener.onError(SHARE_MEDIA.FACEBOOK, (Throwable)error);
                                }
                            });
                            shareDialog1.show(sharePhotoContent);
                            break;
                        }
                        break block16;
                    }
                    case 2: {
                        String localUri = Uri.fromFile((File)new File(shareContent.getVideo().toUrl())).toString();
                        if (localUri.startsWith("file://")) {
                            Log.d((String)"fb uri", (String)"uri is local uri");
                        } else {
                            Log.e((String)"fb uri", (String)"uri is not local uri, must pass in local uri");
                        }
                        ShareVideo shareVideo = new ShareVideo.Builder().setLocalUrl(Uri.fromFile((File)new File(shareContent.getVideo().toUrl()))).build();
                        ShareVideoContent shareVideoContent = new ShareVideoContent.Builder().setVideo(shareVideo).setContentTitle(shareContent.getTitle()).setContentDescription(shareContent.getText()).build();
                        if (this.mWeakAct.get() != null && !((Activity)this.mWeakAct.get()).isFinishing()) {
                            this.shareDialog = new ShareDialog((Activity)this.mWeakAct.get());
                            this.shareDialog.registerCallback(this.mCallbackManager, new FacebookCallback<Sharer.Result>(){

                                @Override
                                public void onSuccess(Sharer.Result result) {
                                    Log.d((String)"xxxxxx", (String)"share success");
                                    listener.onResult(SHARE_MEDIA.FACEBOOK);
                                }

                                @Override
                                public void onCancel() {
                                    Log.d((String)"xxxxxx", (String)"share cancel");
                                    listener.onCancel(SHARE_MEDIA.FACEBOOK);
                                }

                                @Override
                                public void onError(FacebookException error) {
                                    Log.d((String)"facebook", (String)("share video:" + error.getMessage()));
                                    listener.onError(SHARE_MEDIA.FACEBOOK, new Throwable(error.getMessage()));
                                }
                            });
                            com.facebook.share.model.ShareContent content = shareContent.getContent();
                            if (content != null && ShareDialog.canShow(content.getClass())) {
                                this.shareDialog.show(shareVideoContent);
                                break;
                            }
                            Log.e((String)"", (String)"###\u5206\u4eab\u5931\u8d25\uff0c\u5177\u4f53\u53c2\u8003Log\u8ddf\u7ebf\u4e0a\u6587\u6863FB\u652f\u6301\u7684\u5206\u4eab\u7c7b\u578b...");
                            break;
                        }
                        break block16;
                    }
                    default: {
                        listener.onError(SHARE_MEDIA.FACEBOOK, new Throwable("\u5206\u4eab\u7c7b\u578b\u9519\u8bef\uff0cfacebook\u53ea\u652f\u6301\u56fe\u7247 \u94fe\u63a5\uff0c\u89c6\u9891"));
                        break;
                    }
                }
                break block16;
            }
            Intent shareIntent = new Intent("android.intent.action.SEND");
            if (shareContent.getImage() != null) {
                shareIntent.setType("image/*");
                shareIntent.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.fromFile((File)shareContent.getImage().asFileImage()));
            } else if (shareContent.getVideo() != null) {
                shareIntent.setType("video/*");
                shareIntent.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.fromFile((File)new File(shareContent.getVideo().toUrl())));
            }
            PackageManager pm = this.getContext().getPackageManager();
            List activityList = pm.queryIntentActivities(shareIntent, 0);
            for (ResolveInfo app : activityList) {
                if (!app.activityInfo.name.contains("facebook")) continue;
                ActivityInfo activity1 = app.activityInfo;
                ComponentName name = new ComponentName(activity1.applicationInfo.packageName, activity1.name);
                shareIntent.addCategory("android.intent.category.LAUNCHER");
                shareIntent.setFlags(0x10200000);
                shareIntent.setComponent(name);
                if (this.mWeakAct.get() == null || ((Activity)this.mWeakAct.get()).isFinishing()) break;
                ((Activity)this.mWeakAct.get()).startActivity(shareIntent);
                break;
            }
        }
        return true;
    }

    public boolean isClientInstalled() {
        return DeviceConfig.isAppInstalled((String)"com.facebook.katana", (Context)this.getContext());
    }

    private Map<String, String> parseAuthData(LoginResult result) {
        HashMap<String, String> map = new HashMap<String, String>();
        AccessToken accessToken = result.getAccessToken();
        if (accessToken == null) {
            return map;
        }
        map.put("uid", accessToken.getUserId());
        map.put("access_token", accessToken.getToken());
        String expireIn = String.valueOf(accessToken.getExpires().getTime() - System.currentTimeMillis());
        map.put("expires_in", expireIn);
        return map;
    }

    LoginManager getLoginManager() {
        if (this.loginManager == null) {
            this.loginManager = LoginManager.getInstance();
        }
        return this.loginManager;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.mCallbackManager.onActivityResult(requestCode, resultCode, data);
    }

    private static Intent getMsgIntent(Context context, String shareContent, UMImage img) {
        Intent sendIntent = new Intent("android.intent.action.SEND");
        sendIntent.setType("image/*;text/plain");
        if (!TextUtils.isEmpty((CharSequence)shareContent)) {
            sendIntent.putExtra("android.intent.extra.TEXT", shareContent);
            sendIntent.putExtra("android.intent.extra.SUBJECT", shareContent);
        }
        if (img != null) {
            sendIntent.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.fromFile((File)img.asFileImage()));
        }
        return sendIntent;
    }
}

