/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.facebook.share.model.ShareContent;
import com.facebook.share.model.ShareModel;
import com.facebook.share.model.SharePhoto;
import com.facebook.share.model.ShareVideo;

public final class ShareVideoContent
extends ShareContent<ShareVideoContent, Builder>
implements ShareModel {
    private final String contentDescription;
    private final String contentTitle;
    private final SharePhoto previewPhoto;
    private final ShareVideo video;
    public static final Parcelable.Creator<ShareVideoContent> CREATOR = new Parcelable.Creator<ShareVideoContent>(){

        public ShareVideoContent createFromParcel(Parcel in) {
            return new ShareVideoContent(in);
        }

        public ShareVideoContent[] newArray(int size) {
            return new ShareVideoContent[size];
        }
    };

    private ShareVideoContent(Builder builder) {
        super(builder);
        this.contentDescription = builder.contentDescription;
        this.contentTitle = builder.contentTitle;
        this.previewPhoto = builder.previewPhoto;
        this.video = builder.video;
    }

    ShareVideoContent(Parcel in) {
        super(in);
        this.contentDescription = in.readString();
        this.contentTitle = in.readString();
        SharePhoto.Builder previewPhotoBuilder = new SharePhoto.Builder().readFrom(in);
        this.previewPhoto = previewPhotoBuilder.getImageUrl() != null || previewPhotoBuilder.getBitmap() != null ? previewPhotoBuilder.build() : null;
        this.video = new ShareVideo.Builder().readFrom(in).build();
    }

    @Nullable
    public String getContentDescription() {
        return this.contentDescription;
    }

    @Nullable
    public String getContentTitle() {
        return this.contentTitle;
    }

    @Nullable
    public SharePhoto getPreviewPhoto() {
        return this.previewPhoto;
    }

    @Nullable
    public ShareVideo getVideo() {
        return this.video;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        super.writeToParcel(out, flags);
        out.writeString(this.contentDescription);
        out.writeString(this.contentTitle);
        out.writeParcelable((Parcelable)this.previewPhoto, 0);
        out.writeParcelable((Parcelable)this.video, 0);
    }

    public static final class Builder
    extends ShareContent.Builder<ShareVideoContent, Builder> {
        private String contentDescription;
        private String contentTitle;
        private SharePhoto previewPhoto;
        private ShareVideo video;

        public Builder setContentDescription(@Nullable String contentDescription) {
            this.contentDescription = contentDescription;
            return this;
        }

        public Builder setContentTitle(@Nullable String contentTitle) {
            this.contentTitle = contentTitle;
            return this;
        }

        public Builder setPreviewPhoto(@Nullable SharePhoto previewPhoto) {
            this.previewPhoto = previewPhoto == null ? null : new SharePhoto.Builder().readFrom(previewPhoto).build();
            return this;
        }

        public Builder setVideo(@Nullable ShareVideo video) {
            if (video == null) {
                return this;
            }
            this.video = new ShareVideo.Builder().readFrom(video).build();
            return this;
        }

        @Override
        public ShareVideoContent build() {
            return new ShareVideoContent(this);
        }

        @Override
        public Builder readFrom(ShareVideoContent model) {
            if (model == null) {
                return this;
            }
            return ((Builder)super.readFrom(model)).setContentDescription(model.getContentDescription()).setContentTitle(model.getContentTitle()).setPreviewPhoto(model.getPreviewPhoto()).setVideo(model.getVideo());
        }

        @Override
        public Builder readFrom(Parcel parcel) {
            return this.readFrom((ShareVideoContent)parcel.readParcelable(ShareVideoContent.class.getClassLoader()));
        }
    }
}

