/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.internal;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.util.Pair;
import com.facebook.CallbackManager;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookGraphResponseException;
import com.facebook.FacebookOperationCanceledException;
import com.facebook.FacebookSdk;
import com.facebook.GraphResponse;
import com.facebook.internal.AppCall;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.NativeAppCallAttachmentStore;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.Utility;
import com.facebook.share.Sharer;
import com.facebook.share.internal.OpenGraphJSONUtility;
import com.facebook.share.internal.ResultProcessor;
import com.facebook.share.model.ShareOpenGraphAction;
import com.facebook.share.model.ShareOpenGraphContent;
import com.facebook.share.model.SharePhoto;
import com.facebook.share.model.SharePhotoContent;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ShareInternalUtility {
    private static final String OBJECT_PARAM = "object";
    private static final String MY_PHOTOS = "me/photos";
    private static final String MY_FEED = "me/feed";
    private static final String MY_STAGING_RESOURCES = "me/staging_resources";
    private static final String MY_OBJECTS_FORMAT = "me/objects/%s";
    private static final String MY_ACTION_FORMAT = "me/%s";
    private static final String PICTURE_PARAM = "picture";
    private static final String CAPTION_PARAM = "caption";
    private static final String STAGING_PARAM = "file";

    public static void invokeCallbackWithError(FacebookCallback<Sharer.Result> callback, String error) {
        ShareInternalUtility.invokeOnErrorCallback(callback, error);
    }

    public static String getNativeDialogCompletionGesture(Bundle result) {
        if (result.containsKey("completionGesture")) {
            return result.getString("completionGesture");
        }
        return result.getString("com.facebook.platform.extra.COMPLETION_GESTURE");
    }

    public static String getShareDialogPostId(Bundle result) {
        if (result.containsKey("postId")) {
            return result.getString("postId");
        }
        if (result.containsKey("com.facebook.platform.extra.POST_ID")) {
            return result.getString("com.facebook.platform.extra.POST_ID");
        }
        return result.getString("post_id");
    }

    public static boolean handleActivityResult(int requestCode, int resultCode, Intent data, ResultProcessor resultProcessor) {
        AppCall appCall = ShareInternalUtility.getAppCallFromActivityResult(requestCode, resultCode, data);
        if (appCall == null) {
            return false;
        }
        NativeAppCallAttachmentStore.cleanupAttachmentsForCall(appCall.getCallId());
        if (resultProcessor == null) {
            return true;
        }
        FacebookException exception = NativeProtocol.getExceptionFromErrorData(NativeProtocol.getErrorDataFromResultIntent(data));
        if (exception != null) {
            if (exception instanceof FacebookOperationCanceledException) {
                resultProcessor.onCancel(appCall);
            } else {
                resultProcessor.onError(appCall, exception);
            }
        } else {
            Bundle results = NativeProtocol.getSuccessResultsFromIntent(data);
            resultProcessor.onSuccess(appCall, results);
        }
        return true;
    }

    public static ResultProcessor getShareResultProcessor(final FacebookCallback<Sharer.Result> callback) {
        return new ResultProcessor(callback){

            @Override
            public void onSuccess(AppCall appCall, Bundle results) {
                if (results != null) {
                    String gesture = ShareInternalUtility.getNativeDialogCompletionGesture(results);
                    if (gesture == null || "post".equalsIgnoreCase(gesture)) {
                        String postId = ShareInternalUtility.getShareDialogPostId(results);
                        ShareInternalUtility.invokeOnSuccessCallback(callback, postId);
                    } else if ("cancel".equalsIgnoreCase(gesture)) {
                        ShareInternalUtility.invokeOnCancelCallback(callback);
                    } else {
                        ShareInternalUtility.invokeOnErrorCallback((FacebookCallback<Sharer.Result>)callback, new FacebookException("UnknownError"));
                    }
                }
            }

            @Override
            public void onCancel(AppCall appCall) {
                ShareInternalUtility.invokeOnCancelCallback(callback);
            }

            @Override
            public void onError(AppCall appCall, FacebookException error) {
                ShareInternalUtility.invokeOnErrorCallback((FacebookCallback<Sharer.Result>)callback, error);
            }
        };
    }

    private static AppCall getAppCallFromActivityResult(int requestCode, int resultCode, Intent data) {
        UUID callId = NativeProtocol.getCallIdFromIntent(data);
        if (callId == null) {
            return null;
        }
        return AppCall.finishPendingCall(callId, requestCode);
    }

    public static void registerStaticShareCallback(final int requestCode) {
        CallbackManagerImpl.registerStaticCallback(requestCode, new CallbackManagerImpl.Callback(){

            @Override
            public boolean onActivityResult(int resultCode, Intent data) {
                return ShareInternalUtility.handleActivityResult(requestCode, resultCode, data, ShareInternalUtility.getShareResultProcessor(null));
            }
        });
    }

    public static void registerSharerCallback(final int requestCode, CallbackManager callbackManager, final FacebookCallback<Sharer.Result> callback) {
        if (!(callbackManager instanceof CallbackManagerImpl)) {
            throw new FacebookException("Unexpected CallbackManager, please use the provided Factory.");
        }
        ((CallbackManagerImpl)callbackManager).registerCallback(requestCode, new CallbackManagerImpl.Callback(){

            @Override
            public boolean onActivityResult(int resultCode, Intent data) {
                return ShareInternalUtility.handleActivityResult(requestCode, resultCode, data, ShareInternalUtility.getShareResultProcessor(callback));
            }
        });
    }

    public static List<String> getPhotoUrls(SharePhotoContent photoContent, final UUID appCallId) {
        List<SharePhoto> photos;
        if (photoContent == null || (photos = photoContent.getPhotos()) == null) {
            return null;
        }
        List<NativeAppCallAttachmentStore.Attachment> attachments = Utility.map(photos, new Utility.Mapper<SharePhoto, NativeAppCallAttachmentStore.Attachment>(){

            @Override
            public NativeAppCallAttachmentStore.Attachment apply(SharePhoto item) {
                return ShareInternalUtility.getAttachment(appCallId, item);
            }
        });
        List<String> attachmentUrls = Utility.map(attachments, new Utility.Mapper<NativeAppCallAttachmentStore.Attachment, String>(){

            @Override
            public String apply(NativeAppCallAttachmentStore.Attachment item) {
                return item.getAttachmentUrl();
            }
        });
        NativeAppCallAttachmentStore.addAttachments(attachments);
        return attachmentUrls;
    }

    public static JSONObject toJSONObjectForCall(final UUID callId, ShareOpenGraphAction action) throws JSONException {
        final ArrayList<NativeAppCallAttachmentStore.Attachment> attachments = new ArrayList<NativeAppCallAttachmentStore.Attachment>();
        JSONObject actionJSON = OpenGraphJSONUtility.toJSONObject(action, new OpenGraphJSONUtility.PhotoJSONProcessor(){

            @Override
            public JSONObject toJSONObject(SharePhoto photo) {
                NativeAppCallAttachmentStore.Attachment attachment = ShareInternalUtility.getAttachment(callId, photo);
                if (attachment == null) {
                    return null;
                }
                attachments.add(attachment);
                JSONObject photoJSONObject = new JSONObject();
                try {
                    photoJSONObject.put("url", (Object)attachment.getAttachmentUrl());
                    if (photo.getUserGenerated()) {
                        photoJSONObject.put("user_generated", true);
                    }
                }
                catch (JSONException e) {
                    throw new FacebookException("Unable to attach images", e);
                }
                return photoJSONObject;
            }
        });
        NativeAppCallAttachmentStore.addAttachments(attachments);
        return actionJSON;
    }

    public static JSONObject toJSONObjectForWeb(ShareOpenGraphContent shareOpenGraphContent) throws JSONException {
        ShareOpenGraphAction action = shareOpenGraphContent.getAction();
        return OpenGraphJSONUtility.toJSONObject(action, new OpenGraphJSONUtility.PhotoJSONProcessor(){

            @Override
            public JSONObject toJSONObject(SharePhoto photo) {
                Uri photoUri = photo.getImageUrl();
                JSONObject photoJSONObject = new JSONObject();
                try {
                    photoJSONObject.put("url", (Object)photoUri.toString());
                }
                catch (JSONException e) {
                    throw new FacebookException("Unable to attach images", e);
                }
                return photoJSONObject;
            }
        });
    }

    public static JSONArray removeNamespacesFromOGJsonArray(JSONArray jsonArray, boolean requireNamespace) throws JSONException {
        JSONArray newArray = new JSONArray();
        for (int i = 0; i < jsonArray.length(); ++i) {
            Object value = jsonArray.get(i);
            if (value instanceof JSONArray) {
                value = ShareInternalUtility.removeNamespacesFromOGJsonArray((JSONArray)value, requireNamespace);
            } else if (value instanceof JSONObject) {
                value = ShareInternalUtility.removeNamespacesFromOGJsonObject((JSONObject)value, requireNamespace);
            }
            newArray.put(value);
        }
        return newArray;
    }

    public static JSONObject removeNamespacesFromOGJsonObject(JSONObject jsonObject, boolean requireNamespace) {
        if (jsonObject == null) {
            return null;
        }
        try {
            JSONObject newJsonObject = new JSONObject();
            JSONObject data = new JSONObject();
            JSONArray names = jsonObject.names();
            for (int i = 0; i < names.length(); ++i) {
                String key = names.getString(i);
                Object value = null;
                value = jsonObject.get(key);
                if (value instanceof JSONObject) {
                    value = ShareInternalUtility.removeNamespacesFromOGJsonObject((JSONObject)value, true);
                } else if (value instanceof JSONArray) {
                    value = ShareInternalUtility.removeNamespacesFromOGJsonArray((JSONArray)value, true);
                }
                Pair<String, String> fieldNameAndNamespace = ShareInternalUtility.getFieldNameAndNamespaceFromFullName(key);
                String namespace = (String)fieldNameAndNamespace.first;
                String fieldName = (String)fieldNameAndNamespace.second;
                if (requireNamespace) {
                    if (namespace != null && namespace.equals("fbsdk")) {
                        newJsonObject.put(key, value);
                        continue;
                    }
                    if (namespace == null || namespace.equals("og")) {
                        newJsonObject.put(fieldName, value);
                        continue;
                    }
                    data.put(fieldName, value);
                    continue;
                }
                if (namespace != null && namespace.equals("fb")) {
                    newJsonObject.put(key, value);
                    continue;
                }
                newJsonObject.put(fieldName, value);
            }
            if (data.length() > 0) {
                newJsonObject.put("data", (Object)data);
            }
            return newJsonObject;
        }
        catch (JSONException e) {
            throw new FacebookException("Failed to create json object from share content");
        }
    }

    public static Pair<String, String> getFieldNameAndNamespaceFromFullName(String fullName) {
        String fieldName;
        String namespace = null;
        int index = fullName.indexOf(58);
        if (index != -1 && fullName.length() > index + 1) {
            namespace = fullName.substring(0, index);
            fieldName = fullName.substring(index + 1);
        } else {
            fieldName = fullName;
        }
        return new Pair(namespace, (Object)fieldName);
    }

    private ShareInternalUtility() {
    }

    private static NativeAppCallAttachmentStore.Attachment getAttachment(UUID callId, SharePhoto photo) {
        Bitmap bitmap = photo.getBitmap();
        Uri photoUri = photo.getImageUrl();
        NativeAppCallAttachmentStore.Attachment attachment = null;
        if (bitmap != null) {
            attachment = NativeAppCallAttachmentStore.createAttachment(callId, bitmap);
        } else if (photoUri != null) {
            attachment = NativeAppCallAttachmentStore.createAttachment(callId, photoUri);
        }
        return attachment;
    }

    static void invokeOnCancelCallback(FacebookCallback<Sharer.Result> callback) {
        ShareInternalUtility.logShareResult("cancelled", null);
        if (callback != null) {
            callback.onCancel();
        }
    }

    static void invokeOnSuccessCallback(FacebookCallback<Sharer.Result> callback, String postId) {
        ShareInternalUtility.logShareResult("succeeded", null);
        if (callback != null) {
            callback.onSuccess(new Sharer.Result(postId));
        }
    }

    static void invokeOnErrorCallback(FacebookCallback<Sharer.Result> callback, GraphResponse response, String message) {
        ShareInternalUtility.logShareResult("error", message);
        if (callback != null) {
            callback.onError(new FacebookGraphResponseException(response, message));
        }
    }

    static void invokeOnErrorCallback(FacebookCallback<Sharer.Result> callback, String message) {
        ShareInternalUtility.logShareResult("error", message);
        if (callback != null) {
            callback.onError(new FacebookException(message));
        }
    }

    static void invokeOnErrorCallback(FacebookCallback<Sharer.Result> callback, FacebookException ex) {
        ShareInternalUtility.logShareResult("error", ex.getMessage());
        if (callback != null) {
            callback.onError(ex);
        }
    }

    private static void logShareResult(String shareOutcome, String errorMessage) {
        Context context = FacebookSdk.getApplicationContext();
        Bundle parameters = new Bundle();
        parameters.putString("fb_share_dialog_outcome", shareOutcome);
        if (errorMessage != null) {
            parameters.putString("error_message", errorMessage);
        }
    }
}

