/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.log.crash;

import android.os.Environment;
import android.text.TextUtils;
import com.umeng.socialize.utils.ContextUtil;
import com.umeng.socialize.utils.Log;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

class LogWriter {
    private final String tag = this.getClass().getSimpleName();
    private static final String DIR_NAME = "crash";

    LogWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void writeErrorLog(String log) {
        if (TextUtils.isEmpty((CharSequence)log)) {
            return;
        }
        File dir = this.getCrashLogDir();
        if (dir == null) {
            return;
        }
        String fileName = this.getCrashLogName();
        String tempFileName = fileName + ".tmp";
        File file = new File(dir, tempFileName);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file, true);
            fileOutputStream.write(log.getBytes());
            this.safeClose(fileOutputStream);
            boolean result = this.renameFile(file, fileName);
            if (!result) {
                this.deleteFile(file);
            }
        }
        catch (FileNotFoundException e) {
            Log.e((String)this.tag, (String)"write exception error");
            e.printStackTrace();
            this.deleteFile(file);
            this.safeClose(fileOutputStream);
            boolean result = this.renameFile(file, fileName);
            if (!result) {
                this.deleteFile(file);
            }
        }
        catch (IOException e2) {
            Log.e((String)this.tag, (String)"write exception error");
            e2.printStackTrace();
            this.deleteFile(file);
            this.safeClose(fileOutputStream);
            boolean result = this.renameFile(file, fileName);
            if (!result) {
                this.deleteFile(file);
            }
            {
                catch (Throwable throwable) {
                    this.safeClose(fileOutputStream);
                    boolean result2 = this.renameFile(file, fileName);
                    if (!result2) {
                        this.deleteFile(file);
                    }
                    throw throwable;
                }
            }
        }
    }

    private boolean renameFile(File originFile, String newFileName) {
        try {
            File file = new File(originFile.getParent(), newFileName);
            return originFile.renameTo(file);
        }
        catch (Exception e) {
            Log.e((String)this.tag, (String)"rename file error");
            e.printStackTrace();
            return false;
        }
    }

    private void deleteFile(File file) {
        try {
            if (file != null) {
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void safeClose(Closeable io) {
        try {
            if (io != null) {
                io.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private File getCrashLogDir() {
        String crashDir;
        if (ContextUtil.getContext() == null) {
            return null;
        }
        if (!this.isExternalStorageWritable()) {
            return null;
        }
        File appExternalFile = ContextUtil.getContext().getExternalFilesDir(null);
        if (appExternalFile != null) {
            crashDir = appExternalFile.getPath();
        } else {
            String packageName = ContextUtil.getContext().getPackageName();
            crashDir = Environment.getExternalStorageDirectory() + File.separator + "Android" + File.separator + "data" + File.separator + packageName + File.separator + "files";
        }
        String crashLogPath = crashDir + File.separator + DIR_NAME;
        File file = new File(crashLogPath);
        file.mkdirs();
        if (!file.exists()) {
            Log.e((String)this.tag, (String)"Directory not created");
            return null;
        }
        return file;
    }

    private boolean isExternalStorageWritable() {
        String state = Environment.getExternalStorageState();
        if ("mounted".equals(state)) {
            return true;
        }
        Log.e((String)this.tag, (String)"SD card not mounted");
        return false;
    }

    private String getCrashLogName() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        String time = dateFormat.format(new Date());
        String logName = "crash-" + time + "-" + System.currentTimeMillis() + ".log";
        return logName;
    }
}

