/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.log.crash;

import com.umeng.socialize.log.crash.ExceptionParser;
import com.umeng.socialize.log.crash.LogWriter;
import com.umeng.socialize.utils.Log;

public class ExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final String tag = this.getClass().getSimpleName();
    private static final String TARGET_LOG_PATTERN = "com.umeng";
    private Thread.UncaughtExceptionHandler mExceptionHandler;
    private LogWriter mLogWriter;
    private ExceptionParser mParser;

    public static final ExceptionHandler getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private ExceptionHandler() {
        if (Thread.getDefaultUncaughtExceptionHandler() == this) {
            return;
        }
        this.mParser = new ExceptionParser();
        this.mLogWriter = new LogWriter();
        this.mExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        long start = System.currentTimeMillis();
        try {
            String exception = this.mParser.parseException(ex);
            if (exception.contains(TARGET_LOG_PATTERN)) {
                this.mLogWriter.writeErrorLog(exception);
            } else {
                Log.e((String)this.tag, (String)"no target log,don't write exception to file");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)this.tag, (String)"handle exception error");
        }
        Log.e((String)this.tag, (String)("write exception log spend " + (System.currentTimeMillis() - start) + " ms"));
        if (this.mExceptionHandler != null && this.mExceptionHandler != Thread.getDefaultUncaughtExceptionHandler()) {
            this.mExceptionHandler.uncaughtException(thread, ex);
        }
    }

    private static class SingletonHolder {
        private static final ExceptionHandler INSTANCE = new ExceptionHandler();

        private SingletonHolder() {
        }
    }
}

