/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.controller;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Pair;
import com.umeng.socialize.Config;
import com.umeng.socialize.PlatformConfig;
import com.umeng.socialize.ShareAction;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.analytics.SocialAnalytics;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.handler.UMMoreHandler;
import com.umeng.socialize.handler.UMSSOHandler;
import com.umeng.socialize.media.UMediaObject;
import com.umeng.socialize.net.RestAPI;
import com.umeng.socialize.net.UrlRequest;
import com.umeng.socialize.net.UrlResponse;
import com.umeng.socialize.utils.ContextUtil;
import com.umeng.socialize.utils.Log;
import com.umeng.socialize.view.UMFriendListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SocialRouter {
    private int counter = 0;
    private final Map<SHARE_MEDIA, UMSSOHandler> platformHandlers = new HashMap<SHARE_MEDIA, UMSSOHandler>();
    private final List<Pair<SHARE_MEDIA, String>> supportedPlatform;
    private ParamsGuard guard;
    private Context mContext;

    public void setmContext(Context mContext) {
        this.mContext = mContext;
    }

    public SocialRouter(Context context) {
        List<Pair<SHARE_MEDIA, String>> sp = this.supportedPlatform = new ArrayList<Pair<SHARE_MEDIA, String>>();
        String pkg = "com.umeng.socialize.handler.";
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.LAIWANG, (Object)"com.umeng.socialize.handler.UMLWHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.LAIWANG_DYNAMIC, (Object)"com.umeng.socialize.handler.UMLWHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.SINA, (Object)"com.umeng.socialize.handler.UmengSinaHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.PINTEREST, (Object)"com.umeng.socialize.handler.UMPinterestHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.QZONE, (Object)"com.umeng.socialize.handler.QZoneSsoHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.QQ, (Object)"com.umeng.socialize.handler.UMQQSsoHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.RENREN, (Object)"com.umeng.socialize.handler.RenrenSsoHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.TENCENT, (Object)"com.umeng.socialize.handler.TencentWBSsoHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.WEIXIN, (Object)"com.umeng.socialize.handler.UMWXHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.WEIXIN_CIRCLE, (Object)"com.umeng.socialize.handler.UMWXHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.WEIXIN_FAVORITE, (Object)"com.umeng.socialize.handler.UMWXHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.YIXIN, (Object)"com.umeng.socialize.handler.UMYXHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.YIXIN_CIRCLE, (Object)"com.umeng.socialize.handler.UMYXHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.EMAIL, (Object)"com.umeng.socialize.handler.EmailHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.EVERNOTE, (Object)"com.umeng.socialize.handler.UMEvernoteHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.FACEBOOK, (Object)"com.umeng.socialize.handler.UMFacebookHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.FLICKR, (Object)"com.umeng.socialize.handler.UMFlickrHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.FOURSQUARE, (Object)"com.umeng.socialize.handler.UMFourSquareHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.GOOGLEPLUS, (Object)"com.umeng.socialize.handler.UMGooglePlusHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.INSTAGRAM, (Object)"com.umeng.socialize.handler.UMInstagramHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.KAKAO, (Object)"com.umeng.socialize.handler.UMKakaoHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.LINE, (Object)"com.umeng.socialize.handler.UMLineHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.LINKEDIN, (Object)"com.umeng.socialize.handler.UMLinkedInHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.POCKET, (Object)"com.umeng.socialize.handler.UMPocketHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.WHATSAPP, (Object)"com.umeng.socialize.handler.UMWhatsAppHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.YNOTE, (Object)"com.umeng.socialize.handler.UMYNoteHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.SMS, (Object)"com.umeng.socialize.handler.SmsHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.DOUBAN, (Object)"com.umeng.socialize.handler.DoubanHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.TUMBLR, (Object)"com.umeng.socialize.handler.UMTumblrHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.TWITTER, (Object)"com.umeng.socialize.handler.TwitterHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.ALIPAY, (Object)"com.umeng.socialize.handler.AlipayHandler"));
        sp.add((Pair<SHARE_MEDIA, String>)new Pair((Object)SHARE_MEDIA.MORE, (Object)"com.umeng.socialize.handler.UMMoreHandler"));
        this.guard = new ParamsGuard(this.platformHandlers);
        this.mContext = null;
        this.mContext = context;
        this.init();
    }

    private void init() {
        for (Pair<SHARE_MEDIA, String> pair : this.supportedPlatform) {
            UMSSOHandler h = pair.first == SHARE_MEDIA.WEIXIN_CIRCLE || pair.first == SHARE_MEDIA.WEIXIN_FAVORITE ? this.platformHandlers.get(SHARE_MEDIA.WEIXIN) : (pair.first == SHARE_MEDIA.YIXIN_CIRCLE ? this.platformHandlers.get(SHARE_MEDIA.YIXIN) : (pair.first == SHARE_MEDIA.LAIWANG_DYNAMIC ? this.platformHandlers.get(SHARE_MEDIA.LAIWANG) : (pair.first == SHARE_MEDIA.TENCENT ? this.newHandler((String)pair.second) : (pair.first == SHARE_MEDIA.MORE ? new UMMoreHandler() : (pair.first == SHARE_MEDIA.SINA ? (Config.isUmengSina.booleanValue() ? this.newHandler((String)pair.second) : this.newHandler("com.umeng.socialize.handler.SinaSsoHandler")) : this.newHandler((String)pair.second))))));
            this.platformHandlers.put((SHARE_MEDIA)pair.first, h);
        }
    }

    private UMSSOHandler newHandler(String classpath) {
        UMSSOHandler handler = null;
        try {
            Class<?> pHandler = Class.forName(classpath);
            handler = (UMSSOHandler)pHandler.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (handler == null && classpath.contains("UmengSinaHandler")) {
            Config.isUmengSina = false;
            return this.newHandler("com.umeng.socialize.handler.SinaSsoHandler");
        }
        return handler;
    }

    public UMSSOHandler getHandler(SHARE_MEDIA name) {
        UMSSOHandler handler = this.platformHandlers.get(name);
        if (handler != null) {
            PlatformConfig.Platform p = PlatformConfig.getPlatform(name);
            handler.onCreate(this.mContext, p);
        }
        return handler;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        UMSSOHandler handler = this.getHandler(requestCode);
        if (handler != null) {
            handler.onActivityResult(requestCode, resultCode, data);
        }
    }

    public void onCreate(Activity context, int requestCode, UMAuthListener listener) {
        UMSSOHandler handler = this.getHandler(requestCode);
        if (handler != null && (requestCode == 10103 || requestCode == 11101)) {
            handler.onCreate((Context)context, PlatformConfig.getPlatform(this.getShareMediaByrequestCode(requestCode)));
            handler.setAuthListener(listener);
        }
    }

    private UMSSOHandler getHandler(int requestCode) {
        int code = requestCode;
        if (requestCode == 10103 || requestCode == 11101) {
            code = 10103;
        }
        if (requestCode == 64207 || requestCode == 64206) {
            code = 64206;
        }
        if (requestCode == 32973 || requestCode == 765) {
            code = 5659;
        }
        if (requestCode == 5650) {
            code = 5659;
        }
        for (UMSSOHandler handler : this.platformHandlers.values()) {
            if (handler == null || code != handler.getRequestCode()) continue;
            return handler;
        }
        return null;
    }

    public SHARE_MEDIA getShareMediaByrequestCode(int requestCode) {
        if (requestCode == 10103 || requestCode == 11101) {
            return SHARE_MEDIA.QQ;
        }
        if (requestCode == 32973 || requestCode == 765) {
            return SHARE_MEDIA.SINA;
        }
        return SHARE_MEDIA.QQ;
    }

    public void registHandler(SHARE_MEDIA name, UMSSOHandler handler) {
        if (name != null && handler != null) {
            this.platformHandlers.put(name, handler);
        } else {
            Log.e((String)"SHARE_MEDIA or UMSSOHandler is null");
        }
    }

    public void deleteOauth(Activity context, SHARE_MEDIA platform, UMAuthListener listener) {
        if (!this.guard.auth((Context)context, platform)) {
            return;
        }
        if (listener == null) {
            listener = new UMAuthListener(){

                @Override
                public void onComplete(SHARE_MEDIA platform, int action, Map<String, String> data) {
                }

                @Override
                public void onError(SHARE_MEDIA platform, int action, Throwable t) {
                }

                @Override
                public void onCancel(SHARE_MEDIA platform, int action) {
                }
            };
        }
        this.platformHandlers.get(platform).onCreate((Context)context, PlatformConfig.getPlatform(platform));
        this.platformHandlers.get(platform).deleteAuth(listener);
    }

    public void getPlatformInfo(Activity context, SHARE_MEDIA platform, final UMAuthListener listener) {
        if (!this.guard.auth((Context)context, platform)) {
            return;
        }
        UMSSOHandler handler = this.platformHandlers.get(platform);
        handler.onCreate((Context)context, PlatformConfig.getPlatform(platform));
        final String tag = String.valueOf(System.currentTimeMillis());
        if (ContextUtil.getContext() != null) {
            SocialAnalytics.getInfostart((Context)ContextUtil.getContext(), (SHARE_MEDIA)platform, (String)handler.getSDKVersion(), (String)tag);
        }
        UMAuthListener getListener = new UMAuthListener(){

            @Override
            public void onComplete(SHARE_MEDIA platform, int action, Map<String, String> data) {
                if (listener != null) {
                    listener.onComplete(platform, action, data);
                }
                if (ContextUtil.getContext() != null) {
                    SocialAnalytics.getInfoendt((Context)ContextUtil.getContext(), (String)platform.toString().toLowerCase(), (String)"success", (String)"", (String)tag);
                }
            }

            @Override
            public void onError(SHARE_MEDIA platform, int action, Throwable t) {
                if (listener != null) {
                    listener.onError(platform, action, t);
                }
                if (ContextUtil.getContext() != null) {
                    SocialAnalytics.getInfoendt((Context)ContextUtil.getContext(), (String)platform.toString().toLowerCase(), (String)"fail", (String)t.getMessage(), (String)tag);
                }
            }

            @Override
            public void onCancel(SHARE_MEDIA platform, int action) {
                if (listener != null) {
                    listener.onCancel(platform, action);
                }
                if (ContextUtil.getContext() != null) {
                    SocialAnalytics.getInfoendt((Context)ContextUtil.getContext(), (String)platform.toString().toLowerCase(), (String)"cancel", (String)"", (String)tag);
                }
            }
        };
        handler.getPlatformInfo(getListener);
    }

    public void getFriendInfo(Activity context, SHARE_MEDIA platform, UMFriendListener listener) {
        if (!this.guard.auth((Context)context, platform)) {
            return;
        }
        if (listener == null) {
            listener = new UMFriendListener(){

                @Override
                public void onComplete(SHARE_MEDIA platform, int action, Map<String, Object> data) {
                }

                @Override
                public void onError(SHARE_MEDIA platform, int action, Throwable t) {
                }

                @Override
                public void onCancel(SHARE_MEDIA platform, int action) {
                }
            };
        }
        this.platformHandlers.get(platform).onCreate((Context)context, PlatformConfig.getPlatform(platform));
    }

    public boolean isInstall(Activity context, SHARE_MEDIA platform) {
        if (!this.guard.auth((Context)context, platform)) {
            return false;
        }
        this.platformHandlers.get(platform).onCreate((Context)context, PlatformConfig.getPlatform(platform));
        return this.platformHandlers.get(platform).isInstall();
    }

    public boolean isSupport(Activity context, SHARE_MEDIA platform) {
        if (!this.guard.auth((Context)context, platform)) {
            return false;
        }
        this.platformHandlers.get(platform).onCreate((Context)context, PlatformConfig.getPlatform(platform));
        return this.platformHandlers.get(platform).isSupport();
    }

    public String getSDKVersion(Activity context, SHARE_MEDIA platform) {
        if (!this.guard.auth((Context)context, platform)) {
            return "";
        }
        this.platformHandlers.get(platform).onCreate((Context)context, PlatformConfig.getPlatform(platform));
        return this.platformHandlers.get(platform).getSDKVersion();
    }

    public boolean isAuthorize(Activity context, SHARE_MEDIA platform) {
        if (!this.guard.auth((Context)context, platform)) {
            return false;
        }
        this.platformHandlers.get(platform).onCreate((Context)context, PlatformConfig.getPlatform(platform));
        return this.platformHandlers.get(platform).isAuthorize();
    }

    public void doOauthVerify(Activity activity, SHARE_MEDIA platform, final UMAuthListener listener) {
        if (!this.guard.auth((Context)activity, platform)) {
            return;
        }
        UMSSOHandler handler = this.platformHandlers.get(platform);
        handler.onCreate((Context)activity, PlatformConfig.getPlatform(platform));
        final String tag = String.valueOf(System.currentTimeMillis());
        if (ContextUtil.getContext() != null) {
            SocialAnalytics.authstart((Context)ContextUtil.getContext(), (SHARE_MEDIA)platform, (String)handler.getSDKVersion(), (boolean)handler.isInstall(), (String)tag);
        }
        UMAuthListener authListener = new UMAuthListener(){

            @Override
            public void onComplete(SHARE_MEDIA platform, int action, Map<String, String> data) {
                if (listener != null) {
                    listener.onComplete(platform, action, data);
                }
                if (ContextUtil.getContext() != null) {
                    SocialAnalytics.authendt((Context)ContextUtil.getContext(), (String)platform.toString().toLowerCase(), (String)"success", (String)"", (String)tag);
                }
            }

            @Override
            public void onError(SHARE_MEDIA platform, int action, Throwable t) {
                if (listener != null) {
                    listener.onError(platform, action, t);
                }
                if (ContextUtil.getContext() != null) {
                    SocialAnalytics.authendt((Context)ContextUtil.getContext(), (String)platform.toString().toLowerCase(), (String)"fail", (String)t.getMessage(), (String)tag);
                }
            }

            @Override
            public void onCancel(SHARE_MEDIA platform, int action) {
                if (listener != null) {
                    listener.onCancel(platform, action);
                }
                if (ContextUtil.getContext() != null) {
                    SocialAnalytics.authendt((Context)ContextUtil.getContext(), (String)platform.toString().toLowerCase(), (String)"cancel", (String)"", (String)tag);
                }
            }
        };
        handler.authorize(authListener);
    }

    public void share(Activity activity, ShareAction action, UMShareListener listener) {
        WeakReference<Activity> mWeakAct = new WeakReference<Activity>(activity);
        if (!this.guard.share(action)) {
            return;
        }
        SHARE_MEDIA platform = action.getPlatform();
        UMSSOHandler handler = this.platformHandlers.get(platform);
        handler.setCaller(action.getFrom());
        handler.onCreate((Context)mWeakAct.get(), PlatformConfig.getPlatform(platform));
        if (!(platform.toString().equals("TENCENT") || platform.toString().equals("RENREN") || platform.toString().equals("DOUBAN"))) {
            if (platform.toString().equals("WEIXIN")) {
                SocialAnalytics.log((Context)((Context)mWeakAct.get()), (String)"wxsession", (String)action.getShareContent().mText, (UMediaObject)action.getShareContent().mMedia);
            } else if (platform.toString().equals("WEIXIN_CIRCLE")) {
                SocialAnalytics.log((Context)((Context)mWeakAct.get()), (String)"wxtimeline", (String)action.getShareContent().mText, (UMediaObject)action.getShareContent().mMedia);
            } else if (platform.toString().equals("WEIXIN_FAVORITE")) {
                SocialAnalytics.log((Context)((Context)mWeakAct.get()), (String)"wxfavorite", (String)action.getShareContent().mText, (UMediaObject)action.getShareContent().mMedia);
            } else {
                SocialAnalytics.log((Context)((Context)mWeakAct.get()), (String)platform.toString().toLowerCase(), (String)action.getShareContent().mText, (UMediaObject)action.getShareContent().mMedia);
            }
        }
        if (Config.isloadUrl) {
            this.initUrl((Activity)mWeakAct.get(), action);
        }
        final String tag = String.valueOf(System.currentTimeMillis());
        if (ContextUtil.getContext() != null) {
            SocialAnalytics.sharestart((Context)ContextUtil.getContext(), (SHARE_MEDIA)action.getPlatform(), (String)handler.getSDKVersion(), (boolean)handler.isInstall(), (int)action.getShareContent().getShareType(), (String)tag);
        }
        final UMShareListener finalListener = listener;
        UMShareListener shareListener = new UMShareListener(){

            @Override
            public void onResult(SHARE_MEDIA platform) {
                if (ContextUtil.getContext() != null) {
                    SocialAnalytics.shareend((Context)ContextUtil.getContext(), (String)platform.toString().toLowerCase(), (String)"success", (String)"", (String)tag);
                }
                if (finalListener != null) {
                    finalListener.onResult(platform);
                }
            }

            @Override
            public void onError(SHARE_MEDIA platform, Throwable t) {
                if (ContextUtil.getContext() != null) {
                    SocialAnalytics.shareend((Context)ContextUtil.getContext(), (String)platform.toString().toLowerCase(), (String)"fail", (String)t.getMessage(), (String)tag);
                }
                if (finalListener != null) {
                    finalListener.onError(platform, t);
                }
            }

            @Override
            public void onCancel(SHARE_MEDIA platform) {
                if (ContextUtil.getContext() != null) {
                    SocialAnalytics.shareend((Context)ContextUtil.getContext(), (String)platform.toString().toLowerCase(), (String)"cancel", (String)"", (String)tag);
                }
                if (finalListener != null) {
                    finalListener.onCancel(platform);
                }
            }
        };
        handler.share(action.getShareContent(), shareListener);
    }

    private void initUrl(Activity activity, ShareAction action) {
        String targeturl = action.getShareContent().mTargetUrl;
        if (!TextUtils.isEmpty((CharSequence)targeturl)) {
            String platform = action.getPlatform().toString().equals("WEIXIN") ? "wxsession" : (action.getPlatform().toString().equals("") ? "wxtimeline" : action.getPlatform().toString().toLowerCase());
            UrlRequest request = new UrlRequest((Context)activity, platform, targeturl);
            UrlResponse resp = RestAPI.uploadUrl((UrlRequest)request);
            if (resp == null || resp.mStCode != 200) {
                Log.e((String)"upload url fail ");
            } else {
                action.withTargetUrl(resp.result);
            }
        }
    }

    static class ParamsGuard {
        private Map<SHARE_MEDIA, UMSSOHandler> handlers;

        public ParamsGuard(Map<SHARE_MEDIA, UMSSOHandler> handlers) {
            this.handlers = handlers;
        }

        public boolean auth(Context context, SHARE_MEDIA platform) {
            if (!this.checkContext(context)) {
                return false;
            }
            if (!this.checkPlatformConfig(platform)) {
                return false;
            }
            UMSSOHandler handler = this.handlers.get(platform);
            if (!handler.isSupportAuth()) {
                Log.w((String)(platform.toString() + "\u5e73\u53f0\u4e0d\u652f\u6301\u6388\u6743,\u65e0\u6cd5\u5b8c\u6210\u64cd\u4f5c"));
                return false;
            }
            return true;
        }

        public boolean share(ShareAction action) {
            SHARE_MEDIA platform = action.getPlatform();
            if (platform == null) {
                return false;
            }
            return this.checkPlatformConfig(platform);
        }

        private boolean checkContext(Context context) {
            if (context == null) {
                Log.e((String)"Context is null");
                return false;
            }
            return true;
        }

        private boolean checkPlatformConfig(SHARE_MEDIA media) {
            PlatformConfig.Platform platform = PlatformConfig.configs.get(media);
            if (platform != null && !platform.isConfigured()) {
                Log.e((String)(media + ": \u6ca1\u6709\u914d\u7f6e\u76f8\u5173\u7684Appkey\u3001Secret"));
                return false;
            }
            UMSSOHandler handler = this.handlers.get(media);
            if (handler == null) {
                Log.e((String)("\u6ca1\u6709\u914d\u7f6e " + media + " \u7684jar\u5305"));
                return false;
            }
            return true;
        }
    }
}

