/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize;

import android.app.AlertDialog;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.Signature;
import android.text.TextUtils;
import android.util.Base64;
import android.widget.Toast;
import com.umeng.socialize.Config;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class UmengTool {
    private static PackageManager manager;
    private static PackageInfo packageInfo;
    private static final char[] HEX_CHAR;

    public static void getSignature(Context context) {
        String pkName = context.getPackageName();
        manager = context.getPackageManager();
        if (TextUtils.isEmpty((CharSequence)pkName)) {
            Toast.makeText((Context)context, (CharSequence)"\u5e94\u7528\u7a0b\u5e8f\u7684\u5305\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (int)0);
        } else {
            try {
                packageInfo = manager.getPackageInfo(pkName, 64);
                String packagename = UmengTool.packageInfo.packageName;
                String result = UmengTool.getSignatureDigest(packageInfo);
                UmengTool.showDialog(context, "\u5305\u540d\uff1a" + packagename + "\n" + "\u7b7e\u540d:" + result.toLowerCase() + "  SHA1:" + UmengTool.getCertificateSHA1Fingerprint(context) + "\n" + "facebook keyhash:" + UmengTool.facebookHashKey(packageInfo));
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private static String facebookHashKey(PackageInfo info) {
        try {
            Signature[] signatureArray = info.signatures;
            int n = signatureArray.length;
            int n2 = 0;
            if (n2 < n) {
                Signature signature = signatureArray[n2];
                MessageDigest md = MessageDigest.getInstance("SHA");
                md.update(signature.toByteArray());
                return Base64.encodeToString((byte[])md.digest(), (int)0);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return null;
    }

    private static void showDialog(Context context, String result) {
        new AlertDialog.Builder(context).setTitle((CharSequence)"umengtool").setMessage((CharSequence)result).setPositiveButton((CharSequence)"\u786e\u5b9a", null).show();
    }

    public static void getREDICRECT_URL(Context context) {
        UmengTool.showDialog(context, Config.REDIRECT_URL);
    }

    public static String getSignatureDigest(PackageInfo pkgInfo) {
        int length = pkgInfo.signatures.length;
        if (length <= 0) {
            return "";
        }
        Signature signature = pkgInfo.signatures[0];
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        byte[] digest = md5.digest(signature.toByteArray());
        return UmengTool.toHexString(digest);
    }

    private static String toHexString(byte[] rawByteArray) {
        char[] chars = new char[rawByteArray.length * 2];
        for (int i = 0; i < rawByteArray.length; ++i) {
            byte b = rawByteArray[i];
            chars[i * 2] = HEX_CHAR[b >>> 4 & 0xF];
            chars[i * 2 + 1] = HEX_CHAR[b & 0xF];
        }
        return new String(chars);
    }

    public static void checkpermission(Context context) {
        PackageManager pm = context.getPackageManager();
        PackageInfo pi = null;
        try {
            pi = pm.getPackageInfo(context.getPackageName(), 0);
            String pkgName = pi.packageName;
            PackageInfo pkgInfo = pm.getPackageInfo(pkgName, 4096);
            String[] sharedPkgList = pkgInfo.requestedPermissions;
            StringBuilder tv = new StringBuilder();
            for (int i = 0; i < sharedPkgList.length; ++i) {
                String permName = sharedPkgList[i];
                PermissionInfo tmpPermInfo = pm.getPermissionInfo(permName, 0);
                PermissionGroupInfo pgi = pm.getPermissionGroupInfo(tmpPermInfo.group, 0);
                tv.append(i + "-" + permName + "\n");
                tv.append(i + "-" + pgi.loadLabel(pm).toString() + "\n");
                tv.append(i + "-" + tmpPermInfo.loadLabel(pm).toString() + "\n");
                tv.append(i + "-" + tmpPermInfo.loadDescription(pm).toString() + "\n");
                tv.append("   \n");
            }
            UmengTool.showDialog(context, tv.toString());
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void checkWx(Context context) {
        String pkName = context.getPackageName();
        String classPath = pkName + ".wxapi.WXEntryActivity";
        try {
            Class<?> clz = Class.forName(classPath);
            if (clz == null) {
                new AlertDialog.Builder(context).setTitle((CharSequence)"umengtool").setMessage((CharSequence)"\u6ca1\u6709\u914d\u7f6e\u5fae\u4fe1\u56de\u8c03activity\u6216\u914d\u7f6e\u4e0d\u6b63\u786e").setPositiveButton((CharSequence)"\u786e\u5b9a", null).show();
            } else {
                new AlertDialog.Builder(context).setTitle((CharSequence)"umengtool").setMessage((CharSequence)"\u5fae\u4fe1\u914d\u7f6e\u6b63\u786e").setPositiveButton((CharSequence)"\u786e\u5b9a", null).show();
            }
        }
        catch (ClassNotFoundException e) {
            new AlertDialog.Builder(context).setTitle((CharSequence)"umengtool").setMessage((CharSequence)"\u6ca1\u6709\u914d\u7f6e\u5fae\u4fe1\u56de\u8c03activity\u6216\u914d\u7f6e\u4e0d\u6b63\u786e").setPositiveButton((CharSequence)"\u786e\u5b9a", null).show();
            e.printStackTrace();
        }
    }

    public static void checkSina(Context context) {
        String pkName = context.getPackageName();
        String classPath = pkName + ".WBShareActivity";
        try {
            Class<?> clz = Class.forName(classPath);
            if (clz == null) {
                new AlertDialog.Builder(context).setTitle((CharSequence)"umengtool").setMessage((CharSequence)"\u6ca1\u6709\u914d\u7f6e\u65b0\u6d6a\u56de\u8c03activity\u6216\u914d\u7f6e\u4e0d\u6b63\u786e").setPositiveButton((CharSequence)"\u786e\u5b9a", null).show();
            } else {
                new AlertDialog.Builder(context).setTitle((CharSequence)"umengtool").setMessage((CharSequence)"\u65b0\u6d6a\u914d\u7f6e\u6b63\u786e").setPositiveButton((CharSequence)"\u786e\u5b9a", null).show();
            }
        }
        catch (ClassNotFoundException e) {
            new AlertDialog.Builder(context).setTitle((CharSequence)"umengtool").setMessage((CharSequence)"\u6ca1\u6709\u914d\u7f6e\u65b0\u6d6a\u56de\u8c03activity\u6216\u914d\u7f6e\u4e0d\u6b63\u786e").setPositiveButton((CharSequence)"\u786e\u5b9a", null).show();
            e.printStackTrace();
        }
    }

    public static void checkAlipay(Context context) {
        String pkName = context.getPackageName();
        String classPath = pkName + ".apshare.ShareEntryActivity";
        try {
            Class<?> clz = Class.forName(classPath);
            if (clz == null) {
                new AlertDialog.Builder(context).setTitle((CharSequence)"umengtool").setMessage((CharSequence)"\u6ca1\u6709\u914d\u7f6e\u652f\u4ed8\u5b9d\u56de\u8c03activity\u6216\u914d\u7f6e\u4e0d\u6b63\u786e").setPositiveButton((CharSequence)"\u786e\u5b9a", null).show();
            } else {
                new AlertDialog.Builder(context).setTitle((CharSequence)"umengtool").setMessage((CharSequence)"\u652f\u4ed8\u5b9d\u914d\u7f6e\u6b63\u786e").setPositiveButton((CharSequence)"\u786e\u5b9a", null).show();
            }
        }
        catch (ClassNotFoundException e) {
            new AlertDialog.Builder(context).setTitle((CharSequence)"umengtool").setMessage((CharSequence)"\u6ca1\u6709\u914d\u7f6e\u652f\u4ed8\u5b9d\u56de\u8c03activity\u6216\u914d\u7f6e\u4e0d\u6b63\u786e").setPositiveButton((CharSequence)"\u786e\u5b9a", null).show();
            e.printStackTrace();
        }
    }

    public static String getCertificateSHA1Fingerprint(Context context) {
        PackageManager pm = context.getPackageManager();
        String packageName = context.getPackageName();
        int flags = 64;
        PackageInfo packageInfo = null;
        try {
            packageInfo = pm.getPackageInfo(packageName, flags);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        Signature[] signatures = packageInfo.signatures;
        byte[] cert = signatures[0].toByteArray();
        ByteArrayInputStream input = new ByteArrayInputStream(cert);
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance("X509");
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        X509Certificate c = null;
        try {
            c = (X509Certificate)cf.generateCertificate(input);
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        String hexString = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] publicKey = md.digest(c.getEncoded());
            hexString = UmengTool.byte2HexFormatted(publicKey);
        }
        catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        }
        catch (CertificateEncodingException e) {
            e.printStackTrace();
        }
        return hexString;
    }

    private static String byte2HexFormatted(byte[] arr) {
        StringBuilder str = new StringBuilder(arr.length * 2);
        for (int i = 0; i < arr.length; ++i) {
            String h = Integer.toHexString(arr[i]);
            int l = h.length();
            if (l == 1) {
                h = "0" + h;
            }
            if (l > 2) {
                h = h.substring(l - 2, l);
            }
            str.append(h.toUpperCase());
            if (i >= arr.length - 1) continue;
            str.append(':');
        }
        return str.toString();
    }

    static {
        HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

