/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import com.umeng.socialize.Config;
import com.umeng.socialize.ShareAction;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.common.QueuedWork;
import com.umeng.socialize.controller.SocialRouter;
import com.umeng.socialize.handler.UMSSOHandler;
import com.umeng.socialize.net.ActionBarRequest;
import com.umeng.socialize.net.ActionBarResponse;
import com.umeng.socialize.net.RestAPI;
import com.umeng.socialize.net.base.SocializeReseponse;
import com.umeng.socialize.net.stats.DauStatsRequest;
import com.umeng.socialize.net.stats.StatsAPIs;
import com.umeng.socialize.uploadlog.UMLog;
import com.umeng.socialize.utils.ContextUtil;
import com.umeng.socialize.utils.Log;
import com.umeng.socialize.view.UMFriendListener;
import java.lang.ref.WeakReference;

public class UMShareAPI {
    private static UMShareAPI singleton = null;
    SocialRouter router;

    private UMShareAPI(Context context) {
        ContextUtil.setContext((Context)context.getApplicationContext());
        this.router = new SocialRouter(context.getApplicationContext());
        new InitThread(context.getApplicationContext()).execute();
    }

    public static UMShareAPI get(Context context) {
        if (singleton == null || UMShareAPI.singleton.router == null) {
            singleton = new UMShareAPI(context);
        }
        UMShareAPI.singleton.router.setmContext(context);
        return singleton;
    }

    public void doOauthVerify(final Activity activity, final SHARE_MEDIA platform, final UMAuthListener listener) {
        UMLog.putAuth();
        UMShareAPI.singleton.router.setmContext((Context)activity);
        if (activity != null) {
            new QueuedWork.DialogThread<Void>((Context)activity){

                protected Void doInBackground() {
                    if (UMShareAPI.this.router != null) {
                        UMShareAPI.this.router.doOauthVerify(activity, platform, listener);
                    } else {
                        UMShareAPI.this.router = new SocialRouter((Context)activity);
                        UMShareAPI.this.router.doOauthVerify(activity, platform, listener);
                    }
                    return null;
                }
            }.execute();
        } else {
            Log.d((String)"UMerror", (String)"doOauthVerify activity is null");
        }
    }

    public void deleteOauth(final Activity context, final SHARE_MEDIA platform, final UMAuthListener listener) {
        if (context != null) {
            UMShareAPI.singleton.router.setmContext((Context)context);
            new QueuedWork.DialogThread<Void>((Context)context){

                protected Object doInBackground() {
                    if (UMShareAPI.this.router != null) {
                        UMShareAPI.this.router.deleteOauth(context, platform, listener);
                    }
                    return null;
                }
            }.execute();
        } else {
            Log.d((String)"UMerror", (String)"deleteOauth activity is null");
        }
    }

    public void getPlatformInfo(final Activity context, final SHARE_MEDIA platform, final UMAuthListener listener) {
        if (context != null) {
            UMShareAPI.singleton.router.setmContext((Context)context);
            new QueuedWork.DialogThread<Void>((Context)context){

                protected Object doInBackground() {
                    if (UMShareAPI.this.router != null) {
                        UMShareAPI.this.router.getPlatformInfo(context, platform, listener);
                    }
                    return null;
                }
            }.execute();
        } else {
            Log.d((String)"UMerror", (String)"getPlatformInfo activity argument is null");
        }
    }

    public boolean isInstall(Activity context, SHARE_MEDIA platform) {
        if (this.router != null) {
            return this.router.isInstall(context, platform);
        }
        this.router = new SocialRouter((Context)context);
        return this.router.isInstall(context, platform);
    }

    public boolean isAuthorize(Activity context, SHARE_MEDIA platform) {
        if (this.router != null) {
            return this.router.isAuthorize(context, platform);
        }
        this.router = new SocialRouter((Context)context);
        return this.router.isAuthorize(context, platform);
    }

    public boolean isSupport(Activity context, SHARE_MEDIA platform) {
        if (this.router != null) {
            return this.router.isSupport(context, platform);
        }
        this.router = new SocialRouter((Context)context);
        return this.router.isSupport(context, platform);
    }

    public String getversion(Activity context, SHARE_MEDIA platform) {
        if (this.router != null) {
            return this.router.getSDKVersion(context, platform);
        }
        this.router = new SocialRouter((Context)context);
        return this.router.getSDKVersion(context, platform);
    }

    public void getFriend(final Activity context, final SHARE_MEDIA platform, final UMFriendListener listener) {
        if (context != null) {
            new QueuedWork.DialogThread<Void>((Context)context){

                protected Object doInBackground() {
                    if (UMShareAPI.this.router != null) {
                        UMShareAPI.this.router.getFriendInfo(context, platform, listener);
                    } else {
                        UMShareAPI.this.router = new SocialRouter((Context)context);
                        UMShareAPI.this.router.getFriendInfo(context, platform, listener);
                    }
                    return null;
                }
            }.execute();
        } else {
            Log.d((String)"UMerror", (String)"getFriend activity is null");
        }
    }

    public void doShare(Activity activity, final ShareAction share, final UMShareListener listener) {
        UMLog.putShare();
        final WeakReference<Activity> mWeakAct = new WeakReference<Activity>(activity);
        if (mWeakAct.get() != null && !((Activity)mWeakAct.get()).isFinishing()) {
            UMShareAPI.singleton.router.setmContext((Context)activity);
            new QueuedWork.DialogThread<Void>((Context)mWeakAct.get()){

                protected Void doInBackground() {
                    if (mWeakAct.get() == null || ((Activity)mWeakAct.get()).isFinishing()) {
                        return null;
                    }
                    Thread.currentThread().setName(share.getPlatform().toString());
                    if (UMShareAPI.this.router != null) {
                        UMShareAPI.this.router.share((Activity)mWeakAct.get(), share, listener);
                    } else {
                        UMShareAPI.this.router = new SocialRouter((Context)mWeakAct.get());
                        UMShareAPI.this.router.share((Activity)mWeakAct.get(), share, listener);
                    }
                    return null;
                }
            }.execute();
        } else {
            Log.d((String)"UMerror", (String)"Share activity is null");
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.router != null) {
            this.router.onActivityResult(requestCode, resultCode, data);
        } else {
            Log.v((String)"auth fail", (String)"router=null");
        }
    }

    public void HandleQQError(Activity activity, int requestCode, UMAuthListener listener) {
        if (this.router != null) {
            this.router.onCreate(activity, requestCode, listener);
        } else {
            Log.v((String)"auth fail", (String)"router=null");
        }
    }

    public UMSSOHandler getHandler(SHARE_MEDIA name) {
        if (this.router != null) {
            return this.router.getHandler(name);
        }
        return null;
    }

    static class InitThread
    extends QueuedWork.UMAsyncTask<Void> {
        private Context mContext;

        public InitThread(Context context) {
            this.mContext = context;
        }

        protected Void doInBackground() {
            boolean isNewInstall = this.isNewInstall();
            ActionBarRequest request = new ActionBarRequest(this.mContext, isNewInstall);
            ActionBarResponse response = RestAPI.queryShareId((ActionBarRequest)request);
            if (response != null && response.isOk()) {
                this.setInstalled();
                Log.i((String)("response: " + response.mMsg));
                Config.EntityKey = response.mEntityKey;
                Config.SessionId = response.mSid;
                Config.UID = response.mUid;
            }
            DauStatsRequest req = new DauStatsRequest(this.mContext, SocializeReseponse.class);
            Bundle bundle = UMLog.getShareAndAuth();
            if (bundle != null) {
                req.addStringParams("isshare", bundle.getBoolean("share") + "");
                req.addStringParams("isauth", bundle.getBoolean("auth") + "");
                req.addStringParams("type", Config.shareType);
                req.addStringParams("ni", (isNewInstall ? 1 : 0) + "");
            }
            StatsAPIs.dauStats((DauStatsRequest)req);
            Log.i((String)("response has error: " + (response == null ? "null" : response.mMsg)));
            return null;
        }

        private boolean isNewInstall() {
            SharedPreferences sp = this.mContext.getSharedPreferences("umeng_socialize", 0);
            return sp.getBoolean("newinstall", false);
        }

        public void setInstalled() {
            SharedPreferences sp = this.mContext.getSharedPreferences("umeng_socialize", 0);
            SharedPreferences.Editor ed = sp.edit();
            ed.putBoolean("newinstall", true);
            ed.commit();
        }
    }
}

