/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.weibo.sdk.android.network;

import android.os.AsyncTask;
import android.util.Log;
import com.tencent.weibo.sdk.android.network.HttpCallback;
import com.tencent.weibo.sdk.android.network.HttpService;
import com.tencent.weibo.sdk.android.network.ReqParam;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;

public abstract class HttpReq
extends AsyncTask<Void, Integer, Object> {
    private final String GET = "GET";
    private final String POST = "POST";
    protected String mHost = null;
    protected int mPort = 8088;
    protected String mUrl = null;
    protected String mMethod = null;
    protected ReqParam mParam = new ReqParam();
    protected HttpCallback mCallBack = null;
    private int mServiceTag = -1;

    public void setServiceTag(int nTag) {
        this.mServiceTag = nTag;
    }

    public int getServiceTag() {
        return this.mServiceTag;
    }

    protected HttpCallback getCallBack() {
        return this.mCallBack;
    }

    protected abstract void setReq(HttpMethod var1) throws Exception;

    protected abstract Object processResponse(InputStream var1) throws Exception;

    public void setParam(ReqParam param) {
        this.mParam = param;
    }

    public void addParam(String key, String value) {
        this.mParam.addParam(key, value);
    }

    public void addParam(String key, Object value) {
        this.mParam.addParam(key, value);
    }

    public Object runReq() throws Exception {
        HttpClient client = new HttpClient();
        UTF8PostMethod method = null;
        int statusCode = -1;
        if (this.mMethod.equals("GET")) {
            this.mUrl = String.valueOf(this.mUrl) + "?" + this.mParam.toString().substring(0, this.mParam.toString().length() - 1);
            method = new GetMethod(this.mUrl);
        } else if (this.mMethod.equals("POST")) {
            if (this.mParam.getmParams().get("pic") != null) {
                return this.processResponse(this.picMethod());
            }
            method = new UTF8PostMethod(this.mUrl);
        } else {
            throw new Exception("unrecognized http method");
        }
        client.getHostConfiguration().setHost(this.mHost, this.mPort, "https");
        method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        this.setReq((HttpMethod)method);
        statusCode = client.executeMethod((HttpMethod)method);
        Log.d((String)"result", (String)String.valueOf(statusCode));
        if (statusCode != 200) {
            return null;
        }
        Object result = null;
        result = this.processResponse(method.getResponseBodyAsStream());
        return result;
    }

    private InputStream picMethod() {
        HttpResponse response;
        InputStream result;
        block7: {
            DefaultHttpClient client = new DefaultHttpClient();
            result = null;
            String BOUNDARY = "---------------------------7da2137580612";
            String RETURN = "\r\n";
            String PREFIX = "--";
            String MULTIPART_FORM_DATA = "multipart/form-data";
            HttpPost post = new HttpPost(this.mUrl);
            HttpPost request = null;
            request = post;
            byte[] data = null;
            ByteArrayOutputStream bos = null;
            bos = new ByteArrayOutputStream();
            String strparams = this.mParam.toString();
            post.setHeader("Content-Type", String.valueOf(MULTIPART_FORM_DATA) + "; boundary=" + "---------------------------7da2137580612");
            if (strparams != null && !strparams.equals("")) {
                String[] params;
                String[] stringArray = params = strparams.split("&");
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray[n2];
                    if (str != null && !str.equals("") && str.indexOf("=") > -1) {
                        String[] p = str.split("=");
                        String value = p.length == 2 ? HttpReq.decode(p[1]) : "";
                        StringBuilder temp = new StringBuilder();
                        temp.append("-----------------------------7da2137580612\r\n");
                        temp.append("Content-Disposition:form-data; name=\"" + p[0] + "\"" + "\r\n");
                        temp.append("\r\n");
                        temp.append(value);
                        temp.append("\r\n");
                        bos.write(temp.toString().getBytes("utf-8"));
                    }
                    ++n2;
                }
                StringBuilder temp = new StringBuilder();
                temp.append("-----------------------------7da2137580612\r\n");
                temp.append("Content-Disposition:form-data; name=\"pic\"; filename=\"123456.jpg\"\r\n");
                temp.append("Content-Type:image/jpeg\r\n\r\n");
                bos.write(temp.toString().getBytes("utf-8"));
                char[] pics = this.mParam.getmParams().get("pic").toCharArray();
                byte[] pic = new byte[pics.length];
                int i = 0;
                while (i < pics.length) {
                    pic[i] = (byte)pics[i];
                    ++i;
                }
                bos.write(pic);
                bos.write("---------------------------7da2137580612\r\n".getBytes("utf-8"));
            }
            bos.write("-----------------------------7da2137580612--\r\n".getBytes("utf-8"));
            data = bos.toByteArray();
            ByteArrayEntity formEntity = new ByteArrayEntity(data);
            post.setEntity((HttpEntity)formEntity);
            bos.close();
            response = client.execute((HttpUriRequest)request);
            StatusLine status = response.getStatusLine();
            int statusCode = status.getStatusCode();
            if (statusCode == 200) break block7;
            result = HttpReq.readHttpResponse(response);
            return null;
        }
        try {
            result = HttpReq.readHttpResponse(response);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static String decode(String s) {
        if (s == null) {
            return "";
        }
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static InputStream readHttpResponse(HttpResponse response) {
        HttpEntity entity = response.getEntity();
        InputStream inputStream = null;
        try {
            inputStream = entity.getContent();
            Header header = response.getFirstHeader("Content-Encoding");
            if (header != null && header.getValue().toLowerCase().indexOf("gzip") > -1) {
                inputStream = new GZIPInputStream(inputStream);
            }
            return inputStream;
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return inputStream;
    }

    protected void onPreExecute() {
        super.onPreExecute();
    }

    protected Object doInBackground(Void ... params) {
        try {
            Object result = this.runReq();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void onPostExecute(Object result) {
        if (this.mCallBack != null) {
            this.mCallBack.onResult(result);
        }
        HttpService.getInstance().onReqFinish(this);
    }

    protected void onCancelled() {
        if (this.mCallBack != null) {
            this.mCallBack.onResult(null);
        }
        HttpService.getInstance().onReqFinish(this);
    }

    public static class UTF8PostMethod
    extends PostMethod {
        public UTF8PostMethod(String url) {
            super(url);
        }

        public String getRequestCharSet() {
            return "UTF-8";
        }
    }
}

