/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.weibo.sdk.android.api.util;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.util.Log;
import com.tencent.weibo.sdk.android.api.util.SharePersistent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;

public class Util {
    public static boolean isNetworkAvailable(Activity activity) {
        Context context = activity.getApplicationContext();
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm == null) {
            return false;
        }
        NetworkInfo[] info = cm.getAllNetworkInfo();
        if (info != null) {
            int i = 0;
            while (i < info.length) {
                if (info[i].getState() == NetworkInfo.State.CONNECTED) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static void saveSharePersistent(Context context, String key, String value) {
        SharePersistent mSharePersistent = SharePersistent.getInstance();
        mSharePersistent.put(context, key, value);
    }

    public static void saveSharePersistent(Context context, String key, long value) {
        SharePersistent mSharePersistent = SharePersistent.getInstance();
        mSharePersistent.put(context, key, value);
    }

    public static String getSharePersistent(Context context, String key) {
        SharePersistent mSharePersistent = SharePersistent.getInstance();
        return mSharePersistent.get(context, key);
    }

    public static Long getSharePersistentLong(Context context, String key) {
        SharePersistent mSharePersistent = SharePersistent.getInstance();
        return mSharePersistent.getLong(context, key);
    }

    public static void clearSharePersistent(Context context, String key) {
        SharePersistent mSharePersistent = SharePersistent.getInstance();
        mSharePersistent.clear(context, key);
    }

    public static void clearSharePersistent(Context context) {
        SharePersistent mSharePersistent = SharePersistent.getInstance();
        mSharePersistent.clear(context, "ACCESS_TOKEN");
        mSharePersistent.clear(context, "EXPIRES_IN");
        mSharePersistent.clear(context, "OPEN_ID");
        mSharePersistent.clear(context, "OPEN_KEY");
        mSharePersistent.clear(context, "REFRESH_TOKEN");
        mSharePersistent.clear(context, "NAME");
        mSharePersistent.clear(context, "NICK");
        mSharePersistent.clear(context, "CLIENT_ID");
    }

    public static String getLocalIPAddress(Context context) {
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        WifiInfo info = wifiManager.getConnectionInfo();
        int i = info.getIpAddress();
        String ipStr = String.valueOf(i & 0xFF) + "." + (i >> 8 & 0xFF) + "." + (i >> 16 & 0xFF) + "." + (i >> 24 & 0xFF);
        return ipStr;
    }

    public static Location getLocation(Context context) {
        Location currentLocation = null;
        try {
            LocationManager locationManager = (LocationManager)context.getSystemService("location");
            Criteria criteria = new Criteria();
            criteria.setAccuracy(2);
            criteria.setAltitudeRequired(false);
            criteria.setBearingRequired(false);
            criteria.setCostAllowed(true);
            criteria.setPowerRequirement(3);
            criteria.setSpeedRequired(false);
            String currentProvider = locationManager.getBestProvider(criteria, true);
            Log.d((String)"Location", (String)("currentProvider: " + currentProvider));
            currentLocation = locationManager.getLastKnownLocation(currentProvider);
        }
        catch (Exception e) {
            currentLocation = null;
        }
        return currentLocation;
    }

    private String intToIp(int i) {
        String ipStr = String.valueOf(i & 0xFF) + "." + (i >> 8 & 0xFF) + "." + (i >> 16 & 0xFF) + "." + (i >> 24 & 0xFF);
        return ipStr;
    }

    public static Drawable loadImageFromUrl(String imageUrl) {
        try {
            URL u = new URL(imageUrl);
            URLConnection conn = u.openConnection();
            conn.connect();
            InputStream is = conn.getInputStream();
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = false;
            options.inSampleSize = 2;
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
            return new BitmapDrawable(bitmap);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Properties getConfig() {
        Properties props = new Properties();
        InputStream in = Util.class.getResourceAsStream("/config/config.properties");
        try {
            props.load(in);
        }
        catch (IOException e) {
            Log.e((String)"\u5de5\u5177\u5305\u5f02\u5e38", (String)"\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38");
            e.printStackTrace();
        }
        return props;
    }
}

