/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.weibo.sdk.android.api.util;

import android.content.Context;
import android.content.SharedPreferences;
import com.tencent.weibo.sdk.android.model.AccountModel;

public class SharePersistent {
    private static SharePersistent instance;
    private static final String FILE_NAME = "ANDROID_SDK";

    private SharePersistent() {
    }

    public static SharePersistent getInstance() {
        if (instance == null) {
            instance = new SharePersistent();
        }
        return instance;
    }

    public boolean put(Context context, String key, String value) {
        SharedPreferences settings = context.getSharedPreferences(FILE_NAME, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putString(key, value);
        return editor.commit();
    }

    public boolean put(Context context, String key, long value) {
        SharedPreferences settings = context.getSharedPreferences(FILE_NAME, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putLong(key, value);
        return editor.commit();
    }

    public AccountModel getAccount(Context context) {
        AccountModel account = new AccountModel();
        SharedPreferences settings = context.getSharedPreferences(FILE_NAME, 0);
        account.setAccessToken(settings.getString("ACCESS_TOKEN", ""));
        account.setExpiresIn(settings.getLong("EXPIRES_IN", 0L));
        account.setOpenID(settings.getString("OPEN_ID", ""));
        account.setOpenKey(settings.getString("OPEN_KEY", ""));
        account.setRefreshToken(settings.getString("REFRESH_TOKEN", ""));
        account.setName(settings.getString("NAME", ""));
        account.setNike(settings.getString("NICK", ""));
        return account;
    }

    public String get(Context context, String key) {
        SharedPreferences settings = context.getSharedPreferences(FILE_NAME, 0);
        return settings.getString(key, "");
    }

    public long getLong(Context context, String key) {
        SharedPreferences settings = context.getSharedPreferences(FILE_NAME, 0);
        return settings.getLong(key, 0L);
    }

    public boolean clear(Context context, String key) {
        SharedPreferences settings = context.getSharedPreferences(FILE_NAME, 0);
        return settings.edit().clear().commit();
    }
}

