/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.weibo.sdk.android.api;

import android.content.Context;
import android.graphics.Bitmap;
import com.tencent.weibo.sdk.android.api.BaseAPI;
import com.tencent.weibo.sdk.android.api.util.Util;
import com.tencent.weibo.sdk.android.model.AccountModel;
import com.tencent.weibo.sdk.android.model.BaseVO;
import com.tencent.weibo.sdk.android.network.HttpCallback;
import com.tencent.weibo.sdk.android.network.ReqParam;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class WeiboAPI
extends BaseAPI {
    private static final String SERVER_URL_ADD = "https://open.t.qq.com/api/t/add_multi";
    private static final String SERVER_URL_VIDEO = "https://open.t.qq.com/api/t/getvideoinfo";
    private static final String SERVER_URL_ADDWEIBO = "https://open.t.qq.com/api/t/add";
    private static final String SERVER_URL_ADDPIC = "https://open.t.qq.com/api/t/add_pic";
    private static final String SERVER_URL_RLIST = "https://open.t.qq.com/api/t/re_list";
    private static final String SERVER_URL_ADDPICURL = "https://open.t.qq.com/api/t/add_pic_url";

    public WeiboAPI(AccountModel account) {
        super(account);
    }

    public void reAddWeibo(Context context, String content, String picUrl, String videoUrl, String musicUrl, String musicTitle, String musicAuthor, HttpCallback mCallBack, Class<? extends BaseVO> mTargetClass, int resultType) {
        ReqParam mParam = new ReqParam();
        mParam.addParam("scope", "all");
        mParam.addParam("content", content);
        mParam.addParam("pic_url", picUrl);
        mParam.addParam("video_url", videoUrl);
        mParam.addParam("music_url", musicUrl);
        mParam.addParam("music_title", musicTitle);
        mParam.addParam("music_author", musicAuthor);
        mParam.addParam("clientip", Util.getLocalIPAddress(context));
        mParam.addParam("oauth_version", "2.a");
        mParam.addParam("oauth_consumer_key", Util.getSharePersistent(context, "CLIENT_ID"));
        mParam.addParam("openid", Util.getSharePersistent(context, "OPEN_ID"));
        mParam.addParam("pageflag", "0");
        mParam.addParam("type", "0");
        mParam.addParam("format", "json");
        mParam.addParam("reqnum", "30");
        mParam.addParam("pagetime", "0");
        mParam.addParam("contenttype", "0");
        this.startRequest(context, SERVER_URL_ADD, mParam, mCallBack, mTargetClass, "POST", resultType);
    }

    public void getVideoInfo(Context context, String videoUrl, HttpCallback mCallBack, Class<? extends BaseVO> mTargetClass, int resultType) {
        ReqParam mParam = new ReqParam();
        mParam.addParam("scope", "all");
        mParam.addParam("clientip", Util.getLocalIPAddress(context));
        mParam.addParam("oauth_version", "2.a");
        mParam.addParam("oauth_consumer_key", Util.getSharePersistent(context, "CLIENT_ID"));
        mParam.addParam("openid", Util.getSharePersistent(context, "OPEN_ID"));
        mParam.addParam("format", "json");
        mParam.addParam("video_url", videoUrl);
        this.startRequest(context, SERVER_URL_VIDEO, mParam, mCallBack, mTargetClass, "POST", resultType);
    }

    public void addWeibo(Context context, String content, String format, double longitude, double latitude, int syncflag, int compatibleflag, HttpCallback mCallBack, Class<? extends BaseVO> mTargetClass, int resultType) {
        ReqParam mParam = new ReqParam();
        mParam.addParam("oauth_version", "2.a");
        mParam.addParam("oauth_consumer_key", Util.getSharePersistent(context, "CLIENT_ID"));
        mParam.addParam("openid", Util.getSharePersistent(context, "OPEN_ID"));
        mParam.addParam("scope", "all");
        mParam.addParam("format", format);
        mParam.addParam("content", content);
        mParam.addParam("clientip", Util.getLocalIPAddress(context));
        if (longitude != 0.0) {
            mParam.addParam("longitude", longitude);
        }
        if (latitude != 0.0) {
            mParam.addParam("latitude", latitude);
        }
        mParam.addParam("syncflag", syncflag);
        mParam.addParam("compatibleflag", compatibleflag);
        this.startRequest(context, SERVER_URL_ADDWEIBO, mParam, mCallBack, mTargetClass, "POST", resultType);
    }

    public void addPic(Context context, String content, String format, double longitude, double latitude, Bitmap bm, int syncflag, int compatibleflag, HttpCallback mCallBack, Class<? extends BaseVO> mTargetClass, int resultType) {
        ReqParam mParam = new ReqParam();
        mParam.addParam("oauth_version", "2.a");
        mParam.addParam("oauth_consumer_key", Util.getSharePersistent(context, "CLIENT_ID"));
        mParam.addParam("openid", Util.getSharePersistent(context, "OPEN_ID"));
        mParam.addParam("scope", "all");
        mParam.addParam("format", format);
        if (content == null || "".equals(content)) {
            content = "#\u5206\u4eab\u56fe\u7247#";
        }
        mParam.addParam("content", content);
        mParam.addParam("clientip", Util.getLocalIPAddress(context));
        if (longitude != 0.0) {
            mParam.addParam("longitude", longitude);
        }
        if (latitude != 0.0) {
            mParam.addParam("latitude", latitude);
        }
        mParam.addParam("syncflag", syncflag);
        mParam.addParam("compatibleflag", compatibleflag);
        mParam.setBitmap(bm);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bm.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
        mParam.addParam("pic", baos.toByteArray());
        this.startRequest(context, SERVER_URL_ADDPIC, mParam, mCallBack, mTargetClass, "POST", resultType);
    }

    public void addPicUrl(Context context, String content, String format, double longitude, double latitude, String pic, int syncflag, int compatibleflag, HttpCallback mCallBack, Class<? extends BaseVO> mTargetClass, int resultType) {
        ReqParam mParam = new ReqParam();
        mParam.addParam("oauth_version", "2.a");
        mParam.addParam("oauth_consumer_key", Util.getSharePersistent(context, "CLIENT_ID"));
        mParam.addParam("openid", Util.getSharePersistent(context, "OPEN_ID"));
        mParam.addParam("scope", "all");
        mParam.addParam("format", format);
        mParam.addParam("content", content);
        mParam.addParam("clientip", Util.getLocalIPAddress(context));
        if (longitude != 0.0) {
            mParam.addParam("longitude", longitude);
        }
        if (latitude != 0.0) {
            mParam.addParam("latitude", latitude);
        }
        mParam.addParam("syncflag", syncflag);
        mParam.addParam("compatibleflag", compatibleflag);
        mParam.addParam("pic_url", pic);
        this.startRequest(context, SERVER_URL_ADDPICURL, mParam, mCallBack, mTargetClass, "POST", resultType);
    }

    public void reList(Context context, String format, int flag, String rootid, int pageflag, String pagetime, int reqnum, String twitterid, HttpCallback mCallBack, Class<? extends BaseVO> mTargetClass, int resultType) {
        ReqParam mParam = new ReqParam();
        mParam.addParam("oauth_version", "2.a");
        mParam.addParam("oauth_consumer_key", Util.getSharePersistent(context, "CLIENT_ID"));
        mParam.addParam("openid", Util.getSharePersistent(context, "OPEN_ID"));
        mParam.addParam("scope", "all");
        mParam.addParam("clientip", Util.getLocalIPAddress(context));
        mParam.addParam("format", format);
        mParam.addParam("flag", flag);
        mParam.addParam("rootid", rootid);
        mParam.addParam("pageflag", pageflag);
        mParam.addParam("pagetime", pagetime);
        mParam.addParam("reqnum", reqnum);
        mParam.addParam("twitterid", twitterid);
        this.startRequest(context, SERVER_URL_RLIST, mParam, mCallBack, mTargetClass, "GET", resultType);
    }
}

