/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.weibo.sdk.android.component.sso.tools;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;

public class Cryptor {
    public static final int QUOTIENT = 79764919;
    public static final int SALT_LEN = 2;
    public static final int ZERO_LEN = 7;
    private byte[] plain;
    private byte[] prePlain;
    private byte[] out;
    private int crypt;
    private int preCrypt;
    private int pos;
    private int padding;
    private byte[] key;
    private boolean header = true;
    private int contextStart;
    private Random random = new Random();

    public static byte[] MD5Hash(byte[] byteIn, int nLen) {
        byte[] byteArr = new byte[2];
        return byteArr;
    }

    public static int CRC32Hash(byte[] data) {
        int len = data.length;
        int result = -1;
        boolean index = false;
        int i = 0;
        while (i < len) {
            byte octet = data[i];
            int j = 0;
            while (j < 8) {
                result = (octet ^ result) >>> 31 == 1 ? result << 1 ^ 0x4C11DB7 : (result <<= 1);
                octet = (byte)(octet << 1);
                ++j;
            }
            ++i;
        }
        return ~result;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public static byte[] _4bytesEncryptAFrame(int data, byte[] key) {
        short z;
        short y;
        block3: {
            int n;
            int n2;
            int sum;
            int m_n4BytesScheduleDelta;
            short[] k;
            block2: {
                short[] v = new short[]{(short)(data & 0xFFFF), (short)(data >>> 16)};
                k = new short[]{(short)(key[1] << 8 | key[0]), (short)(key[3] << 8 | key[2]), (short)(key[5] << 8 | key[4]), (short)(key[7] << 8 | key[6])};
                m_n4BytesScheduleDelta = 12895;
                y = v[0];
                z = v[1];
                sum = 0;
                n2 = 32;
                if (!true) break block2;
                n = n2;
                n2 = (short)(n - 1);
                if (n <= 0) break block3;
            }
            do {
                sum = (short)(sum + m_n4BytesScheduleDelta);
                y = (short)(y + ((z << 4) + k[0] ^ z + sum ^ (z >> 5) + k[1]));
                z = (short)(z + ((y << 4) + k[2] ^ y + sum ^ (y >> 5) + k[3]));
                n = n2;
                n2 = (short)(n - 1);
            } while (n > 0);
        }
        byte[] result = new byte[]{(byte)(z >> 8), (byte)(z & 0xFF), (byte)(y >> 8), (byte)(y & 0xFF)};
        return result;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public static int _4bytesDecryptAFrame(long src, byte[] key) {
        short z;
        short y;
        short[] v;
        block3: {
            int n;
            short sum;
            int n2;
            int m_n4BytesScheduleDelta;
            short[] k;
            block2: {
                v = new short[]{(short)(src & 0xFFFFL), (short)(src >> 16)};
                k = new short[]{(short)(key[1] << 8 | key[0]), (short)(key[3] << 8 | key[2]), (short)(key[5] << 8 | key[4]), (short)(key[7] << 8 | key[6])};
                m_n4BytesScheduleDelta = 12895;
                n2 = 32;
                y = v[0];
                z = v[1];
                sum = (short)(m_n4BytesScheduleDelta << 5);
                if (!true) break block2;
                n = n2;
                n2 = (short)(n - 1);
                if (n <= 0) break block3;
            }
            do {
                z = (short)(z - ((y << 4) + k[2] ^ y + sum ^ (y >> 5) + k[3]));
                y = (short)(y - ((z << 4) + k[0] ^ z + sum ^ (z >> 5) + k[1]));
                sum = (short)(sum - m_n4BytesScheduleDelta);
                n = n2;
                n2 = (short)(n - 1);
            } while (n > 0);
        }
        v[0] = y;
        v[1] = z;
        return v[1] << 16 | v[0] & 0xFFFF;
    }

    public static long getUnsignedInt(byte[] in, int offset, int len) {
        long ret = 0L;
        int end = 0;
        end = len > 8 ? offset + 8 : offset + len;
        int i = offset;
        while (i < end) {
            ret <<= 8;
            ret |= (long)(in[i] & 0xFF);
            ++i;
        }
        return ret & 0xFFFFFFFFL | ret >>> 32;
    }

    public byte[] decrypt(byte[] in, int offset, int len, byte[] key) {
        this.preCrypt = 0;
        this.crypt = 0;
        this.key = key;
        byte[] m = new byte[offset + 8];
        if (len % 8 != 0 || len < 16) {
            return null;
        }
        this.prePlain = this.decipher(in, offset);
        this.pos = this.prePlain[0] & 7;
        int count = len - this.pos - 10;
        if (count < 0) {
            return null;
        }
        int i = offset;
        while (i < m.length) {
            m[i] = 0;
            ++i;
        }
        this.out = new byte[count];
        this.preCrypt = 0;
        this.crypt = 8;
        this.contextStart = 8;
        ++this.pos;
        this.padding = 1;
        while (this.padding <= 2) {
            if (this.pos < 8) {
                ++this.pos;
                ++this.padding;
            }
            if (this.pos != 8) continue;
            m = in;
            if (this.decrypt8Bytes(in, offset, len)) continue;
            return null;
        }
        i = 0;
        while (count != 0) {
            if (this.pos < 8) {
                this.out[i] = (byte)(m[offset + this.preCrypt + this.pos] ^ this.prePlain[this.pos]);
                ++i;
                --count;
                ++this.pos;
            }
            if (this.pos != 8) continue;
            m = in;
            this.preCrypt = this.crypt - 8;
            if (this.decrypt8Bytes(in, offset, len)) continue;
            return null;
        }
        this.padding = 1;
        while (this.padding < 8) {
            if (this.pos < 8) {
                if ((m[offset + this.preCrypt + this.pos] ^ this.prePlain[this.pos]) != 0) {
                    return null;
                }
                ++this.pos;
            }
            if (this.pos == 8) {
                m = in;
                this.preCrypt = this.crypt;
                if (!this.decrypt8Bytes(in, offset, len)) {
                    return null;
                }
            }
            ++this.padding;
        }
        return this.out;
    }

    public byte[] decrypt(byte[] in, byte[] key) {
        return this.decrypt(in, 0, in.length, key);
    }

    public byte[] encrypt(byte[] in, int offset, int len, byte[] key) {
        this.plain = new byte[8];
        this.prePlain = new byte[8];
        this.pos = 1;
        this.padding = 0;
        this.preCrypt = 0;
        this.crypt = 0;
        this.key = key;
        this.header = true;
        this.pos = (len + 10) % 8;
        if (this.pos != 0) {
            this.pos = 8 - this.pos;
        }
        this.out = new byte[len + this.pos + 10];
        this.plain[0] = (byte)(this.rand() & 0xF8 | this.pos);
        int i = 1;
        while (i <= this.pos) {
            this.plain[i] = (byte)(this.rand() & 0xFF);
            ++i;
        }
        ++this.pos;
        i = 0;
        while (i < 8) {
            this.prePlain[i] = 0;
            ++i;
        }
        this.padding = 1;
        while (this.padding <= 2) {
            if (this.pos < 8) {
                this.plain[this.pos++] = (byte)(this.rand() & 0xFF);
                ++this.padding;
            }
            if (this.pos != 8) continue;
            this.encrypt8Bytes();
        }
        i = offset;
        while (len > 0) {
            if (this.pos < 8) {
                this.plain[this.pos++] = in[i++];
                --len;
            }
            if (this.pos != 8) continue;
            this.encrypt8Bytes();
        }
        this.padding = 1;
        while (this.padding <= 7) {
            if (this.pos < 8) {
                this.plain[this.pos++] = 0;
                ++this.padding;
            }
            if (this.pos != 8) continue;
            this.encrypt8Bytes();
        }
        return this.out;
    }

    public byte[] encrypt(byte[] in, byte[] key) {
        return this.encrypt(in, 0, in.length, key);
    }

    private byte[] encipher(byte[] in) {
        try {
            int loop = 16;
            long y = Cryptor.getUnsignedInt(in, 0, 4);
            long z = Cryptor.getUnsignedInt(in, 4, 4);
            long a = Cryptor.getUnsignedInt(this.key, 0, 4);
            long b = Cryptor.getUnsignedInt(this.key, 4, 4);
            long c = Cryptor.getUnsignedInt(this.key, 8, 4);
            long d = Cryptor.getUnsignedInt(this.key, 12, 4);
            long sum = 0L;
            long delta = -1640531527L;
            delta &= 0xFFFFFFFFL;
            while (loop-- > 0) {
                sum += delta;
                y += (z << 4) + a ^ z + (sum &= 0xFFFFFFFFL) ^ (z >>> 5) + b;
                z += ((y &= 0xFFFFFFFFL) << 4) + c ^ y + sum ^ (y >>> 5) + d;
                z &= 0xFFFFFFFFL;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(8);
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt((int)y);
            dos.writeInt((int)z);
            dos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    private byte[] decipher(byte[] in, int offset) {
        try {
            int loop = 16;
            long y = Cryptor.getUnsignedInt(in, offset, 4);
            long z = Cryptor.getUnsignedInt(in, offset + 4, 4);
            long a = Cryptor.getUnsignedInt(this.key, 0, 4);
            long b = Cryptor.getUnsignedInt(this.key, 4, 4);
            long c = Cryptor.getUnsignedInt(this.key, 8, 4);
            long d = Cryptor.getUnsignedInt(this.key, 12, 4);
            long sum = -478700656L;
            sum &= 0xFFFFFFFFL;
            long delta = -1640531527L;
            delta &= 0xFFFFFFFFL;
            while (loop-- > 0) {
                z -= (y << 4) + c ^ y + sum ^ (y >>> 5) + d;
                y -= ((z &= 0xFFFFFFFFL) << 4) + a ^ z + sum ^ (z >>> 5) + b;
                y &= 0xFFFFFFFFL;
                sum -= delta;
                sum &= 0xFFFFFFFFL;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(8);
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt((int)y);
            dos.writeInt((int)z);
            dos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    private byte[] decipher(byte[] in) {
        return this.decipher(in, 0);
    }

    private void encrypt8Bytes() {
        this.pos = 0;
        while (this.pos < 8) {
            if (this.header) {
                int n = this.pos;
                this.plain[n] = (byte)(this.plain[n] ^ this.prePlain[this.pos]);
            } else {
                int n = this.pos;
                this.plain[n] = (byte)(this.plain[n] ^ this.out[this.preCrypt + this.pos]);
            }
            ++this.pos;
        }
        byte[] crypted = this.encipher(this.plain);
        System.arraycopy(crypted, 0, this.out, this.crypt, 8);
        this.pos = 0;
        while (this.pos < 8) {
            int n = this.crypt + this.pos;
            this.out[n] = (byte)(this.out[n] ^ this.prePlain[this.pos]);
            ++this.pos;
        }
        System.arraycopy(this.plain, 0, this.prePlain, 0, 8);
        this.preCrypt = this.crypt;
        this.crypt += 8;
        this.pos = 0;
        this.header = false;
    }

    private boolean decrypt8Bytes(byte[] in, int offset, int len) {
        this.pos = 0;
        while (this.pos < 8) {
            if (this.contextStart + this.pos >= len) {
                return true;
            }
            int n = this.pos;
            this.prePlain[n] = (byte)(this.prePlain[n] ^ in[offset + this.crypt + this.pos]);
            ++this.pos;
        }
        this.prePlain = this.decipher(this.prePlain);
        if (this.prePlain == null) {
            return false;
        }
        this.contextStart += 8;
        this.crypt += 8;
        this.pos = 0;
        return true;
    }

    private int rand() {
        return this.random.nextInt();
    }

    public byte[] decrypt(byte[] in, byte[] key, int length) {
        byte[] data = this.decrypt(in, 0, in.length, key);
        return data == null ? this.getRandomByte(length) : data;
    }

    private byte[] getRandomByte(int length) {
        byte[] data = new byte[length];
        this.random.nextBytes(data);
        return data;
    }
}

