/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.weibo.sdk.android.component.sso;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.net.Uri;
import com.tencent.weibo.sdk.android.component.sso.AuthReceiver;
import com.tencent.weibo.sdk.android.component.sso.OnAuthListener;
import com.tencent.weibo.sdk.android.component.sso.tools.Base64;
import com.tencent.weibo.sdk.android.component.sso.tools.Cryptor;
import com.tencent.weibo.sdk.android.component.sso.tools.MD5Tools;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class AuthHelper {
    static final String WEIBO_PACKAGE = "com.tencent.WBlog";
    static final int SUPPORT_WEIBO_MIN_VERSION = 44;
    static final String WEIBO_AUTH_URL = "TencentAuth://weibo";
    static final String ENCRYPT_KEY = "&-*)Wb5_U,[^!9'+";
    static final byte SDK_VERSION = 1;
    static final int WEIBO_VALIDATE_OK = 0;
    static final int ERROR_WEIBO_UPGRADE_NEEDED = -1;
    static final int ERROR_WEIBO_INSTALL_NEEDED = -2;
    protected static long appid;
    protected static String appSecret;
    protected static OnAuthListener listener;
    private static AuthReceiver mReceiver;

    static {
        mReceiver = new AuthReceiver();
    }

    public static final void register(Context context, long appid, String secret, OnAuthListener listener) {
        AuthHelper.appid = appid;
        appSecret = secret;
        AuthHelper.listener = listener;
        IntentFilter filter = new IntentFilter("com.tencent.sso.AUTH");
        filter.addCategory("android.intent.category.DEFAULT");
        context.registerReceiver((BroadcastReceiver)mReceiver, filter);
    }

    public static final void unregister(Context context) {
        context.unregisterReceiver((BroadcastReceiver)mReceiver);
    }

    public static final boolean auth(Context context, String reserver) {
        int checkResult = AuthHelper.validateWeiboApp(context);
        if (checkResult == 0) {
            long current = System.currentTimeMillis() / 1000L;
            long nonce = Math.abs(new Random().nextInt());
            String apkSignature = AuthHelper.getApkSignature(context);
            byte[] signature = AuthHelper.generateSignature(appid, appSecret, current, nonce);
            if (signature == null) {
                if (listener != null) {
                    listener.onAuthFail(-1, "");
                }
                return false;
            }
            signature = AuthHelper.encypt(signature);
            String packageName = context.getPackageName();
            PackageManager packageManager = context.getPackageManager();
            String thisAppName = "";
            try {
                ApplicationInfo thisApp = packageManager.getApplicationInfo(packageName, 0);
                thisAppName = packageManager.getApplicationLabel(thisApp).toString();
            }
            catch (PackageManager.NameNotFoundException thisApp) {
                // empty catch block
            }
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)WEIBO_AUTH_URL));
            intent.putExtra("com.tencent.sso.APP_ID", appid);
            intent.putExtra("com.tencent.sso.TIMESTAMP", current);
            intent.putExtra("com.tencent.sso.NONCE", nonce);
            intent.putExtra("com.tencent.sso.SDK_VERSION", (byte)1);
            intent.putExtra("com.tencent.sso.PACKAGE_NAME", packageName);
            intent.putExtra("com.tencent.sso.ICON_MD5", apkSignature);
            intent.putExtra("com.tencent.sso.APP_NAME", thisAppName);
            intent.putExtra("com.tencent.sso.SIGNATURE", signature);
            intent.putExtra("com.tencent.sso.RESERVER", reserver);
            context.startActivity(intent);
            return true;
        }
        if (checkResult == -1) {
            if (listener != null) {
                listener.onWeiboVersionMisMatch();
            }
            return false;
        }
        if (checkResult == -2) {
            if (listener != null) {
                listener.onWeiBoNotInstalled();
            }
            return false;
        }
        return false;
    }

    private static int validateWeiboApp(Context context) {
        PackageManager packageManager = context.getPackageManager();
        try {
            Intent intent;
            List list;
            PackageInfo pi = packageManager.getPackageInfo(WEIBO_PACKAGE, 16);
            if (pi != null && pi.versionCode >= 44 && (list = packageManager.queryIntentActivities(intent = new Intent("android.intent.action.VIEW", Uri.parse((String)WEIBO_AUTH_URL)), 65536)).size() > 0) {
                return 0;
            }
            return -1;
        }
        catch (PackageManager.NameNotFoundException e) {
            return -2;
        }
    }

    private static byte[] generateSignature(long appid, String appSecret, long current, long nonce) {
        byte[] signature = null;
        StringBuffer sb = new StringBuffer();
        sb.append(appid);
        sb.append(current);
        sb.append(nonce);
        sb.append(1);
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            SecretKeySpec secret = new SecretKeySpec(appSecret.getBytes("UTF-8"), mac.getAlgorithm());
            mac.init(secret);
            signature = mac.doFinal(sb.toString().getBytes("UTF-8"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        signature = Base64.encode(signature).getBytes();
        return signature;
    }

    private static byte[] encypt(byte[] signature) {
        return new Cryptor().encrypt(signature, ENCRYPT_KEY.getBytes());
    }

    private static String getApkSignature(Context context) {
        try {
            PackageInfo pi = context.getPackageManager().getPackageInfo(context.getPackageName(), 64);
            Signature[] signs = pi.signatures;
            Signature sign = signs[0];
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(sign.toByteArray()));
            StringBuffer sb = new StringBuffer();
            sb.append(cert.getPublicKey().toString());
            sb.append(cert.getSerialNumber().toString());
            return MD5Tools.toMD5(sb.toString());
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }
}

