/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.weibo.sdk.android.component;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.text.Editable;
import android.text.TextWatcher;
import android.text.method.ScrollingMovementMethod;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Gallery;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.tencent.weibo.sdk.android.api.WeiboAPI;
import com.tencent.weibo.sdk.android.api.adapter.GalleryAdapter;
import com.tencent.weibo.sdk.android.api.util.BackGroudSeletor;
import com.tencent.weibo.sdk.android.api.util.Util;
import com.tencent.weibo.sdk.android.model.AccountModel;
import com.tencent.weibo.sdk.android.model.ImageInfo;
import com.tencent.weibo.sdk.android.model.ModelResult;
import com.tencent.weibo.sdk.android.network.HttpCallback;
import java.util.ArrayList;
import org.json.JSONObject;

public class ReAddActivity
extends Activity {
    private LinearLayout layout = null;
    private EditText content = null;
    private TextView textView_num;
    private String contentStr = "";
    private String videoPath = "";
    private String picPath = "";
    private String musicPath = "";
    private String musicTitle = "";
    private String musicAuthor = "";
    private Handler mHandler = null;
    private Gallery gallery;
    private WeiboAPI api;
    private String accessToken;
    private ArrayList<ImageInfo> imageList = new ArrayList();
    private PopupWindow loadingWindow = null;
    private ProgressBar progressBar = null;
    private RelativeLayout galleryLayout = null;
    private HttpCallback mCallBack = new HttpCallback(){

        public void onResult(Object object) {
            ModelResult result = (ModelResult)object;
            if (result.isExpires()) {
                Toast.makeText((Context)ReAddActivity.this, (CharSequence)result.getError_message(), (int)0).show();
            } else if (result.isSuccess()) {
                Toast.makeText((Context)ReAddActivity.this, (CharSequence)"\u8f6c\u64ad\u6210\u529f", (int)0).show();
                ReAddActivity.this.finish();
            } else {
                Toast.makeText((Context)ReAddActivity.this, (CharSequence)result.getError_message(), (int)0).show();
                ReAddActivity.this.finish();
            }
        }
    };
    private HttpCallback videoCallBack = new HttpCallback(){

        public void onResult(Object object) {
            ModelResult result = (ModelResult)object;
            if (result != null) {
                if (!result.isExpires() && result.isSuccess()) {
                    try {
                        JSONObject json = (JSONObject)result.getObj();
                        JSONObject data = json.getJSONObject("data");
                        ImageInfo info1 = new ImageInfo();
                        info1.setImagePath(data.getString("minipic"));
                        info1.setImageName(data.getString("title"));
                        info1.setPlayPath(data.getString("real"));
                        ReAddActivity.this.imageList.add(info1);
                        GalleryAdapter adapter = new GalleryAdapter(ReAddActivity.this.getApplicationContext(), ReAddActivity.this.loadingWindow, ReAddActivity.this.imageList);
                        ReAddActivity.this.gallery.setAdapter((SpinnerAdapter)adapter);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else if (ReAddActivity.this.loadingWindow != null && ReAddActivity.this.loadingWindow.isShowing()) {
                ReAddActivity.this.loadingWindow.dismiss();
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().setFlags(1024, 1024);
        this.requestWindowFeature(1);
        DisplayMetrics displaysMetrics = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(displaysMetrics);
        String pix = String.valueOf(displaysMetrics.widthPixels) + "x" + displaysMetrics.heightPixels;
        BackGroudSeletor.setPix((String)pix);
        this.accessToken = Util.getSharePersistent((Context)this.getApplicationContext(), (String)"ACCESS_TOKEN");
        if (this.accessToken == null || "".equals(this.accessToken)) {
            Toast.makeText((Context)this, (CharSequence)"\u8bf7\u5148\u6388\u6743", (int)0).show();
            this.finish();
            return;
        }
        Intent intent = this.getIntent();
        Bundle bundle = intent.getExtras();
        if (bundle != null) {
            this.contentStr = bundle.getString("content");
            this.videoPath = bundle.getString("video_url");
            this.picPath = bundle.getString("pic_url");
            this.musicPath = bundle.getString("music_url");
            this.musicTitle = bundle.getString("music_title");
            this.musicAuthor = bundle.getString("music_author");
        }
        AccountModel account = new AccountModel(this.accessToken);
        this.api = new WeiboAPI(account);
        this.setContentView(this.initLayout());
    }

    public View initLayout() {
        RelativeLayout.LayoutParams fillParams = new RelativeLayout.LayoutParams(-1, -1);
        RelativeLayout.LayoutParams fillWrapParams = new RelativeLayout.LayoutParams(-1, -2);
        RelativeLayout.LayoutParams wrapParams = new RelativeLayout.LayoutParams(-2, -2);
        this.layout = new LinearLayout((Context)this);
        this.layout.setLayoutParams((ViewGroup.LayoutParams)fillParams);
        this.layout.setOrientation(1);
        this.layout.setBackgroundDrawable(BackGroudSeletor.getdrawble((String)"readd_bg", (Context)this.getApplication()));
        RelativeLayout cannelLayout = new RelativeLayout((Context)this);
        cannelLayout.setLayoutParams((ViewGroup.LayoutParams)fillWrapParams);
        cannelLayout.setBackgroundDrawable(BackGroudSeletor.getdrawble((String)"up_bg2x", (Context)this.getApplication()));
        cannelLayout.setGravity(0);
        Button returnBtn = new Button((Context)this);
        String[] pngArray = new String[]{"quxiao_btn2x", "quxiao_btn_hover"};
        returnBtn.setBackgroundDrawable((Drawable)BackGroudSeletor.createBgByImageIds((String[])pngArray, (Context)this.getApplication()));
        returnBtn.setText((CharSequence)"\u53d6\u6d88");
        wrapParams.addRule(9, -1);
        wrapParams.addRule(15, -1);
        wrapParams.topMargin = 10;
        wrapParams.leftMargin = 10;
        wrapParams.bottomMargin = 10;
        returnBtn.setLayoutParams((ViewGroup.LayoutParams)wrapParams);
        returnBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ReAddActivity.this.finish();
            }
        });
        cannelLayout.addView((View)returnBtn);
        TextView title = new TextView((Context)this);
        title.setText((CharSequence)"\u8f6c\u64ad");
        title.setTextColor(-1);
        title.setTextSize(24.0f);
        RelativeLayout.LayoutParams titleParams = new RelativeLayout.LayoutParams(-2, -2);
        titleParams.addRule(13, -1);
        title.setLayoutParams((ViewGroup.LayoutParams)titleParams);
        cannelLayout.addView((View)title);
        Button reAddBtn = new Button((Context)this);
        pngArray = new String[]{"sent_btn2x", "sent_btn_hover"};
        reAddBtn.setBackgroundDrawable((Drawable)BackGroudSeletor.createBgByImageIds((String[])pngArray, (Context)this.getApplication()));
        reAddBtn.setText((CharSequence)"\u8f6c\u64ad");
        RelativeLayout.LayoutParams wrapParamsRight = new RelativeLayout.LayoutParams(-2, -2);
        wrapParamsRight.addRule(11, -1);
        wrapParamsRight.addRule(15, -1);
        wrapParamsRight.topMargin = 10;
        wrapParamsRight.rightMargin = 10;
        wrapParamsRight.bottomMargin = 10;
        reAddBtn.setLayoutParams((ViewGroup.LayoutParams)wrapParamsRight);
        reAddBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ReAddActivity.this.reAddWeibo();
            }
        });
        cannelLayout.addView((View)reAddBtn);
        RelativeLayout reAddLayout = new RelativeLayout((Context)this);
        RelativeLayout.LayoutParams readdParams = new RelativeLayout.LayoutParams(-1, 240);
        reAddLayout.setLayoutParams((ViewGroup.LayoutParams)readdParams);
        RelativeLayout contentLayout = new RelativeLayout((Context)this);
        RelativeLayout.LayoutParams contentParams = new RelativeLayout.LayoutParams(440, -1);
        contentParams.addRule(13);
        contentParams.topMargin = 50;
        contentLayout.setLayoutParams((ViewGroup.LayoutParams)contentParams);
        contentLayout.setBackgroundDrawable(BackGroudSeletor.getdrawble((String)"input_bg", (Context)this.getApplication()));
        this.textView_num = new TextView((Context)this);
        this.textView_num.setText((CharSequence)(this.contentStr == null ? "140" : String.valueOf(140 - this.contentStr.length())));
        this.textView_num.setTextColor(Color.parseColor((String)"#999999"));
        this.textView_num.setGravity(5);
        this.textView_num.setTextSize(18.0f);
        RelativeLayout.LayoutParams params_space = new RelativeLayout.LayoutParams(-2, -2);
        params_space.addRule(12, -1);
        params_space.addRule(11, -1);
        params_space.rightMargin = 10;
        this.textView_num.setLayoutParams((ViewGroup.LayoutParams)params_space);
        contentLayout.addView((View)this.textView_num);
        this.content = new EditText((Context)this);
        contentParams = new RelativeLayout.LayoutParams(-1, -2);
        contentParams.addRule(14);
        contentParams.addRule(10);
        this.content.setLayoutParams((ViewGroup.LayoutParams)contentParams);
        this.content.setMaxLines(4);
        this.content.setMinLines(4);
        this.content.setScrollbarFadingEnabled(true);
        this.content.setGravity(48);
        this.content.setMovementMethod(ScrollingMovementMethod.getInstance());
        this.content.setText((CharSequence)this.contentStr);
        this.content.setSelection(this.contentStr.length());
        this.content.setBackgroundDrawable(null);
        this.content.addTextChangedListener(new TextWatcher(){
            private CharSequence temp;
            private int selectionStart;
            private int selectionEnd;

            public void afterTextChanged(Editable arg0) {
                this.selectionStart = ReAddActivity.this.content.getSelectionStart();
                this.selectionEnd = ReAddActivity.this.content.getSelectionEnd();
                if (this.temp.length() > 140) {
                    Toast.makeText((Context)ReAddActivity.this, (CharSequence)"\u6700\u591a\u53ef\u8f93\u5165140\u5b57\u7b26", (int)0).show();
                    arg0.delete(this.selectionStart - 1, this.selectionEnd);
                    int tempSelection = this.selectionStart;
                    ReAddActivity.this.content.setText((CharSequence)arg0);
                    ReAddActivity.this.content.setSelection(tempSelection);
                } else {
                    ReAddActivity.this.textView_num.setText((CharSequence)String.valueOf(140 - arg0.length()));
                }
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                this.temp = s;
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        contentLayout.addView((View)this.content);
        reAddLayout.addView((View)contentLayout);
        this.galleryLayout = new RelativeLayout((Context)this);
        this.galleryLayout.setLayoutParams((ViewGroup.LayoutParams)fillParams);
        this.gallery = new Gallery((Context)this);
        RelativeLayout.LayoutParams galleryParams = new RelativeLayout.LayoutParams(303, 203);
        galleryParams.addRule(14, -1);
        galleryParams.addRule(10, -1);
        galleryParams.topMargin = 50;
        this.gallery.setLayoutParams((ViewGroup.LayoutParams)galleryParams);
        this.gallery.setBackgroundDrawable(BackGroudSeletor.getdrawble((String)"pic_biankuang2x", (Context)this.getApplication()));
        this.requestForGallery();
        this.galleryLayout.addView((View)this.gallery);
        this.layout.addView((View)cannelLayout);
        this.layout.addView((View)reAddLayout);
        if (this.picPath != null && !"".equals(this.picPath) && this.videoPath != null && !"".equals(this.videoPath)) {
            this.layout.addView((View)this.galleryLayout);
        }
        return this.layout;
    }

    protected void reAddWeibo() {
        this.contentStr = this.content.getText().toString();
        this.api.reAddWeibo(this.getApplicationContext(), this.contentStr, this.picPath, this.videoPath, this.musicPath, this.musicTitle, this.musicAuthor, this.mCallBack, null, 4);
    }

    public ArrayList<ImageInfo> requestForGallery() {
        if (this.picPath != null) {
            ImageInfo info2 = new ImageInfo();
            info2.setImagePath(this.picPath);
            this.imageList.add(info2);
        }
        if (this.videoPath != null) {
            ImageInfo info1 = new ImageInfo();
            this.api.getVideoInfo(this.getApplicationContext(), this.videoPath, this.videoCallBack, null, 4);
        }
        return this.imageList;
    }
}

