/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.weibo.sdk.android.component;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.tencent.weibo.sdk.android.api.util.BackGroudSeletor;
import com.tencent.weibo.sdk.android.api.util.Util;

public class Authorize
extends Activity {
    WebView webView;
    String _url;
    String _fileName;
    public static int WEBVIEWSTATE_1 = 0;
    int webview_state = 0;
    String path;
    Dialog _dialog;
    public static final int ALERT_DOWNLOAD = 0;
    public static final int ALERT_FAV = 1;
    public static final int PROGRESS_H = 3;
    public static final int ALERT_NETWORK = 4;
    private ProgressDialog dialog;
    private LinearLayout layout = null;
    private String redirectUri = null;
    private String clientId = null;
    private boolean isShow = false;
    Handler handle = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 100: {
                    Authorize.this.showDialog(4);
                }
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (!Util.isNetworkAvailable((Activity)this)) {
            this.showDialog(4);
        } else {
            DisplayMetrics displaysMetrics = new DisplayMetrics();
            this.getWindowManager().getDefaultDisplay().getMetrics(displaysMetrics);
            String pix = String.valueOf(displaysMetrics.widthPixels) + "x" + displaysMetrics.heightPixels;
            BackGroudSeletor.setPix((String)pix);
            try {
                this.clientId = Util.getConfig().getProperty("APP_KEY");
                this.redirectUri = Util.getConfig().getProperty("REDIRECT_URI");
                if (this.clientId == null || "".equals(this.clientId) || this.redirectUri == null || "".equals(this.redirectUri)) {
                    Toast.makeText((Context)this, (CharSequence)"\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u586b\u5199\u76f8\u5e94\u7684\u4fe1\u606f", (int)0).show();
                }
                Log.d((String)"redirectUri", (String)this.redirectUri);
                this.getWindow().setFlags(1024, 1024);
                this.requestWindowFeature(1);
                int state = (int)Math.random() * 1000 + 111;
                this.path = "https://open.t.qq.com/cgi-bin/oauth2/authorize?client_id=" + this.clientId + "&response_type=token&redirect_uri=" + this.redirectUri + "&state=" + state;
                this.initLayout();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void initLayout() {
        RelativeLayout.LayoutParams fillParams = new RelativeLayout.LayoutParams(-1, -1);
        RelativeLayout.LayoutParams fillWrapParams = new RelativeLayout.LayoutParams(-1, -2);
        RelativeLayout.LayoutParams wrapParams = new RelativeLayout.LayoutParams(-2, -2);
        this.dialog = new ProgressDialog((Context)this);
        this.dialog.setProgressStyle(0);
        this.dialog.requestWindowFeature(1);
        this.dialog.setMessage((CharSequence)"\u8bf7\u7a0d\u540e...");
        this.dialog.setIndeterminate(false);
        this.dialog.setCancelable(false);
        this.dialog.show();
        this.layout = new LinearLayout((Context)this);
        this.layout.setLayoutParams((ViewGroup.LayoutParams)fillParams);
        this.layout.setOrientation(1);
        RelativeLayout cannelLayout = new RelativeLayout((Context)this);
        cannelLayout.setLayoutParams((ViewGroup.LayoutParams)fillWrapParams);
        cannelLayout.setBackgroundDrawable(BackGroudSeletor.getdrawble((String)"up_bg2x", (Context)this.getApplication()));
        cannelLayout.setGravity(0);
        Button returnBtn = new Button((Context)this);
        String[] pngArray = new String[]{"quxiao_btn2x", "quxiao_btn_hover"};
        returnBtn.setBackgroundDrawable((Drawable)BackGroudSeletor.createBgByImageIds((String[])pngArray, (Context)this.getApplication()));
        returnBtn.setText((CharSequence)"\u53d6\u6d88");
        wrapParams.addRule(9, -1);
        wrapParams.addRule(15, -1);
        wrapParams.leftMargin = 10;
        wrapParams.topMargin = 10;
        wrapParams.bottomMargin = 10;
        returnBtn.setLayoutParams((ViewGroup.LayoutParams)wrapParams);
        returnBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Authorize.this.finish();
            }
        });
        cannelLayout.addView((View)returnBtn);
        TextView title = new TextView((Context)this);
        title.setText((CharSequence)"\u6388\u6743");
        title.setTextColor(-1);
        title.setTextSize(24.0f);
        RelativeLayout.LayoutParams titleParams = new RelativeLayout.LayoutParams(-2, -2);
        titleParams.addRule(13, -1);
        title.setLayoutParams((ViewGroup.LayoutParams)titleParams);
        cannelLayout.addView((View)title);
        this.layout.addView((View)cannelLayout);
        this.webView = new WebView((Context)this);
        LinearLayout.LayoutParams wvParams = new LinearLayout.LayoutParams(-2, -2);
        this.webView.setLayoutParams((ViewGroup.LayoutParams)wvParams);
        WebSettings webSettings = this.webView.getSettings();
        this.webView.setVerticalScrollBarEnabled(false);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setUseWideViewPort(true);
        webSettings.setLoadWithOverviewMode(false);
        this.webView.loadUrl(this.path);
        this.webView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                super.onProgressChanged(view, newProgress);
                Log.d((String)"newProgress", (String)(String.valueOf(newProgress) + ".."));
            }
        });
        this.webView.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                Log.d((String)"backurl", (String)url);
                if (url.indexOf("access_token") != -1 && !Authorize.this.isShow) {
                    Authorize.this.jumpResultParser(url);
                }
                if (Authorize.this.dialog != null && Authorize.this.dialog.isShowing()) {
                    Authorize.this.dialog.cancel();
                }
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (url.indexOf("access_token") != -1 && !Authorize.this.isShow) {
                    Authorize.this.jumpResultParser(url);
                }
                return false;
            }
        });
        this.layout.addView((View)this.webView);
        this.setContentView((View)this.layout);
    }

    public void jumpResultParser(String result) {
        String resultParam = result.split("#")[1];
        String[] params = resultParam.split("&");
        String accessToken = params[0].split("=")[1];
        String expiresIn = params[1].split("=")[1];
        String openid = params[2].split("=")[1];
        String openkey = params[3].split("=")[1];
        String refreshToken = params[4].split("=")[1];
        String state = params[5].split("=")[1];
        String name = params[6].split("=")[1];
        String nick = params[7].split("=")[1];
        Context context = this.getApplicationContext();
        if (accessToken != null && !"".equals(accessToken)) {
            Util.saveSharePersistent((Context)context, (String)"ACCESS_TOKEN", (String)accessToken);
            Util.saveSharePersistent((Context)context, (String)"EXPIRES_IN", (String)expiresIn);
            Util.saveSharePersistent((Context)context, (String)"OPEN_ID", (String)openid);
            Util.saveSharePersistent((Context)context, (String)"OPEN_KEY", (String)openkey);
            Util.saveSharePersistent((Context)context, (String)"REFRESH_TOKEN", (String)refreshToken);
            Util.saveSharePersistent((Context)context, (String)"NAME", (String)name);
            Util.saveSharePersistent((Context)context, (String)"NICK", (String)nick);
            Util.saveSharePersistent((Context)context, (String)"CLIENT_ID", (String)this.clientId);
            Util.saveSharePersistent((Context)context, (String)"AUTHORIZETIME", (String)String.valueOf(System.currentTimeMillis() / 1000L));
            Toast.makeText((Context)this, (CharSequence)"\u6388\u6743\u6210\u529f", (int)0).show();
            this.finish();
            this.isShow = true;
        }
    }

    protected Dialog onCreateDialog(int id) {
        switch (id) {
            case 3: {
                this._dialog = new ProgressDialog((Context)this);
                ((ProgressDialog)this._dialog).setMessage((CharSequence)"\u52a0\u8f7d\u4e2d...");
                break;
            }
            case 4: {
                AlertDialog.Builder builder2 = new AlertDialog.Builder((Context)this);
                builder2.setTitle((CharSequence)"\u7f51\u7edc\u8fde\u63a5\u5f02\u5e38\uff0c\u662f\u5426\u91cd\u65b0\u8fde\u63a5\uff1f");
                builder2.setPositiveButton((CharSequence)"\u662f", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        if (Util.isNetworkAvailable((Activity)Authorize.this)) {
                            Authorize.this.webView.loadUrl(Authorize.this.path);
                        } else {
                            Message msg = Message.obtain();
                            msg.what = 100;
                            Authorize.this.handle.sendMessage(msg);
                        }
                    }
                });
                builder2.setNegativeButton((CharSequence)"\u5426", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        Authorize.this.finish();
                    }
                });
                this._dialog = builder2.create();
            }
        }
        return this._dialog;
    }
}

