/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.utils;

import android.app.Activity;
import android.app.Dialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Bundle;
import android.provider.MediaStore;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.umeng.socialize.common.ResContainer;
import com.umeng.socialize.common.SocializeConstants;
import com.umeng.socialize.utils.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class SocializeUtils {
    protected static final String TAG = "SocializeUtils";
    private static final String[][] MIME_MapTable = new String[][]{{".3gp", "video/3gpp"}, {".apk", "application/vnd.android.package-archive"}, {".asf", "video/x-ms-asf"}, {".avi", "video/x-msvideo"}, {".bin", "application/octet-stream"}, {".bmp", "image/bmp"}, {".c", "text/plain"}, {".class", "application/octet-stream"}, {".conf", "text/plain"}, {".cpp", "text/plain"}, {".doc", "application/msword"}, {".docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document"}, {".xls", "application/vnd.ms-excel"}, {".xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"}, {".exe", "application/octet-stream"}, {".gif", "image/gif"}, {".gtar", "application/x-gtar"}, {".gz", "application/x-gzip"}, {".h", "text/plain"}, {".htm", "text/html"}, {".html", "text/html"}, {".jar", "application/java-archive"}, {".java", "text/plain"}, {".jpeg", "image/jpeg"}, {".jpg", "image/jpeg"}, {".js", "application/x-javascript"}, {".log", "text/plain"}, {".m3u", "audio/x-mpegurl"}, {".m4a", "audio/mp4a-latm"}, {".m4b", "audio/mp4a-latm"}, {".m4p", "audio/mp4a-latm"}, {".m4u", "video/vnd.mpegurl"}, {".m4v", "video/x-m4v"}, {".mov", "video/quicktime"}, {".mp2", "audio/x-mpeg"}, {".mp3", "audio/x-mpeg"}, {".mp4", "video/mp4"}, {".mpc", "application/vnd.mpohun.certificate"}, {".mpe", "video/mpeg"}, {".mpeg", "video/mpeg"}, {".mpg", "video/mpeg"}, {".mpg4", "video/mp4"}, {".mpga", "audio/mpeg"}, {".msg", "application/vnd.ms-outlook"}, {".ogg", "audio/ogg"}, {".pdf", "application/pdf"}, {".png", "image/png"}, {".pps", "application/vnd.ms-powerpoint"}, {".ppt", "application/vnd.ms-powerpoint"}, {".pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation"}, {".prop", "text/plain"}, {".rc", "text/plain"}, {".rmvb", "audio/x-pn-realaudio"}, {".rtf", "application/rtf"}, {".sh", "text/plain"}, {".tar", "application/x-tar"}, {".tgz", "application/x-compressed"}, {".txt", "text/plain"}, {".wav", "audio/x-wav"}, {".wma", "audio/x-ms-wma"}, {".wmv", "audio/x-ms-wmv"}, {".wps", "application/vnd.ms-works"}, {".xml", "text/plain"}, {".z", "application/x-compress"}, {".zip", "application/x-zip-compressed"}, {"", "*/*"}};
    public static Set<Uri> deleteUris = new HashSet<Uri>();
    private static Pattern mDoubleByte_Pattern = null;
    private static int smDip = 0;

    public static String getAppkey(Context context) {
        String string = SocializeConstants.APPKEY;
        if (TextUtils.isEmpty((CharSequence)string)) {
            try {
                PackageManager packageManager = context.getPackageManager();
                ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
                if (applicationInfo != null) {
                    Object object = applicationInfo.metaData.get("UMENG_APPKEY");
                    if (object != null) {
                        string = object.toString();
                    } else {
                        Log.i("com.umeng.socialize", "Could not read UMENG_APPKEY meta-data from AndroidManifest.xml.");
                    }
                }
            }
            catch (Exception exception) {
                Log.i("com.umeng.socialize", "Could not read UMENG_APPKEY meta-data from AndroidManifest.xml.", exception);
            }
        }
        return string;
    }

    public static void safeCloseDialog(Dialog dialog) {
        try {
            Activity activity;
            if (dialog != null && dialog.isShowing() && (activity = dialog.getOwnerActivity()) != null && !activity.isFinishing()) {
                dialog.dismiss();
                dialog = null;
            }
        }
        catch (Exception exception) {
            Log.e(TAG, "dialog dismiss error", exception);
        }
    }

    public static void safeShowDialog(Dialog dialog) {
        try {
            Activity activity;
            if (dialog != null && !dialog.isShowing() && (activity = dialog.getOwnerActivity()) != null && !activity.isFinishing()) {
                dialog.show();
            }
        }
        catch (Exception exception) {
            Log.e(TAG, "dialog show error", exception);
        }
    }

    public static Bundle parseUrl(String string) {
        try {
            URL uRL = new URL(string);
            Bundle bundle = SocializeUtils.decodeUrl(uRL.getQuery());
            bundle.putAll(SocializeUtils.decodeUrl(uRL.getRef()));
            return bundle;
        }
        catch (MalformedURLException malformedURLException) {
            return new Bundle();
        }
    }

    public static Bundle decodeUrl(String string) {
        Bundle bundle = new Bundle();
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("&")) {
                String[] stringArray2 = string2.split("=");
                bundle.putString(URLDecoder.decode(stringArray2[0]), URLDecoder.decode(stringArray2[1]));
            }
        }
        return bundle;
    }

    public static int countContentLength(String string) {
        string = string.trim();
        int n = 0;
        int n2 = 0;
        Pattern pattern = SocializeUtils.getDoubleBytePattern();
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            ++n2;
        }
        n = string.length() - n2;
        n2 = n % 2 != 0 ? (n2 += (n + 1) / 2) : (n2 += n / 2);
        return n2;
    }

    private static Pattern getDoubleBytePattern() {
        if (mDoubleByte_Pattern == null) {
            mDoubleByte_Pattern = Pattern.compile("[^\\x00-\\xff]");
        }
        return mDoubleByte_Pattern;
    }

    public static Object[] readSIMCard(Context context) {
        try {
            Object[] objectArray = new Object[3];
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            objectArray[0] = false;
            switch (telephonyManager.getSimState()) {
                case 1: {
                    objectArray[1] = "\u65e0\u5361";
                    break;
                }
                case 0: {
                    objectArray[0] = true;
                    objectArray[1] = "\u672a\u77e5\u72b6\u6001";
                    break;
                }
                case 4: {
                    objectArray[1] = "\u9700\u8981NetworkPIN\u89e3\u9501";
                    break;
                }
                case 2: {
                    objectArray[1] = "\u9700\u8981PIN\u89e3\u9501";
                    break;
                }
                case 3: {
                    objectArray[1] = "\u9700\u8981PUK\u89e3\u9501";
                    break;
                }
                case 5: {
                    objectArray[0] = true;
                    objectArray[1] = "\u826f\u597d";
                }
            }
            return objectArray;
        }
        catch (Exception exception) {
            Log.e(TAG, "cannot read SIM card. [" + exception.toString() + "]");
            return null;
        }
    }

    public static boolean isGoogleMapExist() {
        try {
            Class.forName("com.google.android.maps.MapActivity");
            return true;
        }
        catch (Exception exception) {
            Log.w(TAG, "The device has no google map lib!");
            return false;
        }
    }

    public static int[] getFloatWindowSize(Context context) {
        ResContainer resContainer = ResContainer.get(context);
        Resources resources = context.getResources();
        int[] nArray = new int[]{(int)resources.getDimension(resContainer.dimen("umeng_socialize_pad_window_width")), (int)resources.getDimension(resContainer.dimen("umeng_socialize_pad_window_height"))};
        return nArray;
    }

    public static boolean isFloatWindowStyle(Context context) {
        if (SocializeConstants.SUPPORT_PAD) {
            if (smDip == 0) {
                int n;
                WindowManager windowManager = (WindowManager)context.getSystemService("window");
                Display display = windowManager.getDefaultDisplay();
                int n2 = display.getWidth();
                int n3 = n2 > (n = display.getHeight()) ? n : n2;
                DisplayMetrics displayMetrics = new DisplayMetrics();
                windowManager.getDefaultDisplay().getMetrics(displayMetrics);
                smDip = (int)((float)n3 / displayMetrics.density + 0.5f);
            }
            int n = context.getResources().getConfiguration().screenLayout;
            if ((n &= 0xF) >= 3 && smDip >= 550) {
                return true;
            }
        }
        return false;
    }

    public static Uri insertImage(Context context, String string) {
        if (TextUtils.isEmpty((CharSequence)string) || !new File(string).exists()) {
            return null;
        }
        try {
            String string2 = MediaStore.Images.Media.insertImage((ContentResolver)context.getContentResolver(), (String)string, (String)"umeng_social_shareimg", null);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            Uri uri = Uri.parse((String)string2);
            return uri;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e("com.umeng.socialize", "", illegalArgumentException);
        }
        catch (Exception exception) {
            Log.e("com.umeng.socialize", "", exception);
        }
        return null;
    }

    public static int dip2Px(Context context, float f) {
        float f2 = context.getResources().getDisplayMetrics().density;
        return (int)(f * f2 + 0.5f);
    }

    public static Map<String, String> jsonToMap(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            JSONObject jSONObject = new JSONObject(string);
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                hashMap.put(string2, jSONObject.get(string2) + "");
            }
        }
        catch (Exception exception) {
            Log.e("social", "jsontomap fail=" + exception);
        }
        return hashMap;
    }

    public static byte[] File2byte(File file) {
        byte[] byArray = null;
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = fileInputStream.read(byArray2)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            fileInputStream.close();
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
    }

    public static String getMIMEType(File file) {
        String string = "*/*";
        String string2 = file.getName();
        int n = string2.lastIndexOf(".");
        if (n < 0) {
            return string;
        }
        String string3 = string2.substring(n, string2.length()).toLowerCase();
        if (string3 == "") {
            return string;
        }
        for (int i = 0; i < MIME_MapTable.length; ++i) {
            if (!string3.equals(MIME_MapTable[i][0])) continue;
            string = MIME_MapTable[i][1];
        }
        return string;
    }

    public static Map<String, String> bundleTomap(Bundle bundle) {
        if (bundle == null || bundle.isEmpty()) {
            return null;
        }
        Set set = bundle.keySet();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : set) {
            if (string.equals("com.sina.weibo.intent.extra.USER_ICON")) {
                hashMap.put("icon_url", bundle.getString(string));
            }
            hashMap.put(string, bundle.getString(string));
        }
        return hashMap;
    }
}

