/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.net.utils;

import com.umeng.socialize.net.utils.AesHelper;

public abstract class BaseNCodec {
    public static final int MIME_CHUNK_SIZE = 76;
    private static final int DEFAULT_BUFFER_RESIZE_FACTOR = 2;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    protected static final int MASK_8BITS = 255;
    protected static final byte PAD_DEFAULT = 61;
    protected static final byte PAD = 61;
    private final int mUnencodedBlockSize;
    private final int mEncodedBlockSize;
    protected final int mLineLength;
    private final int mChunkSeparatorLength;
    protected byte[] mBuffer;
    protected int mPos;
    private int mReadPos;
    protected boolean mEof;
    protected int mCurrentLinePos;
    protected int mModulus;

    protected BaseNCodec(int n, int n2, int n3, int n4) {
        this.mUnencodedBlockSize = n;
        this.mEncodedBlockSize = n2;
        this.mLineLength = n3 > 0 && n4 > 0 ? n3 / n2 * n2 : 0;
        this.mChunkSeparatorLength = n4;
    }

    boolean hasData() {
        return this.mBuffer != null;
    }

    int available() {
        return this.mBuffer != null ? this.mPos - this.mReadPos : 0;
    }

    protected int getDefaultBufferSize() {
        return 8192;
    }

    private void resizeBuffer() {
        if (this.mBuffer == null) {
            this.mBuffer = new byte[this.getDefaultBufferSize()];
            this.mPos = 0;
            this.mReadPos = 0;
        } else {
            byte[] byArray = new byte[this.mBuffer.length * 2];
            System.arraycopy(this.mBuffer, 0, byArray, 0, this.mBuffer.length);
            this.mBuffer = byArray;
        }
    }

    protected void ensureBufferSize(int n) {
        if (this.mBuffer == null || this.mBuffer.length < this.mPos + n) {
            this.resizeBuffer();
        }
    }

    int readResults(byte[] byArray, int n, int n2) {
        if (this.mBuffer != null) {
            int n3 = Math.min(this.available(), n2);
            System.arraycopy(this.mBuffer, this.mReadPos, byArray, n, n3);
            this.mReadPos += n3;
            if (this.mReadPos >= this.mPos) {
                this.mBuffer = null;
            }
            return n3;
        }
        return this.mEof ? -1 : 0;
    }

    protected static boolean isWhiteSpace(byte by) {
        switch (by) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    private void reset() {
        this.mBuffer = null;
        this.mPos = 0;
        this.mReadPos = 0;
        this.mCurrentLinePos = 0;
        this.mModulus = 0;
        this.mEof = false;
    }

    public Object encode(Object object) throws Exception {
        if (!(object instanceof byte[])) {
            throw new Exception("Parameter supplied to Base-N encode is not a byte[]");
        }
        return this.encode((byte[])object);
    }

    public String encodeToString(byte[] byArray) {
        return AesHelper.newStringUtf8(this.encode(byArray));
    }

    public Object decode(Object object) throws Exception {
        if (object instanceof byte[]) {
            return this.decode((byte[])object);
        }
        if (object instanceof String) {
            return this.decode((String)object);
        }
        throw new Exception("Parameter supplied to Base-N decode is not a byte[] or a String");
    }

    public byte[] decode(String string) {
        return this.decode(AesHelper.getBytesUtf8(string));
    }

    public byte[] decode(byte[] byArray) {
        this.reset();
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        this.decode(byArray, 0, byArray.length);
        this.decode(byArray, 0, -1);
        byte[] byArray2 = new byte[this.mPos];
        this.readResults(byArray2, 0, byArray2.length);
        return byArray2;
    }

    public byte[] encode(byte[] byArray) {
        this.reset();
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        this.encode(byArray, 0, byArray.length);
        this.encode(byArray, 0, -1);
        byte[] byArray2 = new byte[this.mPos - this.mReadPos];
        this.readResults(byArray2, 0, byArray2.length);
        return byArray2;
    }

    public String encodeAsString(byte[] byArray) {
        return AesHelper.newStringUtf8(this.encode(byArray));
    }

    abstract void encode(byte[] var1, int var2, int var3);

    abstract void decode(byte[] var1, int var2, int var3);

    protected abstract boolean isInAlphabet(byte var1);

    public boolean isInAlphabet(byte[] byArray, boolean bl) {
        for (int i = 0; i < byArray.length; ++i) {
            if (this.isInAlphabet(byArray[i]) || bl && (byArray[i] == 61 || BaseNCodec.isWhiteSpace(byArray[i]))) continue;
            return false;
        }
        return true;
    }

    public boolean isInAlphabet(String string) {
        return this.isInAlphabet(AesHelper.getBytesUtf8(string), true);
    }

    protected boolean containsAlphabetOrPad(byte[] byArray) {
        if (byArray == null) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (61 != byArray[i] && !this.isInAlphabet(byArray[i])) continue;
            return true;
        }
        return false;
    }

    public long getEncodedLength(byte[] byArray) {
        long l = (long)((byArray.length + this.mUnencodedBlockSize - 1) / this.mUnencodedBlockSize) * (long)this.mEncodedBlockSize;
        if (this.mLineLength > 0) {
            l += (l + (long)this.mLineLength - 1L) / (long)this.mLineLength * (long)this.mChunkSeparatorLength;
        }
        return l;
    }
}

