/*
 * Decompiled with CFR 0.152.
 */
package com.beastwall.storagemanager;

import com.beastwall.storagemanager.callback.FileSavedCall;
import com.beastwall.storagemanager.callback.ProgressCallback;
import com.beastwall.storagemanager.utils.StorageUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;

public class FileSaver {
    private ProgressCallback progressCallback;
    private long totalBytes = -1L;

    public static final FileSaver get() {
        return new FileSaver();
    }

    public FileSaver setProgressCallBack(ProgressCallback progressCallback) {
        this.progressCallback = progressCallback;
        return this;
    }

    public FileSaver setInputLength(long totalBytes) {
        this.totalBytes = totalBytes;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String save(InputStream inputStream, String outputFile) {
        String parentDirsPath = "";
        try {
            int size;
            String check = outputFile.replace("/", "#*#*#").replace(String.valueOf('\\'), "#*#*#");
            check = check.replaceFirst("#*#*#", "/");
            if (!check.contains("/")) {
                parentDirsPath = StorageUtils.guessFileType(outputFile).toString();
                File parentDirs = new File(parentDirsPath);
                parentDirs.mkdirs();
            }
            FileOutputStream outputStream = new FileOutputStream(parentDirsPath + outputFile);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] buffer = new byte[8192];
            if (this.totalBytes == -1L) {
                this.totalBytes = inputStream.available();
            }
            if (this.totalBytes == 0L) {
                this.totalBytes = Long.MAX_VALUE;
            }
            int numberOfReadBytes = 0;
            double percentage = 0.0;
            while ((size = bufferedInputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, size);
                numberOfReadBytes += size;
                if (this.progressCallback == null) continue;
                double newPercentage = (double)numberOfReadBytes / (double)this.totalBytes * 100.0;
                if (newPercentage > percentage) {
                    this.progressCallback.progress(this.totalBytes, numberOfReadBytes, this.totalBytes > 0L ? (int)Math.round(newPercentage) : 50);
                }
                percentage = newPercentage;
            }
            outputStream.flush();
            outputStream.close();
            bufferedInputStream.close();
            inputStream.close();
            outputStream = null;
            bufferedInputStream = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (inputStream != null) {
                inputStream = null;
            }
        }
        return parentDirsPath + outputFile;
    }

    public String save(File file, String outputFileName) {
        try {
            return this.save(new FileInputStream(file), outputFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String save(String inputFilePath, String outputFileName) {
        try {
            return this.save(new FileInputStream(inputFilePath), outputFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String save(InputStream inputStream, String path, String fileName) {
        if (inputStream == null) {
            return null;
        }
        File dataDir = new File(path);
        dataDir.mkdirs();
        String fileCompleteName = dataDir.getPath() + File.separator + fileName;
        return this.save(inputStream, fileCompleteName);
    }

    public String save(File file, String path, String fileName) {
        if (file == null || !file.isFile()) {
            return null;
        }
        File dataDir = new File(path);
        dataDir.mkdirs();
        try {
            String fileCompleteName = dataDir.getPath() + File.separator + fileName;
            return this.save(file, fileCompleteName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String save(byte[] bytes, String outputFile) {
        try {
            return this.save(new ByteArrayInputStream(bytes), outputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String save(byte[] bytes, String path, String fileName) {
        if (bytes == null) {
            return null;
        }
        File dataDir = new File(path);
        dataDir.mkdirs();
        String fileCompleteName = dataDir.getPath() + File.separator + fileName;
        try {
            return this.save(new ByteArrayInputStream(bytes), fileCompleteName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void saveAsync(InputStream inputStream, String outputFile, FileSavedCall fileSavedCall) {
        new Thread(() -> {
            String result = this.save(inputStream, outputFile);
            fileSavedCall.result(result != null, result);
        }).start();
    }

    public void saveAsync(File file, String outputFile, FileSavedCall fileSavedCall) {
        new Thread(() -> {
            String result = this.save(file, outputFile);
            fileSavedCall.result(result != null, result);
        }).start();
    }

    public void saveAsync(String inputFile, String outputFile, FileSavedCall fileSavedCall) {
        new Thread(() -> {
            String result = this.save(inputFile, outputFile);
            fileSavedCall.result(result != null, result);
        }).start();
    }

    public void saveAsync(InputStream inputStream, String path, String fileName, FileSavedCall fileSavedCall) {
        new Thread(() -> {
            String result = this.save(inputStream, path, fileName);
            fileSavedCall.result(result != null, result);
        }).start();
    }

    public void saveAsync(File file, String path, String fileName, FileSavedCall fileSavedCall) {
        new Thread(() -> {
            String result = this.save(file, path, fileName);
            fileSavedCall.result(result != null, result);
        }).start();
    }

    public void saveAsync(byte[] bytes, String outputFile, FileSavedCall fileSavedCall) {
        new Thread(() -> {
            String result = this.save(bytes, outputFile);
            fileSavedCall.result(result != null, result);
        }).start();
    }

    public void saveAsync(byte[] bytes, String path, String fileName, FileSavedCall fileSavedCall) {
        new Thread(() -> {
            String result = this.save(bytes, path, fileName);
            fileSavedCall.result(result != null, result);
        }).start();
    }
}

