/*
 * Decompiled with CFR 0.152.
 */
package com.beardedhen.androidbootstrap;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.beardedhen.androidbootstrap.BootstrapDrawableFactory;
import com.beardedhen.androidbootstrap.R;
import com.beardedhen.androidbootstrap.api.defaults.DefaultBootstrapSize;
import com.beardedhen.androidbootstrap.utils.ColorUtils;
import com.beardedhen.androidbootstrap.utils.DimenUtils;
import com.beardedhen.androidbootstrap.utils.ViewUtils;

public class BootstrapWell
extends FrameLayout {
    private float bootstrapSize;

    public BootstrapWell(Context context) {
        super(context);
        this.initialise(null);
    }

    public BootstrapWell(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialise(attrs);
    }

    public BootstrapWell(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialise(attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialise(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.BootstrapButton);
        try {
            int sizeOrdinal = a.getInt(R.styleable.BootstrapButton_bootstrapSize, -1);
            this.bootstrapSize = DefaultBootstrapSize.fromAttributeValue(sizeOrdinal).scaleFactor();
        }
        finally {
            a.recycle();
        }
        this.updateBootstrapState();
    }

    private void updateBootstrapState() {
        Drawable bg = BootstrapDrawableFactory.bootstrapWell(ColorUtils.resolveColor(R.color.bootstrap_well_background, this.getContext()), (int)(DimenUtils.pixelsFromDpResource(this.getContext(), R.dimen.bootstrap_well_corner_radius) * this.bootstrapSize / 2.0f), (int)DimenUtils.pixelsFromDpResource(this.getContext(), R.dimen.bootstrap_well_stroke_width), ColorUtils.resolveColor(R.color.bootstrap_well_border_color, this.getContext()));
        ViewUtils.setBackgroundDrawable((View)this, bg);
        int padding = (int)((double)(DimenUtils.pixelsFromDpResource(this.getContext(), R.dimen.bootstrap_well_default_padding) * this.bootstrapSize) * 2.5);
        this.setPadding(padding, padding, padding, padding);
    }
}

