/*
 * Decompiled with CFR 0.152.
 */
package com.beardedhen.androidbootstrap;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import com.beardedhen.androidbootstrap.BetaApi;
import com.beardedhen.androidbootstrap.BootstrapDrawableFactory;
import com.beardedhen.androidbootstrap.R;
import com.beardedhen.androidbootstrap.api.attributes.BootstrapBrand;
import com.beardedhen.androidbootstrap.api.defaults.DefaultBootstrapBrand;
import com.beardedhen.androidbootstrap.api.defaults.DefaultBootstrapSize;
import com.beardedhen.androidbootstrap.api.view.BootstrapBadgeView;
import com.beardedhen.androidbootstrap.api.view.BootstrapBrandView;
import com.beardedhen.androidbootstrap.api.view.BootstrapSizeView;
import com.beardedhen.androidbootstrap.utils.DimenUtils;
import com.beardedhen.androidbootstrap.utils.ViewUtils;

@BetaApi
public class BootstrapBadge
extends ImageView
implements BootstrapSizeView,
BootstrapBrandView,
BootstrapBadgeView {
    private String badgeText;
    private int size;
    private boolean insideContainer;
    private BootstrapBrand bootstrapBrand = DefaultBootstrapBrand.REGULAR;
    private float bootstrapSize;
    private Drawable badgeDrawable;

    public BootstrapBadge(Context context) {
        super(context);
        this.init(null);
    }

    public BootstrapBadge(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public BootstrapBadge(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.BootstrapBadge);
        try {
            int sizeOrdinal = a.getInt(R.styleable.BootstrapBadge_bootstrapSize, -1);
            if (this.badgeText == null) {
                this.badgeText = a.getString(R.styleable.BootstrapBadge_badgeText);
            }
            this.bootstrapSize = DefaultBootstrapSize.fromAttributeValue(sizeOrdinal).scaleFactor();
        }
        finally {
            a.recycle();
        }
        this.size = (int)DimenUtils.pixelsFromDpResource(this.getContext(), R.dimen.bootstrap_badge_default_size);
        this.updateBootstrapState();
    }

    private void updateBootstrapState() {
        this.badgeDrawable = BootstrapDrawableFactory.createBadgeDrawable(this.getContext(), this.bootstrapBrand, (int)((float)this.size * this.bootstrapSize), (int)((float)this.size * this.bootstrapSize), this.badgeText, this.insideContainer);
        ViewUtils.setBackgroundDrawable((View)this, this.badgeDrawable);
    }

    Drawable getBadgeDrawable() {
        return this.badgeDrawable;
    }

    @Override
    public String getBadgeText() {
        return this.badgeText;
    }

    @Override
    public void setBadgeText(String badgeText) {
        this.badgeText = badgeText;
        this.updateBootstrapState();
    }

    public void setBootstrapBrand(BootstrapBrand bootstrapBrand, boolean insideContainer) {
        this.insideContainer = insideContainer;
        this.setBootstrapBrand(bootstrapBrand);
    }

    @Override
    public void setBootstrapBrand(@NonNull BootstrapBrand bootstrapBrand) {
        this.bootstrapBrand = bootstrapBrand;
        this.updateBootstrapState();
    }

    @Override
    @NonNull
    public BootstrapBrand getBootstrapBrand() {
        return this.bootstrapBrand;
    }

    @Override
    public void setBootstrapSize(DefaultBootstrapSize bootstrapSize) {
        this.bootstrapSize = bootstrapSize.scaleFactor();
        this.updateBootstrapState();
    }

    @Override
    public void setBootstrapSize(float bootstrapSize) {
        this.bootstrapSize = bootstrapSize;
        this.updateBootstrapState();
    }

    @Override
    public float getBootstrapSize() {
        return this.bootstrapSize;
    }
}

