/*
 * Decompiled with CFR 0.152.
 */
package com.bean.xhttp;

import android.text.TextUtils;
import android.util.Log;
import com.bean.logger.JJLogger;
import com.bean.xhttp.IXHttp;
import com.bean.xhttp.callback.OnXHttpCallback;
import com.bean.xhttp.core.IHttp;
import com.bean.xhttp.core.pool.IThreadPool;
import com.bean.xhttp.core.pool.ThreadPool;
import com.bean.xhttp.core.task.HttpTask;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;

public class XHttp
implements IHttp<XHttp>,
IXHttp<XHttp> {
    private final String TAG = "xander";
    private HttpTask mHttpTask;
    private static IThreadPool sCurrentThreadPool;
    private static IThreadPool sSerialThreadPool;
    private boolean mStartCurrentThreadPool = true;
    private boolean mStartSerailThreadPool = true;
    private static final int CPU_COUNT;
    private static final int CORE_POOL_SIZE;
    private static final int MAXIMUM_POOL_SIZE;
    private static final long KEEP_ALIVE = 0L;
    private static volatile XHttp mInstance;
    private static Map<String, HttpTask> mTaskMap;

    private XHttp() {
    }

    public static XHttp getInstance() {
        mInstance = SingletonHolder.TASK_MANAGER;
        return mInstance;
    }

    @Override
    public XHttp setTag(String tag) {
        if (!TextUtils.isEmpty((CharSequence)tag)) {
            if (mTaskMap == null) {
                mTaskMap = new HashMap<String, HttpTask>();
            }
            mTaskMap.put(tag, this.mHttpTask);
        }
        return mInstance;
    }

    @Override
    public XHttp startSerialThreadPool() {
        this.mStartSerailThreadPool = true;
        if (sSerialThreadPool == null) {
            sSerialThreadPool = new ThreadPool(1, 1, 0L);
        }
        return mInstance;
    }

    @Override
    public XHttp startConcurrenceThreadPool() {
        this.mStartCurrentThreadPool = true;
        if (sCurrentThreadPool == null) {
            sCurrentThreadPool = new ThreadPool(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, 0L);
        }
        return mInstance;
    }

    @Override
    public XHttp customThreadPool(IThreadPool poolExecutor) {
        sCurrentThreadPool = poolExecutor;
        this.mStartCurrentThreadPool = true;
        return mInstance;
    }

    @Override
    public XHttp closeThreadPool() {
        if (sSerialThreadPool != null) {
            sSerialThreadPool.closeThreadPool();
        }
        if (sCurrentThreadPool != null) {
            sCurrentThreadPool.closeThreadPool();
        }
        return mInstance;
    }

    @Override
    public XHttp get(String url) {
        this.mHttpTask = new HttpTask();
        this.mHttpTask.get(url);
        return mInstance;
    }

    @Override
    public XHttp post(String url) {
        this.mHttpTask = new HttpTask();
        this.mHttpTask.post(url);
        return mInstance;
    }

    @Override
    public XHttp setParams(Map<String, String> params) {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        try {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                stringMap.put(entry.getKey(), URLEncoder.encode(entry.getValue(), "utf-8"));
            }
            this.mHttpTask.setParams(stringMap);
        }
        catch (UnsupportedEncodingException e) {
            this.mHttpTask.setParams((Map)params);
        }
        return mInstance;
    }

    @Override
    public XHttp setParams(String key, String value) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return mInstance;
        }
        try {
            this.mHttpTask.setParams(key, URLEncoder.encode(value, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            this.mHttpTask.setParams(key, value);
        }
        JJLogger.logInfo("xander", "XHttp.setParams :" + key + "= " + value);
        return mInstance;
    }

    @Override
    public XHttp setHeads(String key, String value) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return mInstance;
        }
        this.mHttpTask.setHeads(key, value);
        return mInstance;
    }

    @Override
    public XHttp setHeads(Map<String, String> heads) {
        this.mHttpTask.setHeads((Map)heads);
        return mInstance;
    }

    @Override
    public XHttp setTimeout(int timeout) {
        this.mHttpTask.setTimeout(timeout);
        return mInstance;
    }

    @Override
    public XHttp setCharset(String charset) {
        this.mHttpTask.setCharset(charset);
        return mInstance;
    }

    @Override
    public XHttp uploadFiles(String[] uploadFilePaths) {
        this.mHttpTask.uploadFiles(uploadFilePaths);
        return mInstance;
    }

    @Override
    public XHttp uploadFile(String uploadFilePath) {
        this.mHttpTask.uploadFile(uploadFilePath);
        return mInstance;
    }

    @Override
    public XHttp setOnXHttpCallback(OnXHttpCallback taskCallback) {
        this.mHttpTask.setOnXHttpCallback(taskCallback);
        if (this.mStartSerailThreadPool && sSerialThreadPool != null) {
            this.mStartSerailThreadPool = false;
            if (sSerialThreadPool.isShutdownPool() || sSerialThreadPool.isShutdownPool()) {
                JJLogger.logInfo("xander", "XHttp.start : \u7ebf\u7a0b\u6c60\u5df2\u5173\u95ed \u9519\u8bef\u7801\uff1a10002");
                return mInstance;
            }
            try {
                sSerialThreadPool.start(this.mHttpTask);
            }
            catch (RejectedExecutionException e) {
                JJLogger.logInfo("xander", "XHttp.start :" + sCurrentThreadPool.getCount());
            }
        } else if (this.mStartCurrentThreadPool && sCurrentThreadPool != null) {
            this.mStartCurrentThreadPool = false;
            if (sCurrentThreadPool.isShutdownPool() || sCurrentThreadPool.isShutdownPool()) {
                JJLogger.logInfo("xander", "XHttp.start : \u7ebf\u7a0b\u6c60\u5df2\u5173\u95ed \u9519\u8bef\u7801\uff1a10002");
                return mInstance;
            }
            try {
                sCurrentThreadPool.start(this.mHttpTask);
            }
            catch (RejectedExecutionException e) {
                JJLogger.logInfo("xander", "XHttp.start :" + sCurrentThreadPool.getCount());
            }
        } else {
            new Thread(this.mHttpTask).start();
        }
        return mInstance;
    }

    @Override
    public void cancel(String tag) {
        if (mTaskMap == null) {
            return;
        }
        int taskSize = mTaskMap.size();
        if (taskSize > 0) {
            for (Map.Entry<String, HttpTask> entry : mTaskMap.entrySet()) {
                if (!entry.getKey().equals(tag)) continue;
                Log.i((String)"xander", (String)("XHttp.cancel :" + entry.getKey()));
                entry.getValue().cancle();
            }
        }
    }

    @Override
    public void cancelAll() {
        if (mTaskMap == null) {
            return;
        }
        int taskSize = mTaskMap.size();
        if (taskSize > 0) {
            for (Map.Entry<String, HttpTask> entry : mTaskMap.entrySet()) {
                entry.getValue().cancle();
            }
        }
        mTaskMap.clear();
    }

    static {
        CPU_COUNT = Runtime.getRuntime().availableProcessors();
        CORE_POOL_SIZE = CPU_COUNT + 1;
        MAXIMUM_POOL_SIZE = CPU_COUNT * 2 + 1;
    }

    private static class SingletonHolder {
        private static final XHttp TASK_MANAGER = new XHttp();

        private SingletonHolder() {
        }
    }
}

