/*
 * Decompiled with CFR 0.152.
 */
package com.bean.http.core.http.core.task;

import android.text.TextUtils;
import android.util.Log;
import com.bean.http.common.CommonMethod;
import com.bean.http.common.Configuration;
import com.bean.http.core.http.callback.OnXHttpCallback;
import com.bean.http.core.http.core.task.IHttpTask;
import com.bean.http.core.http.response.Response;
import com.bean.http.core.logger.JJLogger;
import com.bean.http.exception.SDKException;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class HttpTask
implements Runnable,
IHttpTask {
    private static final String TAG = "HttpTask";
    private boolean mIntercept = false;
    private Response mResponse;
    private String mUrl;
    private Map<String, String> mParamsMap;
    private String mParams;
    private StringBuilder mPostDataBuilder = new StringBuilder();
    private String mCharset = "utf-8";
    private final int METHOD_GET = 16;
    private final int METHOD__POST = 17;
    private int mHttpType = 16;
    private int mHttpTimeout = 2000;
    private Map<String, String> mHeads;
    private OnXHttpCallback mTaskCallback;
    private final String mBoundary = UUID.randomUUID().toString();
    private final String mPrefix = "--";
    private final String mChangeNewLine = "\r\n";
    private final String mSplitLine = "--" + this.mBoundary + "\r\n";
    private final String mMultipartFromData = "multipart/form-data";
    private String[] mUploadFilePaths;
    private boolean upload_file;

    public HttpTask() {
        this.mResponse = new Response();
    }

    @Override
    public IHttpTask setCharset(String charset) {
        this.mCharset = charset;
        return this;
    }

    @Override
    public IHttpTask uploadFiles(String[] uploadFilePaths) {
        this.mUploadFilePaths = uploadFilePaths;
        this.upload_file = true;
        this.uploadFileHeads();
        return this;
    }

    @Override
    public IHttpTask uploadFile(String uploadFilePath) {
        this.upload_file = true;
        this.mUploadFilePaths = new String[]{uploadFilePath};
        this.uploadFileHeads();
        return this;
    }

    private void uploadFileHeads() {
        this.setHeads("Accept", "*/*");
        this.setHeads("Connection", "Keep-Alive");
        this.setHeads("User-agent", "Android_xander");
        this.setHeads("Charsert", this.mCharset);
        this.setHeads("Accept-Encoding", "gzip,deflate");
        this.setHeads("Content-Type", "multipart/form-data;boundary=" + this.mBoundary);
        JJLogger.logInfo(TAG, "HttpTask.uploadFileHeads :");
    }

    @Override
    public IHttpTask setTimeout(int timeout) {
        this.mHttpTimeout = timeout;
        return this;
    }

    @Override
    public IHttpTask get(String url) {
        this.mUrl = url;
        this.mHttpType = 16;
        return this;
    }

    @Override
    public IHttpTask post(String url) {
        this.mUrl = url;
        this.mHttpType = 17;
        return this;
    }

    @Override
    public IHttpTask setParams(Map<String, String> stringMap) {
        this.mParamsMap = stringMap;
        return this;
    }

    private void handleParams(Map<String, String> paramsMap) {
        StringBuilder paramBuilder = new StringBuilder();
        if (paramsMap != null) {
            for (Map.Entry<String, String> entry : paramsMap.entrySet()) {
                paramBuilder.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
            }
            if (paramBuilder.length() > 0) {
                paramBuilder.deleteCharAt(paramBuilder.length() - 1);
            }
            this.mParams = paramBuilder.toString();
            if (this.mHttpType == 16) {
                this.mUrl = this.mUrl + "?" + this.mParams;
            }
            JJLogger.logInfo(TAG, "HttpTask.handleParams :" + this.mParams);
        }
    }

    @Override
    public IHttpTask setParams(String key, String value) {
        if (this.mParamsMap == null) {
            this.mParamsMap = new HashMap<String, String>();
        }
        this.mParamsMap.put(key, value);
        return this;
    }

    @Override
    public IHttpTask setHeads(String key, String value) {
        if (this.mHeads == null) {
            this.mHeads = new HashMap<String, String>();
        }
        this.mHeads.put(key, value);
        JJLogger.logInfo(TAG, "HttpTask.setHeads :" + this.mHeads.size());
        return this;
    }

    @Override
    public IHttpTask setHeads(Map<String, String> heads) {
        this.mHeads = heads;
        return this;
    }

    @Override
    public IHttpTask setOnXHttpCallback(OnXHttpCallback taskCallback) {
        this.mTaskCallback = taskCallback;
        return this;
    }

    @Override
    public void cancle() {
        this.mIntercept = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (TextUtils.isEmpty((CharSequence)this.mUrl)) {
            return;
        }
        this.handleParams(this.mParamsMap);
        HttpURLConnection httpUrlCon = null;
        if (this.mIntercept) {
            this.mResponse.setErrorInfo(new SDKException("\u7528\u6237\u53d6\u6d88\u64cd\u4f5c"), "10002");
            this.mIntercept = false;
            this.postRun(this.mResponse, "10002", "");
            return;
        }
        int responseCode = 0;
        String responseCodeStr = "Before";
        String redirection = "";
        try {
            JJLogger.logInfo(TAG, "HttpTask.run :" + this.mUrl);
            if (TextUtils.isEmpty((CharSequence)this.mUrl)) {
                this.mResponse.setErrorInfo(new SDKException("url \u4e3a\u7a7a\uff01"), "10001");
                this.postRun(this.mResponse, "10001", "");
                return;
            }
            URL httpUrl = new URL(this.mUrl);
            httpUrlCon = (HttpURLConnection)httpUrl.openConnection();
            httpUrlCon.setConnectTimeout(this.mHttpTimeout);
            httpUrlCon.setReadTimeout(this.mHttpTimeout);
            if (this.mIntercept) {
                this.mResponse.setErrorInfo(new SDKException("\u7528\u6237\u53d6\u6d88\u64cd\u4f5c"), "10002");
                this.mIntercept = false;
                this.postRun(this.mResponse, responseCodeStr, responseCodeStr);
                return;
            }
            if (this.mHeads != null) {
                JJLogger.logInfo(TAG, "HttpTask.run :" + this.mHeads.size());
                for (Map.Entry<String, String> entry : this.mHeads.entrySet()) {
                    httpUrlCon.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            switch (this.mHttpType) {
                case 16: {
                    httpUrlCon.setRequestMethod("GET");
                    break;
                }
                case 17: {
                    httpUrlCon.setRequestMethod("POST");
                    byte[] postParam = null;
                    try {
                        if (!TextUtils.isEmpty((CharSequence)this.mParams)) {
                            postParam = this.mParams.getBytes(this.mCharset);
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    httpUrlCon.setDoInput(true);
                    httpUrlCon.setDoOutput(true);
                    httpUrlCon.setUseCaches(false);
                    if (this.mIntercept) {
                        this.mResponse.setErrorInfo(new SDKException("\u7528\u6237\u53d6\u6d88\u64cd\u4f5c"), "10002");
                        this.mIntercept = false;
                        this.postRun(this.mResponse, responseCodeStr, "");
                        return;
                    }
                    DataOutputStream outputStream = new DataOutputStream(httpUrlCon.getOutputStream());
                    if (postParam != null) {
                        outputStream.write(postParam);
                    } else if (this.upload_file) {
                        this.upload_file = false;
                        for (int i = 0; i < this.mUploadFilePaths.length; ++i) {
                            int length;
                            String uploadFile = this.mUploadFilePaths[i];
                            String filename = uploadFile.substring(uploadFile.lastIndexOf("/") + 1);
                            JJLogger.logInfo(TAG, "HttpTask.run :" + filename);
                            this.mPostDataBuilder.append(this.mSplitLine);
                            this.mPostDataBuilder.append("Content-Disposition: form-data; name=\"file").append(i).append("\";filename=\"").append(filename).append("\"").append("\r\n").append("\r\n");
                            outputStream.write(this.mPostDataBuilder.toString().getBytes());
                            this.mPostDataBuilder.append("\r\n");
                            FileInputStream fileInputStream = new FileInputStream(uploadFile);
                            byte[] buffer = new byte[1024];
                            while ((length = fileInputStream.read(buffer)) != -1) {
                                outputStream.write(buffer, 0, length);
                            }
                            outputStream.write("\r\n".getBytes());
                            fileInputStream.close();
                        }
                        byte[] end_data = ("--" + this.mBoundary + "--" + "\r\n").getBytes();
                        outputStream.write(end_data);
                    }
                    outputStream.flush();
                    outputStream.close();
                    break;
                }
            }
            redirection = httpUrlCon.getHeaderField("location");
            responseCode = httpUrlCon.getResponseCode();
            responseCodeStr = String.valueOf(responseCode);
            if (responseCode == 200) {
                InputStream inputStream = httpUrlCon.getInputStream();
                byte[] bytes = CommonMethod.toByteArray(inputStream);
                this.mResponse.setBytes(bytes);
                this.postRun(this.mResponse, String.valueOf(responseCode), "");
            } else {
                this.mResponse.setErrorInfo(new SDKException("\u627e\u4e0d\u5230\u670d\u52a1\u5668 "), "connect");
                this.postRun(this.mResponse, String.valueOf(responseCode), redirection);
            }
        }
        catch (UnknownHostException e) {
            this.mResponse.setErrorInfo(e, "10000");
            this.postRun(this.mResponse, responseCodeStr, "");
        }
        catch (SocketTimeoutException e) {
            this.mResponse.setErrorInfo(e, "time_out");
            this.postRun(this.mResponse, responseCodeStr, "");
        }
        catch (MalformedURLException e) {
            this.mResponse.setErrorInfo(e, "10001");
            this.postRun(this.mResponse, responseCodeStr, "");
        }
        catch (IOException e) {
            this.mResponse.setErrorInfo(e, "connect");
            this.postRun(this.mResponse, responseCodeStr, "");
        }
        finally {
            if (httpUrlCon != null) {
                httpUrlCon.disconnect();
            }
        }
    }

    private void postRun(final Response response, String responseCode, String redirectUrl) {
        if (responseCode.equals("302")) {
            new Thread(this).start();
            this.mUrl = redirectUrl;
            Log.i((String)TAG, (String)("\u91cd\u5b9a\u5411\u5730\u5740: " + redirectUrl));
            return;
        }
        Configuration.HANDLER.post(new Runnable(){

            @Override
            public void run() {
                if (HttpTask.this.mIntercept) {
                    HttpTask.this.mTaskCallback.onFailure(response.getException(), "10002");
                } else if (response.toBytes() == null) {
                    HttpTask.this.mTaskCallback.onFailure(response.getException(), response.getErrorCode());
                } else {
                    HttpTask.this.mTaskCallback.onSuccess(response);
                }
            }
        });
    }
}

