/*
 * Decompiled with CFR 0.152.
 */
package example;

import com.bazaarvoice.sswf.service.WorkflowManagement;
import example.ExampleWorkflowInput;
import example.ExampleWorkflowSteps;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ExampleSignalHandler {
    private Queue<String> signalsToSend = new ConcurrentLinkedQueue<String>();
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private WorkflowManagement<ExampleWorkflowInput, ExampleWorkflowSteps> workflowManagement;

    public ExampleSignalHandler(WorkflowManagement<ExampleWorkflowInput, ExampleWorkflowSteps> workflowManagement) {
        this.workflowManagement = workflowManagement;
    }

    public void start() {
        this.executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    String string = (String)ExampleSignalHandler.this.signalsToSend.poll();
                    if (string != null) {
                        ExampleSignalHandler.this.workflowManagement.signalWorkflow(string);
                    }
                }
                catch (Exception exception) {
                    System.out.println("ERROR: Caught Exception: " + exception.toString());
                    exception.printStackTrace(System.out);
                    throw exception;
                }
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    public void addSignal(String string) {
        boolean bl = this.signalsToSend.offer(string);
        if (!bl) {
            System.out.println("ERROR: Couldn't add to queue");
            throw new RuntimeException("Couldn't add to queue");
        }
    }
}

