/*
 * Decompiled with CFR 0.152.
 */
package com.batch.android.json;

import androidx.annotation.Keep;
import com.batch.android.json.JSONArray;
import com.batch.android.json.JSONException;
import com.batch.android.json.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Keep
public class JSONStringer {
    final StringBuilder out;
    private final List<a> stack;
    private final String indent;

    public JSONStringer() {
        ArrayList arrayList;
        StringBuilder stringBuilder;
        Object this_ = stringBuilder;
        stringBuilder = new StringBuilder();
        v1.out = this_;
        this_ = arrayList;
        arrayList = new ArrayList();
        v1.stack = this_;
        v1.indent = null;
    }

    /*
     * WARNING - void declaration
     */
    JSONStringer(int indentSpaces) {
        String string2;
        void var1_1;
        ArrayList arrayList;
        StringBuilder stringBuilder;
        JSONStringer jSONStringer = this_;
        Object this_ = stringBuilder;
        stringBuilder = new StringBuilder();
        v2.out = this_;
        this_ = arrayList;
        arrayList = new ArrayList();
        v2.stack = this_;
        char[] cArray = new char[var1_1];
        this_ = cArray;
        Arrays.fill(cArray, ' ');
        String string3 = string2;
        string2 = new String((char[])this_);
        jSONStringer.indent = string3;
    }

    private a peek() throws JSONException {
        if (!this.stack.isEmpty()) {
            List<a> list = this.stack;
            return list.get(list.size() - 1);
        }
        throw new JSONException("Nesting problem");
    }

    /*
     * WARNING - void declaration
     */
    private void replaceTop(a topOfStack) {
        void var1_1;
        List<a> list = this.stack;
        list.set(list.size() - 1, (a)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void string(String value) {
        this.out.append("\"");
        int n2 = value.length();
        block8: for (int i2 = 0; i2 < n2; ++i2) {
            void var1_1;
            char c2 = var1_1.charAt(i2);
            switch (c2) {
                default: {
                    if (c2 <= '\u001f') {
                        Integer n3 = c2;
                        Object[] objectArray = new Object[1];
                        Object[] objectArray2 = objectArray;
                        objectArray[0] = n3;
                        this.out.append(String.format("\\u%04x", objectArray2));
                        continue block8;
                    }
                    this.out.append(c2);
                    continue block8;
                }
                case '\"': 
                case '/': 
                case '\\': {
                    this.out.append('\\').append(c2);
                    continue block8;
                }
                case '\r': {
                    this.out.append("\\r");
                    continue block8;
                }
                case '\f': {
                    this.out.append("\\f");
                    continue block8;
                }
                case '\n': {
                    this.out.append("\\n");
                    continue block8;
                }
                case '\t': {
                    this.out.append("\\t");
                    continue block8;
                }
                case '\b': {
                    this.out.append("\\b");
                }
            }
        }
        this.out.append("\"");
    }

    private void newline() {
        if (this.indent != null) {
            this.out.append("\n");
            for (int i2 = 0; i2 < this.stack.size(); ++i2) {
                this.out.append(this.indent);
            }
        }
    }

    private void beforeKey() throws JSONException {
        block4: {
            block3: {
                a a2;
                block2: {
                    a2 = this.peek();
                    if (a2 != a.e) break block2;
                    this.out.append(',');
                    break block3;
                }
                if (a2 != a.c) break block4;
            }
            JSONStringer jSONStringer = this;
            jSONStringer.newline();
            jSONStringer.replaceTop(a.d);
            return;
        }
        throw new JSONException("Nesting problem");
    }

    private void beforeValue() throws JSONException {
        block7: {
            block6: {
                if (this.stack.isEmpty()) break block6;
                Object object = this.peek();
                if (object == a.a) {
                    JSONStringer jSONStringer = this;
                    jSONStringer.replaceTop(a.b);
                    jSONStringer.newline();
                    return;
                }
                if (object == a.b) {
                    JSONStringer jSONStringer = this;
                    jSONStringer.out.append(',');
                    jSONStringer.newline();
                    return;
                }
                if (object == a.d) {
                    JSONStringer jSONStringer = this;
                    object = jSONStringer.out;
                    String string2 = jSONStringer.indent == null ? ":" : ": ";
                    ((StringBuilder)object).append(string2);
                    this.replaceTop(a.e);
                    return;
                }
                if (object != a.f) break block7;
            }
            return;
        }
        throw new JSONException("Nesting problem");
    }

    public JSONStringer array() throws JSONException {
        return this.open(a.a, "[");
    }

    public JSONStringer endArray() throws JSONException {
        return this.close(a.a, a.b, "]");
    }

    public JSONStringer object() throws JSONException {
        return this.open(a.c, "{");
    }

    public JSONStringer endObject() throws JSONException {
        return this.close(a.c, a.e, "}");
    }

    /*
     * WARNING - void declaration
     */
    JSONStringer open(a empty, String openBracket) throws JSONException {
        void var2_2;
        void var1_1;
        if (this.stack.isEmpty() && this.out.length() > 0) {
            throw new JSONException("Nesting problem: multiple top-level roots");
        }
        JSONStringer jSONStringer = this;
        jSONStringer.beforeValue();
        jSONStringer.stack.add((a)var1_1);
        jSONStringer.out.append((String)var2_2);
        return jSONStringer;
    }

    /*
     * WARNING - void declaration
     */
    JSONStringer close(a empty, a nonempty, String closeBracket) throws JSONException {
        void var3_3;
        void var1_1;
        void var2_2;
        a a2 = this.peek();
        if (a2 != var2_2 && a2 != var1_1) {
            throw new JSONException("Nesting problem");
        }
        List<a> list = this.stack;
        list.remove(list.size() - 1);
        if (a2 == var2_2) {
            this.newline();
        }
        JSONStringer jSONStringer = this;
        jSONStringer.out.append((String)var3_3);
        return jSONStringer;
    }

    /*
     * WARNING - void declaration
     */
    public JSONStringer value(Object value) throws JSONException {
        if (!this.stack.isEmpty()) {
            void var1_1;
            if (var1_1 instanceof JSONArray) {
                ((JSONArray)var1_1).writeTo(this);
                return this;
            }
            if (var1_1 instanceof JSONObject) {
                ((JSONObject)var1_1).writeTo(this);
                return this;
            }
            this.beforeValue();
            if (var1_1 != null && !(var1_1 instanceof Boolean) && var1_1 != JSONObject.NULL) {
                if (var1_1 instanceof Number) {
                    JSONStringer jSONStringer = this;
                    jSONStringer.out.append(JSONObject.numberToString((Number)var1_1));
                    return jSONStringer;
                }
                JSONStringer jSONStringer = this;
                jSONStringer.string(var1_1.toString());
                return jSONStringer;
            }
            JSONStringer jSONStringer = this;
            jSONStringer.out.append(var1_1);
            return jSONStringer;
        }
        throw new JSONException("Nesting problem");
    }

    /*
     * WARNING - void declaration
     */
    public JSONStringer value(boolean value) throws JSONException {
        if (!this.stack.isEmpty()) {
            void var1_1;
            JSONStringer jSONStringer = this;
            jSONStringer.beforeValue();
            jSONStringer.out.append((boolean)var1_1);
            return jSONStringer;
        }
        throw new JSONException("Nesting problem");
    }

    /*
     * WARNING - void declaration
     */
    public JSONStringer value(double value) throws JSONException {
        if (!this.stack.isEmpty()) {
            void var1_1;
            JSONStringer jSONStringer = this;
            jSONStringer.beforeValue();
            jSONStringer.out.append(JSONObject.numberToString((double)var1_1));
            return jSONStringer;
        }
        throw new JSONException("Nesting problem");
    }

    /*
     * WARNING - void declaration
     */
    public JSONStringer value(long value) throws JSONException {
        if (!this.stack.isEmpty()) {
            void var1_1;
            JSONStringer jSONStringer = this;
            jSONStringer.beforeValue();
            jSONStringer.out.append((long)var1_1);
            return jSONStringer;
        }
        throw new JSONException("Nesting problem");
    }

    /*
     * WARNING - void declaration
     */
    public JSONStringer key(String name) throws JSONException {
        if (name != null) {
            void var1_1;
            JSONStringer jSONStringer = this;
            jSONStringer.beforeKey();
            jSONStringer.string((String)var1_1);
            return jSONStringer;
        }
        throw new JSONException("Names must be non-null");
    }

    public String toString() {
        if (this.out.length() == 0) {
            return null;
        }
        return this.out.toString();
    }

    static final class a
    extends Enum<a> {
        public static final /* enum */ a a = new a();
        public static final /* enum */ a b = new a();
        public static final /* enum */ a c = new a();
        public static final /* enum */ a d = new a();
        public static final /* enum */ a e = new a();
        public static final /* enum */ a f = new a();
        private static final /* synthetic */ a[] g;

        public static a[] values() {
            return (a[])g.clone();
        }

        public static a valueOf(String name) {
            String string2;
            return Enum.valueOf(a.class, string2);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{a, b, c, d, e, f};
        }

        static {
            g = com.batch.android.json.JSONStringer$a.a();
        }
    }
}

