/*
 * Decompiled with CFR 0.152.
 */
package com.batch.android;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.IntentService;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.text.TextUtils;
import com.batch.android.BatchActionActivity;
import com.batch.android.BatchActionService;
import com.batch.android.BatchLandingMessage;
import com.batch.android.BatchPushPayload;
import com.batch.android.BatchPushReceiver;
import com.batch.android.MessagingActivity;
import com.batch.android.PushNotificationType;
import com.batch.android.c.i;
import com.batch.android.c.j;
import com.batch.android.c.k;
import com.batch.android.c.l;
import com.batch.android.c.o;
import com.batch.android.c.q;
import com.batch.android.c.t;
import com.batch.android.c.v;
import com.batch.android.f.b;
import com.batch.android.f.c;
import com.batch.android.g.a;
import com.batch.android.g.d;
import com.batch.android.g.e;
import com.batch.android.h;
import com.batch.android.json.JSONException;
import com.batch.android.json.JSONObject;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

@com.batch.android.a.a
public class BatchPushService
extends IntentService {
    private static final String b = "com.batch.android.push.smallicon";
    private static final String c = "com.batch.android.push.color";
    private static final int d = -100;
    private static final String e = "push_already_shown";
    private static final int f = 20;
    protected static final String a = "batch";

    public BatchPushService() {
        super("BatchPushService");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onHandleIntent(Intent intent) {
        block15: {
            try {
                BatchPushPayload batchPushPayload;
                Bundle bundle = intent.getExtras();
                if (bundle == null || bundle.isEmpty() || !k.a(this.getApplicationContext(), intent)) break block15;
                try {
                    batchPushPayload = BatchPushPayload.payloadFromReceiverIntent(intent);
                }
                catch (BatchPushPayload.ParsingException | IllegalArgumentException exception) {
                    BatchPushReceiver.completeWakefulIntent(intent);
                    return;
                }
                if (batchPushPayload == null) {
                    return;
                }
                l l2 = batchPushPayload.a();
                if (l2 == null) {
                    return;
                }
                if (com.batch.android.g.e.q().o()) {
                    o.c("Ignoring push cause manual display is activated");
                    return;
                }
                String string = intent.getStringExtra("msg");
                String string2 = intent.getStringExtra("title");
                if (string != null && !l2.b()) {
                    BatchPushService._handleNotificationPush((Context)this, bundle, string2, string, batchPushPayload);
                }
            }
            catch (Exception exception) {
                o.a("Error while handing notification", exception);
            }
            finally {
                BatchPushReceiver.completeWakefulIntent(intent);
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    public static void _handleNotificationPush(Context context, Bundle extras, String title, String alert, BatchPushPayload payload) throws JSONException {
        NotificationCompat.Builder builder;
        Object object;
        Integer n2;
        Object object2;
        Object object3;
        l l2 = payload.a();
        if (l2 == null) {
            return;
        }
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        if (!BatchPushService._isPushValid(context, l2)) {
            return;
        }
        if (BatchPushService.a(context, extras, l2)) {
            return;
        }
        String string = l2.f();
        int n3 = BatchPushService.a(context);
        if (n3 == -100) {
            o.c(false, "Batch.Push : Not showing notifications since notification type is NONE or does not contain ALERT");
            return;
        }
        if (title == null || title.length() == 0) {
            try {
                title = context.getPackageManager().getApplicationLabel(applicationInfo).toString();
            }
            catch (Exception exception) {
                o.a(false, "Batch.Push : Unable to find label of the application. Did you correctly set your application label in the manifest?");
                return;
            }
        }
        int n4 = applicationInfo.icon;
        Integer n5 = BatchPushService.c(context);
        if (n5 != null) {
            n4 = n5;
        } else {
            int n6 = com.batch.android.g.e.q().a();
            if (n6 != 0) {
                n4 = n6;
            }
        }
        if (n4 == 0) {
            o.a(false, "Batch.Push : Unable to find icon of the application. Did you correctly set your application icon in the manifest?");
            return;
        }
        Bitmap bitmap = com.batch.android.g.e.q().j();
        if (l2.j()) {
            try {
                object3 = v.a(l2.k());
                object2 = v.a(context, (String)object3);
                if (object2 == null && (object2 = new h(context, l2.k(), l2.l()).a()) != null) {
                    v.a(context, (String)object3, object2);
                }
                if (object2 != null) {
                    bitmap = BatchPushService.a(context, object2);
                } else {
                    o.a("Unable to download custom big image, fallback on default");
                    o.a(false, "Batch.Push : Unable to download large icon image sent via payload, fallback on default");
                }
            }
            catch (Exception exception) {
                o.a("Error while downloading custom big icon image", exception);
                o.a(false, "Batch.Push : Unable to download large icon image sent via payload, fallback on default");
            }
        }
        object3 = null;
        try {
            if (Build.VERSION.SDK_INT >= 16 && l2.m()) {
                object2 = v.a(l2.n());
                n2 = v.a(context, (String)object2);
                if (n2 == null && (n2 = new h(context, l2.n(), l2.o()).a()) != null) {
                    v.a(context, (String)object2, (Bitmap)n2);
                }
                if (n2 != null) {
                    object3 = n2;
                } else {
                    o.a("Unable to download custom big picture, fallback on default");
                    o.a(false, "Batch.Push : Unable to download large big picture image sent via payload, fallback on default");
                }
            }
        }
        catch (Exception exception) {
            o.a("Error while downloading custom big picture image", exception);
            o.a(false, "Batch.Push : Unable to download big picture image sent via payload, fallback on default");
        }
        int n7 = -1;
        n2 = BatchPushService.d(context);
        n7 = n2 != null ? n2.intValue() : com.batch.android.g.e.q().m();
        Uri uri = com.batch.android.g.e.q().n();
        if (uri != null) {
            if ((n3 & 1) != 0) {
                n3 &= 0xFFFFFFFE;
            } else {
                uri = null;
            }
        }
        Intent intent = null;
        if (l2.c()) {
            try {
                if (l2.d()) {
                    throw new NullPointerException("Received scheme is empty");
                }
                object = Uri.parse((String)l2.e());
                intent = new Intent(context, BatchActionActivity.class);
                intent.addFlags(0x10000000);
                intent.putExtra("deeplink", l2.e());
                intent.setAction("batch_" + Long.toString(System.currentTimeMillis()));
            }
            catch (Exception exception) {
                o.a("Error while parsing custom scheme", exception);
                intent = null;
            }
        }
        if (intent == null) {
            intent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
            intent.setAction("batch_" + Long.toString(System.currentTimeMillis()));
            object = com.batch.android.g.e.q().i();
            if (object != null) {
                intent.addFlags(((Integer)object).intValue());
            }
        }
        BatchPushService._putPushExtraToIntent(extras, l2, intent);
        object = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0x8000000);
        int n8 = (int)(Math.random() * 2.147483647E9);
        Notification notification = null;
        if (j.a("android.support.v4.app.NotificationCompat")) {
            String string2;
            Object object4;
            Object object5;
            builder = new NotificationCompat.Builder(context);
            builder.setDefaults(n3);
            builder.setWhen(System.currentTimeMillis());
            builder.setTicker((CharSequence)alert);
            builder.setContentTitle((CharSequence)title);
            builder.setContentText((CharSequence)alert);
            builder.setSmallIcon(n4);
            builder.setContentIntent((PendingIntent)object);
            builder.setOnlyAlertOnce(true);
            builder.setAutoCancel(true);
            if (uri != null) {
                builder.setSound(uri);
            }
            if (j.a(builder, "setShowWhen")) {
                builder.setShowWhen(true);
            }
            if (n7 != -1 && j.a(builder, "setColor")) {
                builder.setColor(n7);
            }
            if (bitmap != null) {
                builder.setLargeIcon(bitmap);
            }
            if (object3 != null) {
                object5 = new NotificationCompat.BigPictureStyle(builder);
                object5.bigPicture((Bitmap)object3);
                object5.setSummaryText((CharSequence)alert);
            } else {
                object5 = new NotificationCompat.BigTextStyle(builder);
                object5.bigText((CharSequence)alert);
            }
            object5 = BatchPushService.a(context, payload, n8);
            if (object5 != null) {
                object4 = object5.iterator();
                while (object4.hasNext()) {
                    string2 = (NotificationCompat.Action)object4.next();
                    builder.addAction((NotificationCompat.Action)string2);
                }
            }
            if ((object4 = l2.q()) != null && object4 != l.a.a) {
                builder.setPriority(((l.a)((Object)object4)).b());
            }
            if ((string2 = l2.s()) != null) {
                builder.setGroup(string2);
                builder.setGroupSummary(l2.t());
            }
            notification = builder.build();
        } else {
            Object object6;
            List<com.batch.android.c> list;
            builder = new Notification.Builder(context);
            builder.setWhen(System.currentTimeMillis());
            builder.setDefaults(n3);
            builder.setTicker((CharSequence)alert);
            builder.setContentTitle((CharSequence)title);
            builder.setContentText((CharSequence)alert);
            builder.setSmallIcon(n4);
            builder.setContentIntent((PendingIntent)object);
            builder.setOnlyAlertOnce(true);
            builder.setAutoCancel(true);
            if (uri != null) {
                builder.setSound(uri);
            }
            if (bitmap != null) {
                builder.setLargeIcon(bitmap);
            }
            if (n7 != -1 && Build.VERSION.SDK_INT >= 21) {
                builder.setColor(n7);
            }
            if ((list = payload.getActions()) != null && list.size() > 0) {
                o.a(false, "Batch.Push : Push contains actions but cannot be displayed in compatibility mode. Please add the v4 support library, and make sure proguard is configured correctly.");
            }
            if (Build.VERSION.SDK_INT >= 20 && (object6 = l2.s()) != null) {
                builder.setGroup((String)object6);
                builder.setGroupSummary(l2.t());
            }
            if (Build.VERSION.SDK_INT >= 16) {
                if (object3 != null) {
                    object6 = new Notification.BigPictureStyle((Notification.Builder)builder);
                    object6.bigPicture((Bitmap)object3);
                    object6.setSummaryText((CharSequence)alert);
                } else {
                    object6 = new Notification.BigTextStyle((Notification.Builder)builder);
                    object6.bigText((CharSequence)alert);
                }
                object6 = l2.q();
                if (object6 != null && object6 != l.a.a) {
                    builder.setPriority(((l.a)((Object)object6)).a());
                }
                notification = builder.build();
            } else {
                notification = builder.getNotification();
            }
        }
        if (j.a("android.support.v4.app.NotificationManagerCompat")) {
            builder = NotificationManagerCompat.from((Context)context);
            builder.notify(a, n8, notification);
        } else {
            builder = (NotificationManager)context.getSystemService("notification");
            builder.notify(a, n8, notification);
        }
        BatchPushService._markPushIdAsShown(context, string);
    }

    private static boolean a(Context context, Bundle bundle, l l2) {
        if (!com.batch.android.g.d.a().b(true)) {
            return false;
        }
        if (!com.batch.android.g.d.a().i()) {
            return false;
        }
        if (!com.batch.android.j.c.l().k()) {
            o.c(true, "Application is in background, not sending landing");
            return false;
        }
        JSONObject jSONObject = l2.i();
        if (jSONObject == null) {
            return false;
        }
        try {
            com.batch.android.f.c.c c2 = com.batch.android.f.b.b(jSONObject);
            if (c2 != null) {
                MessagingActivity.startActivityForMessage(context, new BatchLandingMessage(bundle, jSONObject));
                BatchPushService._markPushIdAsShown(context, l2.f());
                return true;
            }
        }
        catch (c | JSONException exception) {
            o.a("BatchPushService", "Error while parsing the messaging payload. Not forwarding to foreground.", (Throwable)exception);
        }
        return false;
    }

    public static boolean _isPushValid(Context context, l batchData) {
        String string = batchData.f();
        if (string != null && BatchPushService.a(context, string)) {
            o.b("Already shown notification[" + string + "], aborting");
            return false;
        }
        String string2 = batchData.g();
        if (string2 != null && !BatchPushService.b(context, string2)) {
            o.b("Received notification[" + string + "] for another install id[" + string2 + "], aborting");
            return false;
        }
        return true;
    }

    @TargetApi(value=11)
    private static Bitmap a(Context context, Bitmap bitmap) {
        int n2 = 0;
        int n3 = 0;
        Resources resources = context.getResources();
        n2 = (int)resources.getDimension(17104902);
        n3 = (int)resources.getDimension(0x1050005);
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n3, (int)n2, (boolean)false);
    }

    private static int a(Context context) {
        int n2 = 0;
        String string = t.a(context).a("push.notiftype");
        if (string != null) {
            try {
                EnumSet<PushNotificationType> enumSet = PushNotificationType.fromValue(Integer.parseInt(string));
                if (enumSet.size() == 1 && enumSet.contains((Object)PushNotificationType.NONE) || !enumSet.contains((Object)PushNotificationType.ALERT)) {
                    return -100;
                }
                if (enumSet.contains((Object)PushNotificationType.VIBRATE)) {
                    n2 |= 2;
                }
                if (enumSet.contains((Object)PushNotificationType.SOUND)) {
                    n2 |= 1;
                }
                if (enumSet.contains((Object)PushNotificationType.LIGHTS)) {
                    n2 |= 4;
                }
            }
            catch (Exception exception) {
                o.a("Error while reading notification types. Fallback on ALL", exception);
                n2 = -1;
            }
        } else {
            n2 = -1;
        }
        return n2;
    }

    private static boolean a(Context context, String string) {
        return BatchPushService.b(context).contains(string);
    }

    public static void _markPushIdAsShown(Context context, String pushId) {
        i<String> i2 = BatchPushService.b(context);
        i2.add(pushId);
        if (!q.a(context).a(e, i2)) {
            o.a("Error while saving already shown push ids");
        }
    }

    private static i<String> b(Context context) {
        i i2 = null;
        try {
            Object object = q.a(context).b(e);
            if (object != null) {
                i2 = (i)object;
            }
        }
        catch (Exception exception) {
            o.a("Error while reading stored ids", exception);
        }
        if (i2 == null) {
            i2 = new i(20);
        }
        return i2;
    }

    private static boolean b(Context context, String string) {
        String string2 = new com.batch.android.i(context).a();
        return string.equals(string2);
    }

    private static Integer c(Context context) {
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo.metaData != null) {
                int n2 = applicationInfo.metaData.getInt(b);
                return n2 != 0 ? Integer.valueOf(n2) : null;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
        }
        catch (Exception exception) {
            o.a("Error while parsing small icon meta data", exception);
        }
        return null;
    }

    private static Integer d(Context context) {
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo.metaData != null) {
                int n2 = applicationInfo.metaData.getInt(c);
                return n2 != 0 ? Integer.valueOf(n2) : null;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
        }
        catch (Exception exception) {
            o.a("Error while parsing small icon meta data", exception);
        }
        return null;
    }

    @Nullable
    private static List<NotificationCompat.Action> a(@NonNull Context context, @NonNull BatchPushPayload batchPushPayload, int n2) {
        if (!j.a("android.support.v4.app.NotificationCompat$Action")) {
            o.a(true, "Compat actions are not present");
            return null;
        }
        List<com.batch.android.c> list = batchPushPayload.getActions();
        if (list == null || list.size() == 0) {
            return null;
        }
        ArrayList<NotificationCompat.Action> arrayList = new ArrayList<NotificationCompat.Action>();
        Bundle bundle = new Bundle();
        batchPushPayload.writeToBundle(bundle);
        int n3 = 0;
        for (com.batch.android.c c2 : list) {
            PendingIntent pendingIntent;
            ++n3;
            Intent intent = new Intent(context, c2.e ? BatchActionActivity.class : BatchActionService.class);
            intent.setAction("com.batch.android.action.exec");
            intent.putExtra("actionID", c2.c);
            intent.putExtra("args", c2.d.toString());
            intent.putExtra("notificationID", n2);
            batchPushPayload.writeToIntentExtras(intent);
            if (c2.e) {
                intent.addFlags(0x10000000);
                pendingIntent = PendingIntent.getActivity((Context)context, (int)(n3 * (int)System.currentTimeMillis()), (Intent)intent, (int)0x40000000);
            } else {
                pendingIntent = PendingIntent.getService((Context)context, (int)(n3 * (int)System.currentTimeMillis()), (Intent)intent, (int)0x40000000);
            }
            arrayList.add(new NotificationCompat.Action.Builder(BatchPushService.c(context, c2.b), (CharSequence)c2.a, pendingIntent).build());
        }
        return arrayList;
    }

    private static int c(@NonNull Context context, @Nullable String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return 0;
        }
        int n2 = com.batch.android.g.a.a().b(string);
        if (n2 == 0) {
            n2 = context.getResources().getIdentifier(string, "drawable", context.getPackageName());
        }
        return n2;
    }

    public static void _putPushExtraToIntent(Bundle fullPayload, l batchData, Intent launchIntent) {
        launchIntent.putExtra("fromPush", true);
        if (fullPayload != null && !fullPayload.isEmpty()) {
            launchIntent.putExtra("batchPushPayload", fullPayload);
        }
        if (batchData.f() != null) {
            launchIntent.putExtra("pushId", batchData.f());
        }
    }
}

