package com.batch.android.di.providers;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.batch.android.di.DI;
import com.batch.android.module.UserModule;

/**
 * isSingleton = true
 */
public final class UserModuleProvider {
  @NonNull
  public static final UserModule get() {
    UserModule instance = DI.getInstance().getSingletonInstance(UserModule.class);
    if (instance != null) {
      return instance;
    }
    instance = UserModule.provide();
    DI.getInstance().addSingletonInstance(UserModule.class, instance);
    return instance;
  }

  @Nullable
  public static final UserModule getSingleton() {
    return DI.getInstance().getSingletonInstance(UserModule.class);
  }
}
